/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.skiko.AWTKt;
import org.jetbrains.skiko.FrameDispatcher;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.GraphicsApi_jvmKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.OpenGLApi;
import org.jetbrains.skiko.OpenGLLibrary_jvmKt;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerAnalytics$DeviceAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.ContextHandler;
import org.jetbrains.skiko.context.OpenGLContextHandler;
import org.jetbrains.skiko.redrawer.AWTRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;
import org.jetbrains.skiko.redrawer.WindowsOpenGLRedrawer$Companion;
import org.jetbrains.skiko.redrawer.WindowsOpenGLRedrawer$Companion$frameDispatcher$1;
import org.jetbrains.skiko.redrawer.WindowsOpenGLRedrawer$Companion$toRedrawVisible$1;
import org.jetbrains.skiko.redrawer.WindowsOpenGLRedrawer$Companion$toRedrawVisible$2;
import org.jetbrains.skiko.redrawer.WindowsOpenGLRedrawer$device$1;
import org.jetbrains.skiko.redrawer.WindowsOpenGLRedrawerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0002R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/skiko/redrawer/WindowsOpenGLRedrawer;", "Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "adapterName", "", "getAdapterName", "()Ljava/lang/String;", "context", "", "contextHandler", "Lorg/jetbrains/skiko/context/OpenGLContextHandler;", "device", "renderInfo", "getRenderInfo", "dispose", "", "draw", "makeCurrent", "needRedraw", "redrawImmediately", "swapBuffers", "Companion", "skiko"})
public final class WindowsOpenGLRedrawer
extends AWTRedrawer {
    public static final WindowsOpenGLRedrawer$Companion Companion = new WindowsOpenGLRedrawer$Companion(null);
    private final SkiaLayer layer;
    private final SkiaLayerProperties properties;
    private final OpenGLContextHandler contextHandler;
    private final long device;
    private final long context;
    private static final Set<WindowsOpenGLRedrawer> toRedraw = new LinkedHashSet();
    private static final Set<WindowsOpenGLRedrawer> toRedrawCopy = new LinkedHashSet();
    private static final Sequence<WindowsOpenGLRedrawer> toRedrawVisible = SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)toRedrawCopy), (Function1)((Function1)WindowsOpenGLRedrawer$Companion$toRedrawVisible$1.INSTANCE)), (Function1)WindowsOpenGLRedrawer$Companion$toRedrawVisible$2.INSTANCE);
    private static final FrameDispatcher frameDispatcher = new FrameDispatcher((CoroutineContext)MainUIDispatcher_awtKt.getMainUIDispatcher(), (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new WindowsOpenGLRedrawer$Companion$frameDispatcher$1(null)));

    public WindowsOpenGLRedrawer(SkiaLayer object, SkiaLayerAnalytics object2, SkiaLayerProperties skiaLayerProperties) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerProperties, (String)"");
        super((SkiaLayer)object, (SkiaLayerAnalytics)object2, GraphicsApi.OPENGL);
        this.layer = object;
        this.properties = skiaLayerProperties;
        OpenGLLibrary_jvmKt.loadOpenGLLibrary();
        this.contextHandler = new OpenGLContextHandler(this.layer);
        this.device = ((Number)AWTKt.useDrawingSurfacePlatformInfo(this.layer.getBackedLayer$skiko(), WindowsOpenGLRedrawer$device$1.INSTANCE)).longValue();
        WindowsOpenGLRedrawer windowsOpenGLRedrawer = this;
        long l2 = WindowsOpenGLRedrawerKt.access$createContext(windowsOpenGLRedrawer.device, this.layer.getContentHandle(), this.layer.getTransparency());
        object2 = windowsOpenGLRedrawer;
        if (l2 == 0L) {
            throw new RenderException("Cannot create Windows GL context", null, 2, null);
        }
        WindowsOpenGLRedrawerKt.access$makeCurrent(this.device, l2);
        String string = this.getAdapterName();
        object = string;
        object = string;
        if (string != null && !GraphicsApi_jvmKt.isVideoCardSupported(GraphicsApi.OPENGL, OsArch_jvmKt.getHostOs(), (String)object)) {
            throw new RenderException("Cannot create Windows GL context", null, 2, null);
        }
        WindowsOpenGLRedrawer windowsOpenGLRedrawer2 = this;
        windowsOpenGLRedrawer2.onDeviceChosen(windowsOpenGLRedrawer2.getAdapterName());
        ((WindowsOpenGLRedrawer)object2).context = l2;
        this.makeCurrent();
        WindowsOpenGLRedrawerKt.access$setSwapInterval(0);
        this.onContextInit();
    }

    @Override
    public final String getRenderInfo() {
        return this.contextHandler.rendererInfo();
    }

    private final String getAdapterName() {
        return OpenGLApi.Companion.getInstance().glGetString(OpenGLApi.Companion.getInstance().getGL_RENDERER());
    }

    @Override
    public final void dispose() {
        if (!(!this.isDisposed())) {
            String string = "WindowsOpenGLRedrawer is disposed";
            throw new IllegalStateException(string.toString());
        }
        this.makeCurrent();
        this.contextHandler.dispose();
        WindowsOpenGLRedrawerKt.access$deleteContext(this.context);
        super.dispose();
    }

    @Override
    public final void needRedraw() {
        if (!(!this.isDisposed())) {
            String string = "WindowsOpenGLRedrawer is disposed";
            throw new IllegalStateException(string.toString());
        }
        toRedraw.add(this);
        frameDispatcher.scheduleFrame();
    }

    @Override
    public final void redrawImmediately() {
        if (!(!this.isDisposed())) {
            String string = "WindowsOpenGLRedrawer is disposed";
            throw new IllegalStateException(string.toString());
        }
        Object object = this;
        if (AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)object) == null) {
            object = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(object.toString());
        }
        if (!AWTRedrawer.access$isDisposed((AWTRedrawer)object)) {
            block13: {
                if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)object)) {
                    SkiaLayerAnalytics$DeviceAnalytics skiaLayerAnalytics$DeviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)object);
                    if (skiaLayerAnalytics$DeviceAnalytics != null) {
                        skiaLayerAnalytics$DeviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayer skiaLayer = AWTRedrawer.access$getLayer$p((AWTRedrawer)object);
                if (!SwingUtilities.isEventDispatchThread()) {
                    String string = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(string.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(skiaLayer))) {
                    String string = "SkiaLayer is disposed";
                    throw new IllegalStateException(string.toString());
                }
                try {
                    this.update(System.nanoTime());
                    this.makeCurrent();
                    this.contextHandler.draw();
                    this.swapBuffers();
                    OpenGLApi.Companion.getInstance().glFinish();
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException renderException) {
                    if (SkiaLayer.access$isDisposed$p(skiaLayer)) break block13;
                    Object object2 = Logger.INSTANCE;
                    if (((Logger)object2).getLoggerImpl().isWarnEnabled()) {
                        SkikoLoggerInterface skikoLoggerInterface = ((Logger)object2).getLoggerImpl();
                        object2 = renderException;
                        SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface2.warn((Throwable)object2, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(skiaLayer), false, 1, null);
                    Redrawer redrawer = skiaLayer.getRedrawer$skiko();
                    if (redrawer == null) break block13;
                    redrawer.redrawImmediately();
                }
            }
            if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)object) && !AWTRedrawer.access$isDisposed((AWTRedrawer)object)) {
                SkiaLayerAnalytics$DeviceAnalytics skiaLayerAnalytics$DeviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)object);
                if (skiaLayerAnalytics$DeviceAnalytics != null) {
                    skiaLayerAnalytics$DeviceAnalytics.afterFirstFrameRender();
                }
            }
            AWTRedrawer.access$setFirstFrameRendered$p((AWTRedrawer)object, true);
        }
    }

    private final void draw() {
        Object object = this;
        Object object2 = this.contextHandler;
        if (AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)object) == null) {
            object = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(object.toString());
        }
        if (!AWTRedrawer.access$isDisposed((AWTRedrawer)object)) {
            block12: {
                if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)object)) {
                    SkiaLayerAnalytics$DeviceAnalytics skiaLayerAnalytics$DeviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)object);
                    if (skiaLayerAnalytics$DeviceAnalytics != null) {
                        skiaLayerAnalytics$DeviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayer skiaLayer = AWTRedrawer.access$getLayer$p((AWTRedrawer)object);
                if (!SwingUtilities.isEventDispatchThread()) {
                    object2 = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(object2.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(skiaLayer))) {
                    object2 = "SkiaLayer is disposed";
                    throw new IllegalStateException(object2.toString());
                }
                try {
                    ((ContextHandler)object2).draw();
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException renderException) {
                    if (SkiaLayer.access$isDisposed$p(skiaLayer)) break block12;
                    object2 = Logger.INSTANCE;
                    if (((Logger)object2).getLoggerImpl().isWarnEnabled()) {
                        SkikoLoggerInterface skikoLoggerInterface = ((Logger)object2).getLoggerImpl();
                        object2 = renderException;
                        SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface2.warn((Throwable)object2, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(skiaLayer), false, 1, null);
                    Redrawer redrawer = skiaLayer.getRedrawer$skiko();
                    if (redrawer == null) break block12;
                    redrawer.redrawImmediately();
                }
            }
            if (!AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)object) && !AWTRedrawer.access$isDisposed((AWTRedrawer)object)) {
                SkiaLayerAnalytics$DeviceAnalytics skiaLayerAnalytics$DeviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)object);
                if (skiaLayerAnalytics$DeviceAnalytics != null) {
                    skiaLayerAnalytics$DeviceAnalytics.afterFirstFrameRender();
                }
            }
            AWTRedrawer.access$setFirstFrameRendered$p((AWTRedrawer)object, true);
        }
    }

    private final void makeCurrent() {
        WindowsOpenGLRedrawerKt.access$makeCurrent(this.device, this.context);
    }

    private final void swapBuffers() {
        WindowsOpenGLRedrawerKt.access$swapBuffers(this.device);
    }

    public static final /* synthetic */ SkiaLayer access$getLayer$p(WindowsOpenGLRedrawer windowsOpenGLRedrawer) {
        return windowsOpenGLRedrawer.layer;
    }

    public static final /* synthetic */ Set access$getToRedrawCopy$cp() {
        return toRedrawCopy;
    }

    public static final /* synthetic */ Set access$getToRedraw$cp() {
        return toRedraw;
    }

    public static final /* synthetic */ Sequence access$getToRedrawVisible$cp() {
        return toRedrawVisible;
    }

    public static final /* synthetic */ void access$makeCurrent(WindowsOpenGLRedrawer windowsOpenGLRedrawer) {
        windowsOpenGLRedrawer.makeCurrent();
    }

    public static final /* synthetic */ void access$draw(WindowsOpenGLRedrawer windowsOpenGLRedrawer) {
        windowsOpenGLRedrawer.draw();
    }

    public static final /* synthetic */ void access$swapBuffers(WindowsOpenGLRedrawer windowsOpenGLRedrawer) {
        windowsOpenGLRedrawer.swapBuffers();
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(WindowsOpenGLRedrawer windowsOpenGLRedrawer) {
        return windowsOpenGLRedrawer.properties;
    }
}

