/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.LinuxOpenGLSwingRedrawer$onRender$1;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0082 J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0011\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0082 J\u0011\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0082 J\u0011\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\fH\u0082 J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0011\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\fH\u0082 J)\u0010$\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0082 J\t\u0010&\u001a\u00020\fH\u0082 J(\u0010'\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\fH\u0014J\u0019\u0010)\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0082 J\u0011\u0010*\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\fH\u0082 R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/skiko/swing/LinuxOpenGLSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "bytesToDraw", "", "offScreenBufferPtr", "", "offScreenContextPtr", "storage", "Lorg/jetbrains/skia/Bitmap;", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "createAndBindTexture", "width", "", "height", "dispose", "", "disposeOffScreenBuffer", "bufferPtr", "disposeOffScreenContext", "contextPtr", "finishRendering", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "getFboId", "texturePtr", "makeOffScreenBuffer", "oldBufferPtr", "makeOffScreenContext", "onRender", "nanoTime", "startRendering", "unbindAndDisposeTexture", "skiko"})
public final class LinuxOpenGLSwingRedrawer
extends SwingRedrawerBase {
    private final SkikoRenderDelegate renderDelegate;
    private final SwingOffscreenDrawer swingOffscreenDrawer;
    private final long offScreenContextPtr;
    private long offScreenBufferPtr;
    private final Bitmap storage;
    private byte[] bytesToDraw;

    public LinuxOpenGLSwingRedrawer(SwingLayerProperties object, SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)skikoRenderDelegate, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        super((SwingLayerProperties)object, skiaLayerAnalytics, GraphicsApi.OPENGL);
        this.renderDelegate = skikoRenderDelegate;
        this.onDeviceChosen("OpenGL OffScreen");
        this.swingOffscreenDrawer = new SwingOffscreenDrawer((SwingLayerProperties)object);
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        long l2 = linuxOpenGLSwingRedrawer.makeOffScreenContext();
        object = linuxOpenGLSwingRedrawer;
        if (l2 == 0L) {
            throw new RenderException("Cannot create OpenGL context", null, 2, null);
        }
        ((LinuxOpenGLSwingRedrawer)object).offScreenContextPtr = l2;
        this.storage = new Bitmap();
        this.bytesToDraw = new byte[0];
        this.onContextInit();
    }

    @Override
    public final void dispose() {
        this.bytesToDraw = new byte[0];
        this.storage.close();
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        linuxOpenGLSwingRedrawer.disposeOffScreenBuffer(linuxOpenGLSwingRedrawer.offScreenBufferPtr);
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
        linuxOpenGLSwingRedrawer2.disposeOffScreenContext(linuxOpenGLSwingRedrawer2.offScreenContextPtr);
        super.dispose();
    }

    @Override
    protected final void onRender(Graphics2D graphics2D, int n, int n2, long l2) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        this.offScreenBufferPtr = this.makeOffScreenBuffer(this.offScreenContextPtr, this.offScreenBufferPtr, n, n2);
        if (this.offScreenBufferPtr == 0L) {
            throw new RenderException("Cannot create offScreen OpenGL buffer", null, 2, null);
        }
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        linuxOpenGLSwingRedrawer.startRendering(linuxOpenGLSwingRedrawer.offScreenContextPtr, this.offScreenBufferPtr);
        try {
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new LinuxOpenGLSwingRedrawer$onRender$1(this, n, n2, l2, graphics2D)));
            LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
            linuxOpenGLSwingRedrawer2.finishRendering(linuxOpenGLSwingRedrawer2.offScreenContextPtr);
            return;
        }
        catch (Throwable throwable) {
            LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer3 = this;
            linuxOpenGLSwingRedrawer3.finishRendering(linuxOpenGLSwingRedrawer3.offScreenContextPtr);
            throw throwable;
        }
    }

    private final void flush(Surface surface, Graphics2D graphics2D) {
        surface.flushAndSubmit(true);
        int n = surface.getWidth();
        int n2 = surface.getHeight();
        int n3 = n << 2;
        if (this.storage.getWidth() != n || this.storage.getHeight() != n2) {
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(n, n2, ColorAlphaType.PREMUL), false);
            this.bytesToDraw = new byte[Bitmap.getReadPixelsArraySize$skiko$default(this.storage, null, n3, 0, 5, null)];
        }
        surface.readPixels(this.storage, 0, 0);
        boolean bl = Bitmap.readPixels$skiko$default(this.storage, this.bytesToDraw, null, n3, 0, 0, 26, null);
        if (bl) {
            this.swingOffscreenDrawer.draw(graphics2D, this.bytesToDraw, n, n2);
        }
    }

    private final native long makeOffScreenContext();

    private final native long disposeOffScreenContext(long var1);

    private final native long makeOffScreenBuffer(long var1, long var3, int var5, int var6);

    private final native void disposeOffScreenBuffer(long var1);

    private final native void startRendering(long var1, long var3);

    private final native void finishRendering(long var1);

    private final native long createAndBindTexture(int var1, int var2);

    private final native int getFboId(long var1);

    private final native void unbindAndDisposeTexture(long var1);

    public static final /* synthetic */ long access$createAndBindTexture(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer, int n, int n2) {
        return linuxOpenGLSwingRedrawer.createAndBindTexture(n, n2);
    }

    public static final /* synthetic */ int access$getFboId(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer, long l2) {
        return linuxOpenGLSwingRedrawer.getFboId(l2);
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer) {
        return linuxOpenGLSwingRedrawer.renderDelegate;
    }

    public static final /* synthetic */ void access$flush(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer, Surface surface, Graphics2D graphics2D) {
        linuxOpenGLSwingRedrawer.flush(surface, graphics2D);
    }

    public static final /* synthetic */ void access$unbindAndDisposeTexture(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer, long l2) {
        linuxOpenGLSwingRedrawer.unbindAndDisposeTexture(l2);
    }
}

