/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.door;

import com.ustadmobile.door.DatabaseBuilder;
import com.ustadmobile.door.DoorDatabaseCallback;
import com.ustadmobile.door.DoorDatabaseCallbackStatementList;
import com.ustadmobile.door.DoorDatabaseCallbackSync;
import com.ustadmobile.door.DoorDbType;
import com.ustadmobile.door.DoorSqlDatabaseConnectionImpl;
import com.ustadmobile.door.ext.DoorDatabaseExtJvmKt;
import com.ustadmobile.door.jdbc.ext.ResultSetExtKt;
import com.ustadmobile.door.log.DoorLogger;
import com.ustadmobile.door.log.DoorLoggerExtKt;
import com.ustadmobile.door.log.NapierDoorLogger;
import com.ustadmobile.door.message.DefaultDoorMessageCallback;
import com.ustadmobile.door.message.DoorMessageCallback;
import com.ustadmobile.door.migration.DoorMigration;
import com.ustadmobile.door.migration.DoorMigrationAsync;
import com.ustadmobile.door.migration.DoorMigrationStatementList;
import com.ustadmobile.door.migration.DoorMigrationSync;
import com.ustadmobile.door.room.RoomDatabase;
import com.ustadmobile.door.room.RoomJdbcImpl;
import com.ustadmobile.door.triggers.TriggerSetupJvmKt;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 $*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001$Bg\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001a\u001a\u00020\u0016J%\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u001d\"\u00020\u0018\u00a2\u0006\u0002\u0010\u001eJ\u000b\u0010\u001f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ustadmobile/door/DatabaseBuilder;", "T", "Lcom/ustadmobile/door/room/RoomDatabase;", "", "dbClass", "Lkotlin/reflect/KClass;", "dbUrl", "", "nodeId", "", "dbUsername", "dbPassword", "queryTimeout", "", "messageCallback", "Lcom/ustadmobile/door/message/DoorMessageCallback;", "logger", "Lcom/ustadmobile/door/log/DoorLogger;", "dbName", "(Lkotlin/reflect/KClass;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;ILcom/ustadmobile/door/message/DoorMessageCallback;Lcom/ustadmobile/door/log/DoorLogger;Ljava/lang/String;)V", "callbacks", "", "Lcom/ustadmobile/door/DoorDatabaseCallback;", "migrationList", "Lcom/ustadmobile/door/migration/DoorMigration;", "addCallback", "callback", "addMigrations", "migrations", "", "([Lcom/ustadmobile/door/migration/DoorMigration;)Lcom/ustadmobile/door/DatabaseBuilder;", "build", "()Lcom/ustadmobile/door/room/RoomDatabase;", "name", "", "seconds", "Companion", "door-runtime"})
@SourceDebugExtension(value={"SMAP\nDatabaseBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseBuilder.kt\ncom/ustadmobile/door/DatabaseBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,274:1\n1#2:275\n1747#3,3:276\n1855#3,2:279\n1855#3,2:281\n1855#3:283\n1856#3:286\n766#3:287\n857#3,2:288\n1963#3,14:290\n1855#3,2:304\n1855#3,2:306\n1855#3:308\n1856#3:311\n37#4,2:284\n37#4,2:309\n*S KotlinDebug\n*F\n+ 1 DatabaseBuilder.kt\ncom/ustadmobile/door/DatabaseBuilder\n*L\n132#1:276,3\n135#1:279,2\n144#1:281,2\n151#1:283\n151#1:286\n186#1:287\n186#1:288,2\n187#1:290,14\n195#1:304,2\n213#1:306,2\n220#1:308\n220#1:311\n155#1:284,2\n224#1:309,2\n*E\n"})
public final class DatabaseBuilder<T extends RoomDatabase> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private KClass<T> dbClass;
    @NotNull
    private String dbUrl;
    private long nodeId;
    @Nullable
    private String dbUsername;
    @Nullable
    private String dbPassword;
    private int queryTimeout;
    @NotNull
    private DoorMessageCallback<T> messageCallback;
    @NotNull
    private DoorLogger logger;
    @NotNull
    private String dbName;
    @NotNull
    private final List<DoorDatabaseCallback> callbacks;
    @NotNull
    private final List<DoorMigration> migrationList;

    public DatabaseBuilder(@NotNull KClass<T> dbClass, @NotNull String dbUrl, long nodeId2, @Nullable String dbUsername, @Nullable String dbPassword, int queryTimeout, @NotNull DoorMessageCallback<T> messageCallback, @NotNull DoorLogger logger, @NotNull String dbName) {
        Intrinsics.checkNotNullParameter(dbClass, (String)"dbClass");
        Intrinsics.checkNotNullParameter((Object)dbUrl, (String)"dbUrl");
        Intrinsics.checkNotNullParameter(messageCallback, (String)"messageCallback");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        this.dbClass = dbClass;
        this.dbUrl = dbUrl;
        this.nodeId = nodeId2;
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.queryTimeout = queryTimeout;
        this.messageCallback = messageCallback;
        this.logger = logger;
        this.dbName = dbName;
        this.callbacks = new ArrayList();
        this.migrationList = new ArrayList();
    }

    public /* synthetic */ DatabaseBuilder(KClass kClass, String string, long l, String string2, String string3, int n, DoorMessageCallback doorMessageCallback, DoorLogger doorLogger, String string4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            n = 10;
        }
        if ((n2 & 0x40) != 0) {
            doorMessageCallback = new DefaultDoorMessageCallback();
        }
        if ((n2 & 0x80) != 0) {
            doorLogger = new NapierDoorLogger(null, 1, null);
        }
        if ((n2 & 0x100) != 0) {
            string4 = string;
        }
        this(kClass, string, l, string2, string3, n, doorMessageCallback, doorLogger, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final T build() {
        DataSource dataSource;
        String[] stringArray;
        String string;
        Object object;
        String logPrefix = "[DatabaseBuilder.build - " + this.dbName + "]";
        if (StringsKt.startsWith$default((String)this.dbUrl, (String)"jdbc:", (boolean)false, (int)2, null)) {
            Object object2;
            String jdbcUrlType = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)this.dbUrl, (String)"jdbc:", null, (int)2, null), (String)":", null, (int)2, null);
            if (!Intrinsics.areEqual((Object)jdbcUrlType, (Object)"postgresql") && !Intrinsics.areEqual((Object)jdbcUrlType, (Object)"sqlite")) {
                throw new IllegalArgumentException("Invalid database type: " + jdbcUrlType + " - only postgres and sqlite are supported");
            }
            if (Intrinsics.areEqual((Object)jdbcUrlType, (Object)"sqlite")) {
                void $this$build_u24lambda_u242_u24lambda_u241;
                String $this$build_u24lambda_u242_u24lambda_u240;
                String[] $this$build_u24lambda_u242 = object = new HikariConfig();
                boolean bl = false;
                if (StringsKt.endsWith$default((String)this.dbUrl, (String)":memory:", (boolean)false, (int)2, null)) {
                    $this$build_u24lambda_u242.setMaximumPoolSize(1);
                    $this$build_u24lambda_u242.setMinimumIdle(1);
                    $this$build_u24lambda_u242.setMaxLifetime(Long.MAX_VALUE);
                }
                String string2 = string = new SQLiteConfig();
                stringArray = $this$build_u24lambda_u242;
                boolean bl2 = false;
                $this$build_u24lambda_u242_u24lambda_u240.setJournalMode(SQLiteConfig.JournalMode.WAL);
                $this$build_u24lambda_u242_u24lambda_u240.setBusyTimeout(30000);
                $this$build_u24lambda_u242_u24lambda_u240.setSynchronous(SQLiteConfig.SynchronousMode.OFF);
                $this$build_u24lambda_u242_u24lambda_u240.enableRecursiveTriggers(true);
                $this$build_u24lambda_u242.setAutoCommit(true);
                String string3 = string;
                $this$build_u24lambda_u242_u24lambda_u240 = string = new SQLiteDataSource((SQLiteConfig)string3);
                boolean bl3 = false;
                $this$build_u24lambda_u242_u24lambda_u241.setUrl(this.dbUrl);
                stringArray.setDataSource((DataSource)((Object)string));
                Object object3 = object;
                object2 = new HikariDataSource((HikariConfig)object3);
            } else {
                String it;
                String[] $this$build_u24lambda_u245 = object = new HikariDataSource();
                boolean bl = false;
                $this$build_u24lambda_u245.setJdbcUrl(this.dbUrl);
                String string4 = this.dbUsername;
                if (string4 != null) {
                    it = string = string4;
                    boolean bl4 = false;
                    $this$build_u24lambda_u245.setUsername(it);
                    v2 = string;
                } else {
                    v2 = null;
                }
                String string5 = this.dbPassword;
                if (string5 != null) {
                    it = string = string5;
                    boolean bl5 = false;
                    $this$build_u24lambda_u245.setPassword(it);
                    v4 = string;
                } else {
                    v4 = null;
                }
                $this$build_u24lambda_u245.setAutoCommit(true);
                object2 = object;
            }
            dataSource = (DataSource)object2;
        } else if (StringsKt.startsWith$default((String)this.dbUrl, (String)"java:/", (boolean)false, (int)2, null)) {
            InitialContext iContext = new InitialContext();
            Object object4 = iContext.lookup(this.dbUrl);
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type javax.sql.DataSource");
            dataSource = (DataSource)object4;
        } else {
            throw new IllegalArgumentException("Invalid database url: " + this.dbUrl + " : must be either a valid jdbc Postgres or SQLite URL, or JNDI path ");
        }
        DataSource dataSource2 = dataSource;
        AutoCloseable autoCloseable = dataSource2.getConnection();
        object = null;
        try {
            Object object5;
            Iterable $this$forEach$iv;
            Object it;
            DoorSqlDatabaseConnectionImpl sqlDatabase;
            RoomDatabase doorDb;
            block83: {
                AutoCloseable $this$maxByOrNull$iv2;
                Iterable $this$forEach$iv2;
                boolean dbWillBeMigrated;
                ResultSet resultSet;
                int dbType;
                Connection connection;
                block82: {
                    boolean $i$f$forEach;
                    Iterable $this$forEach$iv3;
                    Object stmt2;
                    boolean bl;
                    Object $this$any$iv;
                    block78: {
                        String string6;
                        connection = (Connection)autoCloseable;
                        boolean bl6 = false;
                        DatabaseMetaData databaseMetaData = connection.getMetaData();
                        String string7 = string = databaseMetaData != null ? databaseMetaData.getDatabaseProductName() : null;
                        if (string7 == null) {
                            string6 = "";
                        } else {
                            Intrinsics.checkNotNull((Object)string7);
                            string6 = string;
                        }
                        dbType = DoorDbType.Companion.typeIntFromProductName(string6);
                        Class<?> clazz = Class.forName(JvmClassMappingKt.getJavaClass(this.dbClass).getCanonicalName() + "_JdbcImpl");
                        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<T of com.ustadmobile.door.DatabaseBuilder.build$lambda$20>");
                        Class<?> dbImplClass = clazz;
                        Object[] bl5 = new Class[]{RoomDatabase.class, DataSource.class, String.class, String.class, Integer.TYPE, Integer.TYPE, DoorLogger.class};
                        Constructor<?> constructor = dbImplClass.getConstructor((Class<?>[])bl5);
                        bl5 = new Object[]{null, dataSource2, this.dbUrl, this.dbName, this.queryTimeout, dbType, this.logger};
                        doorDb = (RoomDatabase)constructor.newInstance(bl5);
                        Intrinsics.checkNotNull((Object)connection);
                        sqlDatabase = new DoorSqlDatabaseConnectionImpl(connection, dbType);
                        stringArray = new String[]{"TABLE"};
                        ResultSet resultSet2 = connection.getMetaData().getTables(null, null, "%", stringArray);
                        Intrinsics.checkNotNullExpressionValue((Object)resultSet2, (String)"getTables(...)");
                        List tableNames2 = (List)ResultSetExtKt.useResults(resultSet2, build.1.tableNames.1.INSTANCE);
                        $this$any$iv = tableNames2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                Object element$iv = iterator.next();
                                it = (String)element$iv;
                                boolean bl7 = false;
                                String string8 = ((String)it).toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
                                if (!Intrinsics.areEqual((Object)string8, (Object)"_doorwayinfo")) continue;
                                bl = true;
                                break block78;
                            }
                            bl = false;
                        }
                    }
                    if (bl) break block82;
                    $this$any$iv = connection.createStatement();
                    Throwable $i$f$any = null;
                    try {
                        stmt2 = (Statement)$this$any$iv;
                        boolean bl8 = false;
                        $this$forEach$iv3 = doorDb.createAllTables();
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv3) {
                            String sql = (String)element$iv;
                            boolean bl9 = false;
                            stmt2.executeUpdate(sql);
                        }
                        stmt2 = Unit.INSTANCE;
                    }
                    catch (Throwable stmt2) {
                        $i$f$any = stmt2;
                        throw stmt2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)$this$any$iv, (Throwable)$i$f$any);
                    }
                    $this$any$iv = connection.createStatement();
                    $i$f$any = null;
                    try {
                        stmt2 = (Statement)$this$any$iv;
                        boolean bl10 = false;
                        $this$forEach$iv3 = TriggerSetupJvmKt.createTriggerSetupStatementList(DoorDatabaseExtJvmKt.doorDatabaseMetadata(this.dbClass), dbType);
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv3) {
                            String triggerSetupSql = (String)element$iv;
                            boolean bl11 = false;
                            stmt2.addBatch(triggerSetupSql);
                        }
                        stmt2.executeBatch();
                        DoorLoggerExtKt.v$default(this.logger, null, (Function0)new Function0<String>(logPrefix){
                            final /* synthetic */ String $logPrefix;
                            {
                                this.$logPrefix = $logPrefix;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return this.$logPrefix + " : created tables";
                            }
                        }, 1, null);
                        stmt2 = Unit.INSTANCE;
                    }
                    catch (Throwable stmt3) {
                        $i$f$any = stmt3;
                        throw stmt3;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)$this$any$iv, (Throwable)$i$f$any);
                    }
                    $this$forEach$iv = this.callbacks;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (DoorDatabaseCallback)element$iv;
                        boolean bl12 = false;
                        object5 = it;
                        if (object5 instanceof DoorDatabaseCallbackSync) {
                            ((DoorDatabaseCallbackSync)it).onCreate(sqlDatabase);
                            continue;
                        }
                        if (!(object5 instanceof DoorDatabaseCallbackStatementList)) continue;
                        Collection $this$toTypedArray$iv = ((DoorDatabaseCallbackStatementList)it).onCreate(sqlDatabase);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        sqlDatabase.execSQLBatch(thisCollection$iv.toArray(new String[0]));
                    }
                    break block83;
                }
                Statement stmt = null;
                ResultSet resultSet3 = null;
                int currentDbVersion = 0;
                currentDbVersion = -1;
                try {
                    stmt = connection.createStatement();
                    resultSet3 = stmt.executeQuery("SELECT dbVersion FROM _doorwayinfo");
                    if (resultSet3.next()) {
                        currentDbVersion = resultSet3.getInt(1);
                    }
                    resultSet = resultSet3;
                }
                catch (SQLException e2) {
                    try {
                        throw e2;
                    }
                    catch (Throwable e2) {
                        ResultSet resultSet4 = resultSet3;
                        if (resultSet4 != null) {
                            resultSet4.close();
                            v20 = Unit.INSTANCE;
                        } else {
                            v20 = null;
                        }
                        Statement statement = stmt;
                        if (statement != null) {
                            statement.close();
                            v22 = Unit.INSTANCE;
                        } else {
                            v22 = null;
                        }
                        throw e2;
                    }
                }
                if (resultSet != null) {
                    resultSet.close();
                    v16 = Unit.INSTANCE;
                } else {
                    v16 = null;
                }
                Statement statement = stmt;
                if (statement != null) {
                    statement.close();
                    v18 = Unit.INSTANCE;
                } else {
                    v18 = null;
                }
                boolean bl = dbWillBeMigrated = currentDbVersion < doorDb.getDbVersion();
                if (dbWillBeMigrated) {
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sqlDatabase, null){
                        int label;
                        final /* synthetic */ DoorSqlDatabaseConnectionImpl $sqlDatabase;
                        {
                            this.$sqlDatabase = $sqlDatabase;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = TriggerSetupJvmKt.dropDoorTriggersAndReceiveViews$default(this.$sqlDatabase.getConnection(), null, null, (Continuation)this, 3, null);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                }
                while (currentDbVersion < doorDb.getDbVersion()) {
                    Object v24;
                    DoorMigration $this$maxByOrNull$iv2;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.migrationList;
                    boolean $i$f$filter = false;
                    Iterable $this$toTypedArray$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        DoorMigration it2 = (DoorMigration)element$iv$iv;
                        boolean bl13 = false;
                        if (!(it2.getStartVersion() == currentDbVersion)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$maxByOrNull2 = false;
                    Iterator iterator$iv = $this$maxByOrNull$iv2.iterator();
                    if (!iterator$iv.hasNext()) {
                        v24 = null;
                    } else {
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v24 = maxElem$iv;
                        } else {
                            DoorMigration it3 = (DoorMigration)maxElem$iv;
                            boolean bl14 = false;
                            int maxValue$iv = it3.getEndVersion();
                            do {
                                Object e$iv = iterator$iv.next();
                                DoorMigration it4 = (DoorMigration)e$iv;
                                $i$a$-maxByOrNull-DatabaseBuilder$build$1$nextMigration$2 = false;
                                int v$iv = it4.getEndVersion();
                                if (maxValue$iv >= v$iv) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v24 = maxElem$iv;
                        }
                    }
                    DoorMigration nextMigration = v24;
                    if (nextMigration != null) {
                        DoorLoggerExtKt.v$default(this.logger, null, (Function0)new Function0<String>(logPrefix, nextMigration){
                            final /* synthetic */ String $logPrefix;
                            final /* synthetic */ DoorMigration $nextMigration;
                            {
                                this.$logPrefix = $logPrefix;
                                this.$nextMigration = $nextMigration;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return this.$logPrefix + " start update from " + this.$nextMigration.getStartVersion() + " to " + this.$nextMigration.getEndVersion();
                            }
                        }, 1, null);
                        $this$maxByOrNull$iv2 = nextMigration;
                        if ($this$maxByOrNull$iv2 instanceof DoorMigrationSync) {
                            ((DoorMigrationSync)nextMigration).getMigrateFn().invoke((Object)sqlDatabase);
                        } else if ($this$maxByOrNull$iv2 instanceof DoorMigrationAsync) {
                            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(nextMigration, sqlDatabase, null){
                                int label;
                                final /* synthetic */ DoorMigration $nextMigration;
                                final /* synthetic */ DoorSqlDatabaseConnectionImpl $sqlDatabase;
                                {
                                    this.$nextMigration = $nextMigration;
                                    this.$sqlDatabase = $sqlDatabase;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = ((DoorMigrationAsync)this.$nextMigration).getMigrateFn().invoke((Object)this.$sqlDatabase, (Object)((Object)this));
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null);
                        } else if ($this$maxByOrNull$iv2 instanceof DoorMigrationStatementList) {
                            AutoCloseable $i$f$maxByOrNull2 = connection.createStatement();
                            iterator$iv = null;
                            try {
                                Object migrateStmt2 = (Statement)$i$f$maxByOrNull2;
                                boolean bl15 = false;
                                $this$forEach$iv2 = (Iterable)((DoorMigrationStatementList)nextMigration).getMigrateStmts().invoke((Object)sqlDatabase);
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv2) {
                                    String it5 = (String)element$iv;
                                    boolean bl16 = false;
                                    migrateStmt2.addBatch(it5);
                                }
                                migrateStmt2 = migrateStmt2.executeBatch();
                            }
                            catch (Throwable migrateStmt2) {
                                try {
                                    iterator$iv = migrateStmt2;
                                    throw migrateStmt2;
                                }
                                catch (Throwable migrateStmt2) {
                                    AutoCloseableKt.closeFinally((AutoCloseable)$i$f$maxByOrNull2, iterator$iv);
                                    throw migrateStmt2;
                                }
                            }
                            AutoCloseableKt.closeFinally((AutoCloseable)$i$f$maxByOrNull2, (Throwable)((Object)iterator$iv));
                        }
                        currentDbVersion = nextMigration.getEndVersion();
                        sqlDatabase.execSQL("UPDATE _doorwayinfo SET dbVersion = " + currentDbVersion);
                        DoorLoggerExtKt.v$default(this.logger, null, (Function0)new Function0<String>(logPrefix, nextMigration){
                            final /* synthetic */ String $logPrefix;
                            final /* synthetic */ DoorMigration $nextMigration;
                            {
                                this.$logPrefix = $logPrefix;
                                this.$nextMigration = $nextMigration;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return this.$logPrefix + " finish update from " + this.$nextMigration.getStartVersion() + " to " + this.$nextMigration.getEndVersion();
                            }
                        }, 1, null);
                        continue;
                    }
                    throw new IllegalStateException("Need to migrate to version " + doorDb.getDbVersion() + " from " + currentDbVersion + " - could not find next migration");
                }
                Connection it6 = $this$maxByOrNull$iv2 = connection;
                boolean bl172 = false;
                Connection connection2 = dbWillBeMigrated ? $this$maxByOrNull$iv2 : null;
                if (connection2 != null && (connection2 = ($this$maxByOrNull$iv2 = connection2.createStatement())) != null) {
                    Intrinsics.checkNotNull((Object)connection2);
                    object5 = $this$maxByOrNull$iv2;
                    Throwable bl172 = null;
                    try {
                        Object statement2 = (Statement)object5;
                        boolean bl18 = false;
                        $this$forEach$iv2 = TriggerSetupJvmKt.createTriggerSetupStatementList(DoorDatabaseExtJvmKt.doorDatabaseMetadata(this.dbClass), dbType);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            String sql = (String)element$iv;
                            boolean bl19 = false;
                            statement2.addBatch(sql);
                        }
                        statement2 = statement2.executeBatch();
                        v26 = statement2;
                    }
                    catch (Throwable statement2) {
                        bl172 = statement2;
                        throw statement2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object5, (Throwable)bl172);
                    }
                } else {
                    v26 = null;
                }
            }
            $this$forEach$iv = this.callbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (DoorDatabaseCallback)element$iv;
                boolean bl = false;
                object5 = it;
                if (object5 instanceof DoorDatabaseCallbackSync) {
                    ((DoorDatabaseCallbackSync)it).onOpen(sqlDatabase);
                    continue;
                }
                if (!(object5 instanceof DoorDatabaseCallbackStatementList)) continue;
                Collection $this$toTypedArray$iv = ((DoorDatabaseCallbackStatementList)it).onOpen(sqlDatabase);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                sqlDatabase.execSQLBatch(thisCollection$iv.toArray(new String[0]));
            }
            Intrinsics.checkNotNull((Object)doorDb, (String)"null cannot be cast to non-null type com.ustadmobile.door.room.RoomJdbcImpl");
            ((RoomJdbcImpl)((Object)doorDb)).getJdbcImplHelper().onStartChangeTracking$door_runtime();
            Class<?> clazz = Class.forName(JvmClassMappingKt.getJavaClass(this.dbClass).getCanonicalName() + "_DoorWrapper");
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<T of com.ustadmobile.door.DatabaseBuilder.build$lambda$20>");
            Class<?> wrapperClass = clazz;
            Object[] objectArray = new Class[]{JvmClassMappingKt.getJavaClass(this.dbClass), Long.TYPE, DoorMessageCallback.class, DoorLogger.class, String.class};
            Constructor<?> constructor = wrapperClass.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{doorDb, this.nodeId, this.messageCallback, this.logger, this.dbName};
            RoomDatabase dbWrapped = (RoomDatabase)constructor.newInstance(objectArray);
            DoorLoggerExtKt.i$default(this.logger, logPrefix + " database build complete", null, 2, null);
            Intrinsics.checkNotNull((Object)dbWrapped);
            RoomDatabase roomDatabase = dbWrapped;
            return (T)roomDatabase;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
    }

    @NotNull
    public final DatabaseBuilder<T> addCallback(@NotNull DoorDatabaseCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.add(callback);
        return this;
    }

    @NotNull
    public final DatabaseBuilder<T> addMigrations(DoorMigration ... migrations) {
        Intrinsics.checkNotNullParameter((Object)migrations, (String)"migrations");
        CollectionsKt.addAll((Collection)this.migrationList, (Object[])migrations);
        return this;
    }

    @NotNull
    public final DatabaseBuilder<T> messageCallback(@NotNull DoorMessageCallback<T> messageCallback) {
        Intrinsics.checkNotNullParameter(messageCallback, (String)"messageCallback");
        this.messageCallback = messageCallback;
        return this;
    }

    @NotNull
    public final DatabaseBuilder<T> logger(@NotNull DoorLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        return this;
    }

    @NotNull
    public final DatabaseBuilder<T> name(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.dbName = name;
        return this;
    }

    public final void queryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/ustadmobile/door/DatabaseBuilder$Companion;", "", "()V", "databaseBuilder", "Lcom/ustadmobile/door/DatabaseBuilder;", "T", "Lcom/ustadmobile/door/room/RoomDatabase;", "dbClass", "Lkotlin/reflect/KClass;", "dbUrl", "", "nodeId", "", "dbUsername", "dbPassword", "queryTimeout", "", "door-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends RoomDatabase> DatabaseBuilder<T> databaseBuilder(@NotNull KClass<T> dbClass, @NotNull String dbUrl, long nodeId2, @Nullable String dbUsername, @Nullable String dbPassword, int queryTimeout) {
            Intrinsics.checkNotNullParameter(dbClass, (String)"dbClass");
            Intrinsics.checkNotNullParameter((Object)dbUrl, (String)"dbUrl");
            return new DatabaseBuilder(dbClass, dbUrl, nodeId2, dbUsername, dbPassword, queryTimeout, null, null, null, 448, null);
        }

        public static /* synthetic */ DatabaseBuilder databaseBuilder$default(Companion companion, KClass kClass, String string, long l, String string2, String string3, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                string2 = null;
            }
            if ((n2 & 0x10) != 0) {
                string3 = null;
            }
            if ((n2 & 0x20) != 0) {
                n = 10;
            }
            return companion.databaseBuilder(kClass, string, l, string2, string3, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

