/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.job;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.List;
import javax.annotation.Nullable;
import net.bramp.ffmpeg.FFmpeg;
import net.bramp.ffmpeg.builder.FFmpegBuilder;
import net.bramp.ffmpeg.job.FFmpegJob;
import net.bramp.ffmpeg.progress.ProgressListener;

public class SinglePassFFmpegJob
extends FFmpegJob {
    public final FFmpegBuilder builder;

    public SinglePassFFmpegJob(FFmpeg ffmpeg, FFmpegBuilder builder) {
        this(ffmpeg, builder, null);
    }

    public SinglePassFFmpegJob(FFmpeg ffmpeg, FFmpegBuilder builder, @Nullable ProgressListener listener) {
        super(ffmpeg, listener);
        this.builder = (FFmpegBuilder)Preconditions.checkNotNull((Object)builder);
        List<String> unused = this.builder.build();
    }

    @Override
    public void run() {
        this.state = FFmpegJob.State.RUNNING;
        try {
            this.ffmpeg.run(this.builder, this.listener);
            this.state = FFmpegJob.State.FINISHED;
        }
        catch (Throwable t) {
            this.state = FFmpegJob.State.FAILED;
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }
}

