/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind$SuspendFunction;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class StandardNames {
    public static final StandardNames INSTANCE = new StandardNames();
    public static final Name BACKING_FIELD;
    public static final Name DEFAULT_VALUE_PARAMETER;
    public static final Name ENUM_VALUES;
    public static final Name ENUM_ENTRIES;
    public static final Name ENUM_VALUE_OF;
    public static final Name DATA_CLASS_COPY;
    public static final String DATA_CLASS_COMPONENT_PREFIX;
    public static final Name HASHCODE_NAME;
    public static final Name CHAR_CODE;
    public static final Name NAME;
    public static final Name MAIN;
    public static final Name NEXT_CHAR;
    public static final Name IMPLICIT_LAMBDA_PARAMETER_NAME;
    public static final Name CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME;
    public static final FqName DYNAMIC_FQ_NAME;
    public static final FqName COROUTINES_PACKAGE_FQ_NAME;
    public static final FqName COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME;
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME;
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME;
    public static final FqName RESULT_FQ_NAME;
    public static final FqName KOTLIN_REFLECT_FQ_NAME;
    public static final List<String> PREFIXES;
    public static final Name BUILT_INS_PACKAGE_NAME;
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME;
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME;
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME;
    public static final FqName RANGES_PACKAGE_FQ_NAME;
    public static final FqName TEXT_PACKAGE_FQ_NAME;
    public static final FqName KOTLIN_INTERNAL_FQ_NAME;
    private static final FqName NON_EXISTENT_CLASS;
    public static final Set<FqName> BUILT_INS_PACKAGE_FQ_NAMES;

    private StandardNames() {
    }

    @JvmStatic
    public static final String getFunctionName(int n) {
        return "Function" + n;
    }

    @JvmStatic
    public static final ClassId getFunctionClassId(int n) {
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, Name.identifier(StandardNames.getFunctionName(n)));
    }

    @JvmStatic
    public static final String getSuspendFunctionName(int n) {
        return FunctionTypeKind$SuspendFunction.INSTANCE.getClassNamePrefix() + n;
    }

    @JvmStatic
    public static final boolean isPrimitiveArray(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        return StandardNames$FqNames.arrayClassFqNameToPrimitiveType.get(fqNameUnsafe) != null;
    }

    @JvmStatic
    public static final FqName getPrimitiveFqName(PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveType), (String)"");
        FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.getTypeName());
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        return fqName2;
    }

    static {
        Name name = Name.identifier("field");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        BACKING_FIELD = name;
        Name name2 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
        DEFAULT_VALUE_PARAMETER = name2;
        Name name3 = Name.identifier("values");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"");
        ENUM_VALUES = name3;
        Name name4 = Name.identifier("entries");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"");
        ENUM_ENTRIES = name4;
        Name name5 = Name.identifier("valueOf");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"");
        ENUM_VALUE_OF = name5;
        Name name6 = Name.identifier("copy");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"");
        DATA_CLASS_COPY = name6;
        DATA_CLASS_COMPONENT_PREFIX = "component";
        Name name7 = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"");
        HASHCODE_NAME = name7;
        Name name8 = Name.identifier("code");
        Intrinsics.checkNotNullExpressionValue((Object)name8, (String)"");
        CHAR_CODE = name8;
        Name name9 = Name.identifier("name");
        Intrinsics.checkNotNullExpressionValue((Object)name9, (String)"");
        NAME = name9;
        Name name10 = Name.identifier("main");
        Intrinsics.checkNotNullExpressionValue((Object)name10, (String)"");
        MAIN = name10;
        Name name11 = Name.identifier("nextChar");
        Intrinsics.checkNotNullExpressionValue((Object)name11, (String)"");
        NEXT_CHAR = name11;
        Name name12 = Name.identifier("it");
        Intrinsics.checkNotNullExpressionValue((Object)name12, (String)"");
        IMPLICIT_LAMBDA_PARAMETER_NAME = name12;
        Name name13 = Name.identifier("count");
        Intrinsics.checkNotNullExpressionValue((Object)name13, (String)"");
        CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME = name13;
        DYNAMIC_FQ_NAME = new FqName("<dynamic>");
        COROUTINES_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines");
        COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.jvm.internal");
        COROUTINES_INTRINSICS_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.intrinsics");
        FqName fqName2 = COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        CONTINUATION_INTERFACE_FQ_NAME = fqName2;
        RESULT_FQ_NAME = new FqName("kotlin.Result");
        KOTLIN_REFLECT_FQ_NAME = new FqName("kotlin.reflect");
        Object[] objectArray = new String[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "KProperty";
        objectArray2[1] = "KMutableProperty";
        objectArray2[2] = "KFunction";
        objectArray2[3] = "KSuspendFunction";
        PREFIXES = CollectionsKt.listOf((Object[])objectArray2);
        Name name14 = Name.identifier("kotlin");
        Intrinsics.checkNotNullExpressionValue((Object)name14, (String)"");
        BUILT_INS_PACKAGE_NAME = name14;
        FqName fqName3 = FqName.topLevel(name14);
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"");
        BUILT_INS_PACKAGE_FQ_NAME = fqName3;
        FqName fqName4 = fqName3.child(Name.identifier("annotation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"");
        ANNOTATION_PACKAGE_FQ_NAME = fqName4;
        FqName fqName5 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("collections"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName5, (String)"");
        COLLECTIONS_PACKAGE_FQ_NAME = fqName5;
        FqName fqName6 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("ranges"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName6, (String)"");
        RANGES_PACKAGE_FQ_NAME = fqName6;
        FqName fqName7 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("text"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName7, (String)"");
        TEXT_PACKAGE_FQ_NAME = fqName7;
        FqName fqName8 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("internal"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName8, (String)"");
        KOTLIN_INTERNAL_FQ_NAME = fqName8;
        NON_EXISTENT_CLASS = new FqName("error.NonExistentClass");
        FqName[] fqNameArray = new FqName[7];
        objectArray2 = fqNameArray;
        fqNameArray[0] = BUILT_INS_PACKAGE_FQ_NAME;
        objectArray2[1] = COLLECTIONS_PACKAGE_FQ_NAME;
        objectArray2[2] = RANGES_PACKAGE_FQ_NAME;
        objectArray2[3] = ANNOTATION_PACKAGE_FQ_NAME;
        objectArray2[4] = KOTLIN_REFLECT_FQ_NAME;
        objectArray2[5] = KOTLIN_INTERNAL_FQ_NAME;
        objectArray2[6] = COROUTINES_PACKAGE_FQ_NAME;
        BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf((Object[])objectArray2);
    }
}

