/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.Variance;

final class CapturedTypeParameterDescriptor
implements TypeParameterDescriptor {
    private final TypeParameterDescriptor originalDescriptor;
    private final DeclarationDescriptor declarationDescriptor;
    private final int declaredTypeParametersCount;

    public CapturedTypeParameterDescriptor(TypeParameterDescriptor typeParameterDescriptor, DeclarationDescriptor declarationDescriptor, int n) {
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        this.originalDescriptor = typeParameterDescriptor;
        this.declarationDescriptor = declarationDescriptor;
        this.declaredTypeParametersCount = n;
    }

    @Override
    public final Annotations getAnnotations() {
        return this.originalDescriptor.getAnnotations();
    }

    @Override
    public final <R, D> R accept(DeclarationDescriptorVisitor<R, D> declarationDescriptorVisitor, D d) {
        return this.originalDescriptor.accept(declarationDescriptorVisitor, d);
    }

    @Override
    public final SimpleType getDefaultType() {
        return this.originalDescriptor.getDefaultType();
    }

    @Override
    public final Name getName() {
        return this.originalDescriptor.getName();
    }

    @Override
    public final SourceElement getSource() {
        return this.originalDescriptor.getSource();
    }

    @Override
    public final StorageManager getStorageManager() {
        return this.originalDescriptor.getStorageManager();
    }

    @Override
    public final TypeConstructor getTypeConstructor() {
        return this.originalDescriptor.getTypeConstructor();
    }

    @Override
    public final List<KotlinType> getUpperBounds() {
        return this.originalDescriptor.getUpperBounds();
    }

    @Override
    public final Variance getVariance() {
        return this.originalDescriptor.getVariance();
    }

    @Override
    public final boolean isReified() {
        return this.originalDescriptor.isReified();
    }

    @Override
    public final boolean isCapturedFromOuterDeclaration() {
        return true;
    }

    @Override
    public final TypeParameterDescriptor getOriginal() {
        TypeParameterDescriptor typeParameterDescriptor = this.originalDescriptor.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"");
        return typeParameterDescriptor;
    }

    @Override
    public final DeclarationDescriptor getContainingDeclaration() {
        return this.declarationDescriptor;
    }

    @Override
    public final int getIndex() {
        return this.declaredTypeParametersCount + this.originalDescriptor.getIndex();
    }

    public final String toString() {
        return this.originalDescriptor + "[inner-copy]";
    }
}

