/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClassifierType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class ReflectJavaTypeParameter
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
JavaTypeParameter {
    private final TypeVariable<?> typeVariable;

    public ReflectJavaTypeParameter(TypeVariable<?> typeVariable) {
        Intrinsics.checkNotNullParameter(typeVariable, (String)"");
        this.typeVariable = typeVariable;
    }

    public final List<ReflectJavaClassifierType> getUpperBounds() {
        Type[] typeArray = this.typeVariable.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
        Object object = typeArray;
        Object[] objectArray = object;
        object = new ArrayList(((Object[])object).length);
        for (Object object2 : objectArray) {
            object2 = (Type)object2;
            Object object3 = object;
            object3.add(new ReflectJavaClassifierType((Type)object2));
        }
        object = (List)object;
        ReflectJavaClassifierType reflectJavaClassifierType = (ReflectJavaClassifierType)CollectionsKt.singleOrNull((List)object);
        if (Intrinsics.areEqual((Object)(reflectJavaClassifierType != null ? reflectJavaClassifierType.getReflectType() : null), Object.class)) {
            return CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    public final AnnotatedElement getElement() {
        TypeVariable<?> typeVariable = this.typeVariable;
        if (typeVariable instanceof AnnotatedElement) {
            return typeVariable;
        }
        return null;
    }

    @Override
    public final Name getName() {
        Name name = Name.identifier(this.typeVariable.getName());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        return name;
    }

    public final boolean equals(Object object) {
        return object instanceof ReflectJavaTypeParameter && Intrinsics.areEqual(this.typeVariable, ((ReflectJavaTypeParameter)object).typeVariable);
    }

    public final int hashCode() {
        return this.typeVariable.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + ": " + this.typeVariable;
    }

    @Override
    public final List<ReflectJavaAnnotation> getAnnotations() {
        Object object = this.getElement();
        if (object == null || (object = object.getDeclaredAnnotations()) == null || (object = ReflectJavaAnnotationOwnerKt.getAnnotations(object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    public final ReflectJavaAnnotation findAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        Annotation[] annotationArray = this.getElement();
        if (annotationArray != null && (annotationArray = annotationArray.getDeclaredAnnotations()) != null) {
            return ReflectJavaAnnotationOwnerKt.findAnnotation(annotationArray, fqName2);
        }
        return null;
    }

    @Override
    public final boolean isDeprecatedInJavaDoc() {
        return false;
    }
}

