/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaMethodDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class JavaIncompatibilityRulesOverridabilityCondition$Companion {
    private JavaIncompatibilityRulesOverridabilityCondition$Companion() {
    }

    public final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)callableDescriptor2, (String)"");
        if (!(callableDescriptor2 instanceof JavaMethodDescriptor) || !(callableDescriptor instanceof FunctionDescriptor)) {
            return false;
        }
        boolean bl2 = bl = ((JavaMethodDescriptor)callableDescriptor2).getValueParameters().size() == ((FunctionDescriptor)callableDescriptor).getValueParameters().size();
        if (_Assertions.ENABLED && !bl) {
            String string = "External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size";
            throw new AssertionError((Object)string);
        }
        List<ValueParameterDescriptor> list = ((JavaMethodDescriptor)callableDescriptor2).getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Iterable iterable = list;
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)callableDescriptor).getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"");
        for (Object object : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)object.component1();
            object = (ValueParameterDescriptor)object.component2();
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor2;
            Intrinsics.checkNotNull((Object)valueParameterDescriptor);
            boolean bl3 = this.mapValueParameterType(functionDescriptor, valueParameterDescriptor) instanceof JvmType.Primitive;
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
            Intrinsics.checkNotNull((Object)object);
            boolean bl4 = this.mapValueParameterType(functionDescriptor2, (ValueParameterDescriptor)object) instanceof JvmType.Primitive;
            if (bl3 == bl4) continue;
            return true;
        }
        return false;
    }

    private final JvmType mapValueParameterType(FunctionDescriptor functionDescriptor, ValueParameterDescriptor valueParameterDescriptor) {
        if (MethodSignatureMappingKt.forceSingleValueParameterBoxing(functionDescriptor) || this.isPrimitiveCompareTo(functionDescriptor)) {
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
            return MethodSignatureMappingKt.mapToJvmType(TypeUtilsKt.makeNullable(kotlinType));
        }
        KotlinType kotlinType = valueParameterDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        return MethodSignatureMappingKt.mapToJvmType(kotlinType);
    }

    private final boolean isPrimitiveCompareTo(FunctionDescriptor declarationDescriptorNonRoot) {
        if (declarationDescriptorNonRoot.getValueParameters().size() != 1) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = declarationDescriptorNonRoot.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        declarationDescriptor = classDescriptor;
        List<ValueParameterDescriptor> list = declarationDescriptorNonRoot.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        declarationDescriptorNonRoot = ((ValueParameterDescriptor)CollectionsKt.single(list)).getType().getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor2 = declarationDescriptorNonRoot instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptorNonRoot : null;
        if (classDescriptor2 == null) {
            return false;
        }
        declarationDescriptorNonRoot = classDescriptor2;
        return KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)declarationDescriptor) && Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(declarationDescriptor), (Object)DescriptorUtilsKt.getFqNameSafe(declarationDescriptorNonRoot));
    }

    public /* synthetic */ JavaIncompatibilityRulesOverridabilityCondition$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }
}

