/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.PossiblyExternalAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor$allValueArguments$2;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor$fqName$2;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor$type$2;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.load.java.sources.JavaSourceElement;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationAsAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaArrayAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassObjectAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaEnumValueAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaLiteralAnnotationArgument;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.NullValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.NullableLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeUsage;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class LazyJavaAnnotationDescriptor
implements AnnotationDescriptor,
PossiblyExternalAnnotationDescriptor {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final LazyJavaResolverContext c;
    private final JavaAnnotation javaAnnotation;
    private final NullableLazyValue fqName$delegate;
    private final NotNullLazyValue type$delegate;
    private final JavaSourceElement source;
    private final NotNullLazyValue allValueArguments$delegate;
    private final boolean isIdeExternalAnnotation;
    private final boolean isFreshlySupportedTypeUseAnnotation;

    public LazyJavaAnnotationDescriptor(LazyJavaResolverContext lazyJavaResolverContext, JavaAnnotation javaAnnotation, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lazyJavaResolverContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaAnnotation, (String)"");
        this.c = lazyJavaResolverContext;
        this.javaAnnotation = javaAnnotation;
        this.fqName$delegate = this.c.getStorageManager().createNullableLazyValue(new LazyJavaAnnotationDescriptor$fqName$2(this));
        this.type$delegate = this.c.getStorageManager().createLazyValue(new LazyJavaAnnotationDescriptor$type$2(this));
        this.source = this.c.getComponents().getSourceElementFactory().source(this.javaAnnotation);
        this.allValueArguments$delegate = this.c.getStorageManager().createLazyValue(new LazyJavaAnnotationDescriptor$allValueArguments$2(this));
        this.isIdeExternalAnnotation = this.javaAnnotation.isIdeExternalAnnotation();
        this.isFreshlySupportedTypeUseAnnotation = this.javaAnnotation.isFreshlySupportedTypeUseAnnotation() || bl;
    }

    public /* synthetic */ LazyJavaAnnotationDescriptor(LazyJavaResolverContext lazyJavaResolverContext, JavaAnnotation javaAnnotation, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(lazyJavaResolverContext, javaAnnotation, bl);
    }

    @Override
    public final FqName getFqName() {
        return (FqName)StorageKt.getValue(this.fqName$delegate, (Object)this, $$delegatedProperties[0]);
    }

    @Override
    public final SimpleType getType() {
        return (SimpleType)StorageKt.getValue(this.type$delegate, (Object)this, $$delegatedProperties[1]);
    }

    @Override
    public final JavaSourceElement getSource() {
        return this.source;
    }

    @Override
    public final Map<Name, ConstantValue<?>> getAllValueArguments() {
        return (Map)StorageKt.getValue(this.allValueArguments$delegate, (Object)this, $$delegatedProperties[2]);
    }

    private final ConstantValue<?> resolveAnnotationArgument(JavaAnnotationArgument javaAnnotationArgument) {
        Object object = javaAnnotationArgument;
        if (object instanceof JavaLiteralAnnotationArgument) {
            return ConstantValueFactory.createConstantValue$default(ConstantValueFactory.INSTANCE, ((JavaLiteralAnnotationArgument)javaAnnotationArgument).getValue(), null, 2, null);
        }
        if (object instanceof JavaEnumValueAnnotationArgument) {
            return this.resolveFromEnumValue(((JavaEnumValueAnnotationArgument)javaAnnotationArgument).getEnumClassId(), ((JavaEnumValueAnnotationArgument)javaAnnotationArgument).getEntryName());
        }
        if (object instanceof JavaArrayAnnotationArgument) {
            Name name = ((JavaArrayAnnotationArgument)javaAnnotationArgument).getName();
            if (name == null) {
                name = JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME;
            }
            object = name;
            Intrinsics.checkNotNull((Object)name);
            return this.resolveFromArray((Name)object, ((JavaArrayAnnotationArgument)javaAnnotationArgument).getElements());
        }
        if (object instanceof JavaAnnotationAsAnnotationArgument) {
            return this.resolveFromAnnotation(((JavaAnnotationAsAnnotationArgument)javaAnnotationArgument).getAnnotation());
        }
        if (object instanceof JavaClassObjectAnnotationArgument) {
            return this.resolveFromJavaClassObjectType(((JavaClassObjectAnnotationArgument)javaAnnotationArgument).getReferencedType());
        }
        return null;
    }

    private final ConstantValue<?> resolveFromAnnotation(JavaAnnotation javaAnnotation) {
        return new AnnotationValue(new LazyJavaAnnotationDescriptor(this.c, javaAnnotation, false, 4, null));
    }

    private final ConstantValue<?> resolveFromArray(Name object, List<? extends JavaAnnotationArgument> iterable) {
        SimpleType simpleType2 = this.getType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"");
        if (KotlinTypeKt.isError(simpleType2)) {
            return null;
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(this);
        Intrinsics.checkNotNull((Object)classDescriptor);
        Annotated annotated = DescriptorResolverUtils.getAnnotationParameterByName((Name)object, classDescriptor);
        if (annotated == null || (annotated = annotated.getType()) == null) {
            annotated = this.c.getComponents().getModule().getBuiltIns().getArrayType(Variance.INVARIANT, ErrorUtils.createErrorType(ErrorTypeKind.UNKNOWN_ARRAY_ELEMENT_TYPE_OF_ANNOTATION_ARGUMENT, new String[0]));
        }
        Object object2 = annotated;
        Intrinsics.checkNotNull((Object)annotated);
        object = object2;
        iterable = iterable;
        object2 = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (JavaAnnotationArgument)object3;
            Iterable<JavaAnnotationArgument> iterable2 = iterable;
            ConstantValue constantValue = this.resolveAnnotationArgument((JavaAnnotationArgument)object3);
            if (constantValue == null) {
                constantValue = new NullValue();
            }
            iterable2.add(constantValue);
        }
        object2 = iterable;
        return ConstantValueFactory.INSTANCE.createArrayValue((List<? extends ConstantValue<?>>)object2, (KotlinType)object);
    }

    private final ConstantValue<?> resolveFromEnumValue(ClassId classId, Name name) {
        if (classId == null || name == null) {
            return null;
        }
        return new EnumValue(classId, name);
    }

    private final ConstantValue<?> resolveFromJavaClassObjectType(JavaType javaType) {
        return KClassValue.Companion.create(this.c.getTypeResolver().transformJavaType(javaType, JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, false, false, null, 7, null)));
    }

    public final String toString() {
        return DescriptorRenderer.renderAnnotation$default(DescriptorRenderer.FQ_NAMES_IN_TYPES, this, null, 2, null);
    }

    private final ClassDescriptor createTypeForMissingDependencies(FqName fqName2) {
        ModuleDescriptor moduleDescriptor = this.c.getModule();
        ClassId classId = ClassId.topLevel(fqName2);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"");
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(moduleDescriptor, classId, this.c.getComponents().getDeserializedDescriptorResolver().getComponents().getNotFoundClasses());
    }

    @Override
    public final boolean isIdeExternalAnnotation() {
        return this.isIdeExternalAnnotation;
    }

    public final boolean isFreshlySupportedTypeUseAnnotation() {
        return this.isFreshlySupportedTypeUseAnnotation;
    }

    public static final /* synthetic */ JavaAnnotation access$getJavaAnnotation$p(LazyJavaAnnotationDescriptor lazyJavaAnnotationDescriptor) {
        return lazyJavaAnnotationDescriptor.javaAnnotation;
    }

    public static final /* synthetic */ LazyJavaResolverContext access$getC$p(LazyJavaAnnotationDescriptor lazyJavaAnnotationDescriptor) {
        return lazyJavaAnnotationDescriptor.c;
    }

    public static final /* synthetic */ ClassDescriptor access$createTypeForMissingDependencies(LazyJavaAnnotationDescriptor lazyJavaAnnotationDescriptor, FqName fqName2) {
        return lazyJavaAnnotationDescriptor.createTypeForMissingDependencies(fqName2);
    }

    public static final /* synthetic */ ConstantValue access$resolveAnnotationArgument(LazyJavaAnnotationDescriptor lazyJavaAnnotationDescriptor, JavaAnnotationArgument javaAnnotationArgument) {
        return lazyJavaAnnotationDescriptor.resolveAnnotationArgument(javaAnnotationArgument);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[3];
        KProperty[] kPropertyArray2 = kPropertyArray;
        kPropertyArray[0] = Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LazyJavaAnnotationDescriptor.class), "fqName", "getFqName()Lorg/jetbrains/kotlin/name/FqName;")));
        kPropertyArray2[1] = Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LazyJavaAnnotationDescriptor.class), "type", "getType()Lorg/jetbrains/kotlin/types/SimpleType;")));
        kPropertyArray2[2] = Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LazyJavaAnnotationDescriptor.class), "allValueArguments", "getAllValueArguments()Ljava/util/Map;")));
        $$delegatedProperties = kPropertyArray2;
    }
}

