/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeUsage;
import kotlin.reflect.jvm.internal.impl.types.Variance;

public final class LazyJavaTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor {
    private final LazyJavaResolverContext c;
    private final JavaTypeParameter javaTypeParameter;

    public LazyJavaTypeParameterDescriptor(LazyJavaResolverContext lazyJavaResolverContext, JavaTypeParameter javaTypeParameter, int n, DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)lazyJavaResolverContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaTypeParameter, (String)"");
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        super(lazyJavaResolverContext.getStorageManager(), declarationDescriptor, new LazyJavaAnnotations(lazyJavaResolverContext, javaTypeParameter, false, 4, null), javaTypeParameter.getName(), Variance.INVARIANT, false, n, SourceElement.NO_SOURCE, lazyJavaResolverContext.getComponents().getSupertypeLoopChecker());
        this.c = lazyJavaResolverContext;
        this.javaTypeParameter = javaTypeParameter;
    }

    @Override
    protected final List<KotlinType> resolveUpperBounds() {
        return this.computeNotEnhancedBounds();
    }

    private final List<KotlinType> computeNotEnhancedBounds() {
        Collection<JavaClassifierType> collection = this.javaTypeParameter.getUpperBounds();
        if (collection.isEmpty()) {
            SimpleType simpleType2 = this.c.getModule().getBuiltIns().getAnyType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"");
            SimpleType simpleType3 = this.c.getModule().getBuiltIns().getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"");
            return CollectionsKt.listOf((Object)KotlinTypeFactory.flexibleType(simpleType2, simpleType3));
        }
        collection = collection;
        Object object = collection;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault(collection, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (JavaClassifierType)object2;
            Collection<JavaClassifierType> collection2 = collection;
            collection2.add((JavaClassifierType)((Object)this.c.getTypeResolver().transformJavaType((JavaType)object2, JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, false, false, this, 3, null))));
        }
        return (List)collection;
    }

    protected final List<KotlinType> processBoundsWithoutCycles(List<? extends KotlinType> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        return this.c.getComponents().getSignatureEnhancement().enhanceTypeParameterBounds(this, list, this.c);
    }

    @Override
    protected final void reportSupertypeLoopError(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
    }
}

