/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import kotlin.reflect.jvm.internal.impl.protobuf.BoundedByteString$BoundedByteIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString$ByteIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;

class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedByteString(byte[] byArray, int n, int n2) {
        super(byArray);
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Offset too small: ").append(n).toString());
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Length too small: ").append(n).toString());
        }
        if ((long)n + (long)n2 > (long)byArray.length) {
            throw new IllegalArgumentException(new StringBuilder(48).append("Offset+Length too large: ").append(n).append("+").append(n2).toString());
        }
        this.bytesOffset = n;
        this.bytesLength = n2;
    }

    @Override
    public byte byteAt(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(28).append("Index too small: ").append(n).toString());
        }
        if (n >= this.size()) {
            int n2 = this.size();
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(41).append("Index too large: ").append(n).append(", ").append(n2).toString());
        }
        return this.bytes[this.bytesOffset + n];
    }

    @Override
    public int size() {
        return this.bytesLength;
    }

    @Override
    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + n, byArray, n2, n3);
    }

    @Override
    public ByteString$ByteIterator iterator() {
        return new BoundedByteString$BoundedByteIterator(this, null);
    }
}

