/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.util.AbstractArrayMapOwner;
import kotlin.reflect.jvm.internal.impl.util.ArrayMap;
import kotlin.reflect.jvm.internal.impl.util.ArrayMapImpl;
import kotlin.reflect.jvm.internal.impl.util.EmptyArrayMap;
import kotlin.reflect.jvm.internal.impl.util.OneElementArrayMap;

public abstract class AttributeArrayOwner<K, T>
extends AbstractArrayMapOwner<K, T> {
    private ArrayMap<T> arrayMap;

    protected AttributeArrayOwner(ArrayMap<T> arrayMap) {
        Intrinsics.checkNotNullParameter(arrayMap, (String)"");
        this.arrayMap = arrayMap;
    }

    @Override
    protected final ArrayMap<T> getArrayMap() {
        return this.arrayMap;
    }

    public AttributeArrayOwner() {
        EmptyArrayMap emptyArrayMap = EmptyArrayMap.INSTANCE;
        Intrinsics.checkNotNull((Object)emptyArrayMap);
        this(emptyArrayMap);
    }

    @Override
    protected final void registerComponent(String string, T t) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        int n = this.getTypeRegistry().getId(string);
        switch (this.arrayMap.getSize()) {
            case 0: {
                this.arrayMap = new OneElementArrayMap<T>(t, n);
                return;
            }
            case 1: {
                ArrayMap<T> arrayMap = this.arrayMap;
                Intrinsics.checkNotNull(arrayMap);
                OneElementArrayMap oneElementArrayMap = (OneElementArrayMap)arrayMap;
                if (oneElementArrayMap.getIndex() == n) {
                    this.arrayMap = new OneElementArrayMap<T>(t, n);
                    return;
                }
                this.arrayMap = new ArrayMapImpl();
                this.arrayMap.set(oneElementArrayMap.getIndex(), oneElementArrayMap.getValue());
            }
        }
        this.arrayMap.set(n, t);
    }
}

