/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.entities.ContentEntryVersion;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u00a7@\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\f2\u0006\u0010\r\u001a\u00020\u0006H'J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004H\u00a7@\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u00a7@\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/ustadmobile/core/db/dao/ContentEntryVersionDao;", "", "()V", "findByUidAsync", "Lcom/ustadmobile/lib/db/entities/ContentEntryVersion;", "cevUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findContentEntryVersionsWithoutCacheLock", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findLatestByContentEntryUidAsFlow", "Lkotlinx/coroutines/flow/Flow;", "contentEntryUid", "findLatestVersionUidByContentEntryUidEntity", "insertAsync", "contentEntryVersion", "(Lcom/ustadmobile/lib/db/entities/ContentEntryVersion;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateTransferJobItemEtag", "", "entityUid", "transferJobItemUid", "", "(JILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_debug"})
@Dao
public abstract class ContentEntryVersionDao {
    @Query(value="\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE cevUid = :cevUid \n    ")
    @Nullable
    public abstract Object findByUidAsync(long var1, @NotNull Continuation<? super ContentEntryVersion> var3);

    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertAsync(@NotNull ContentEntryVersion var1, @NotNull Continuation<? super Long> var2);

    @Query(value="\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE ContentEntryVersion.cevContentEntryUid = :contentEntryUid\n      ORDER BY ContentEntryVersion.cevLastModified DESC\n         LIMIT 1\n    ")
    @Nullable
    public abstract Object findLatestVersionUidByContentEntryUidEntity(long var1, @NotNull Continuation<? super ContentEntryVersion> var3);

    @Query(value="\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE ContentEntryVersion.cevContentEntryUid = :contentEntryUid\n      ORDER BY ContentEntryVersion.cevLastModified DESC\n         LIMIT 1\n    ")
    @NotNull
    public abstract Flow<ContentEntryVersion> findLatestByContentEntryUidAsFlow(long var1);

    @Query(value="\n        UPDATE TransferJobItem\n           SET tjiEntityEtag = \n               (SELECT cevLct\n                  FROM ContentEntryVersion\n                 WHERE cevUid = :entityUid)\n         WHERE tjiUid = :transferJobItemUid\n    ")
    @Nullable
    public abstract Object updateTransferJobItemEtag(long var1, int var3, @NotNull Continuation<? super Unit> var4);

    @Query(value="\n        SELECT ContentEntryVersion.*\n          FROM ContentEntryVersion\n         WHERE NOT EXISTS(\n               SELECT CacheLockJoin.cljId\n                 FROM CacheLockJoin\n                WHERE CacheLockJoin.cljTableId = 738\n                  AND CacheLockJoin.cljEntityUid = ContentEntryVersion.cevUid\n                  AND CacheLockJoin.cljUrl = ContentEntryVersion.cevManifestUrl) \n    ")
    @Nullable
    public abstract Object findContentEntryVersionsWithoutCacheLock(@NotNull Continuation<? super List<ContentEntryVersion>> var1);
}

