/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.PersonGroupDao;
import com.ustadmobile.lib.db.entities.PersonGroup;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class PersonGroupDao_Impl
extends PersonGroupDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PersonGroup> __insertionAdapterOfPersonGroup;
    private final EntityDeletionOrUpdateAdapter<PersonGroup> __updateAdapterOfPersonGroup;

    public PersonGroupDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPersonGroup = new EntityInsertionAdapter<PersonGroup>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PersonGroup` (`groupUid`,`groupMasterCsn`,`groupLocalCsn`,`groupLastChangedBy`,`groupLct`,`groupName`,`groupActive`,`personGroupFlag`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonGroup entity) {
                statement.bindLong(1, entity.getGroupUid());
                statement.bindLong(2, entity.getGroupMasterCsn());
                statement.bindLong(3, entity.getGroupLocalCsn());
                statement.bindLong(4, (long)entity.getGroupLastChangedBy());
                statement.bindLong(5, entity.getGroupLct());
                if (entity.getGroupName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getGroupName());
                }
                int _tmp = entity.getGroupActive() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, (long)entity.getPersonGroupFlag());
            }
        };
        this.__updateAdapterOfPersonGroup = new EntityDeletionOrUpdateAdapter<PersonGroup>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `PersonGroup` SET `groupUid` = ?,`groupMasterCsn` = ?,`groupLocalCsn` = ?,`groupLastChangedBy` = ?,`groupLct` = ?,`groupName` = ?,`groupActive` = ?,`personGroupFlag` = ? WHERE `groupUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonGroup entity) {
                statement.bindLong(1, entity.getGroupUid());
                statement.bindLong(2, entity.getGroupMasterCsn());
                statement.bindLong(3, entity.getGroupLocalCsn());
                statement.bindLong(4, (long)entity.getGroupLastChangedBy());
                statement.bindLong(5, entity.getGroupLct());
                if (entity.getGroupName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getGroupName());
                }
                int _tmp = entity.getGroupActive() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, (long)entity.getPersonGroupFlag());
                statement.bindLong(9, entity.getGroupUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(PersonGroup entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfPersonGroup.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final PersonGroup entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PersonGroupDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PersonGroupDao_Impl.this.__insertionAdapterOfPersonGroup.insertAndReturnId((Object)entity);
                    PersonGroupDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PersonGroupDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends PersonGroup> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPersonGroup.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(PersonGroup entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPersonGroup.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final PersonGroup entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                PersonGroupDao_Impl.this.__db.beginTransaction();
                try {
                    PersonGroupDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += PersonGroupDao_Impl.this.__updateAdapterOfPersonGroup.handle((Object)entity);
                    return n;
                }
                finally {
                    PersonGroupDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersonGroup findByUid(long uid) {
        String _sql = "SELECT * FROM PersonGroup WHERE groupUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PersonGroup WHERE groupUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            PersonGroup _result2;
            int _cursorIndexOfGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupUid");
            int _cursorIndexOfGroupMasterCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMasterCsn");
            int _cursorIndexOfGroupLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupLocalCsn");
            int _cursorIndexOfGroupLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupLastChangedBy");
            int _cursorIndexOfGroupLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupLct");
            int _cursorIndexOfGroupName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupName");
            int _cursorIndexOfGroupActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupActive");
            int _cursorIndexOfPersonGroupFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupFlag");
            if (_cursor.moveToFirst()) {
                _result2 = new PersonGroup();
                long _tmpGroupUid = _cursor.getLong(_cursorIndexOfGroupUid);
                _result2.setGroupUid(_tmpGroupUid);
                long _tmpGroupMasterCsn = _cursor.getLong(_cursorIndexOfGroupMasterCsn);
                _result2.setGroupMasterCsn(_tmpGroupMasterCsn);
                long _tmpGroupLocalCsn = _cursor.getLong(_cursorIndexOfGroupLocalCsn);
                _result2.setGroupLocalCsn(_tmpGroupLocalCsn);
                int _tmpGroupLastChangedBy = _cursor.getInt(_cursorIndexOfGroupLastChangedBy);
                _result2.setGroupLastChangedBy(_tmpGroupLastChangedBy);
                long _tmpGroupLct = _cursor.getLong(_cursorIndexOfGroupLct);
                _result2.setGroupLct(_tmpGroupLct);
                String _tmpGroupName = _cursor.isNull(_cursorIndexOfGroupName) ? null : _cursor.getString(_cursorIndexOfGroupName);
                _result2.setGroupName(_tmpGroupName);
                int _tmp = _cursor.getInt(_cursorIndexOfGroupActive);
                boolean _tmpGroupActive = _tmp != 0;
                _result2.setGroupActive(_tmpGroupActive);
                int _tmpPersonGroupFlag = _cursor.getInt(_cursorIndexOfPersonGroupFlag);
                _result2.setPersonGroupFlag(_tmpPersonGroupFlag);
            } else {
                _result2 = null;
            }
            PersonGroup personGroup = _result2;
            return personGroup;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super PersonGroup> $completion) {
        String _sql = "SELECT * FROM PersonGroup WHERE groupUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PersonGroup WHERE groupUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonGroup>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonGroup call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonGroupDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonGroup _result2;
                    int _cursorIndexOfGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupUid");
                    int _cursorIndexOfGroupMasterCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMasterCsn");
                    int _cursorIndexOfGroupLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupLocalCsn");
                    int _cursorIndexOfGroupLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupLastChangedBy");
                    int _cursorIndexOfGroupLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupLct");
                    int _cursorIndexOfGroupName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupName");
                    int _cursorIndexOfGroupActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupActive");
                    int _cursorIndexOfPersonGroupFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupFlag");
                    if (_cursor.moveToFirst()) {
                        _result2 = new PersonGroup();
                        long _tmpGroupUid = _cursor.getLong(_cursorIndexOfGroupUid);
                        _result2.setGroupUid(_tmpGroupUid);
                        long _tmpGroupMasterCsn = _cursor.getLong(_cursorIndexOfGroupMasterCsn);
                        _result2.setGroupMasterCsn(_tmpGroupMasterCsn);
                        long _tmpGroupLocalCsn = _cursor.getLong(_cursorIndexOfGroupLocalCsn);
                        _result2.setGroupLocalCsn(_tmpGroupLocalCsn);
                        int _tmpGroupLastChangedBy = _cursor.getInt(_cursorIndexOfGroupLastChangedBy);
                        _result2.setGroupLastChangedBy(_tmpGroupLastChangedBy);
                        long _tmpGroupLct = _cursor.getLong(_cursorIndexOfGroupLct);
                        _result2.setGroupLct(_tmpGroupLct);
                        String _tmpGroupName = _cursor.isNull(_cursorIndexOfGroupName) ? null : _cursor.getString(_cursorIndexOfGroupName);
                        _result2.setGroupName(_tmpGroupName);
                        int _tmp = _cursor.getInt(_cursorIndexOfGroupActive);
                        boolean _tmpGroupActive = _tmp != 0;
                        _result2.setGroupActive(_tmpGroupActive);
                        int _tmpPersonGroupFlag = _cursor.getInt(_cursorIndexOfPersonGroupFlag);
                        _result2.setPersonGroupFlag(_tmpPersonGroupFlag);
                    } else {
                        _result2 = null;
                    }
                    PersonGroup personGroup = _result2;
                    return personGroup;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<PersonGroup> findByUidLive(long uid) {
        String _sql = "SELECT * FROM PersonGroup WHERE groupUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PersonGroup WHERE groupUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"PersonGroup"}, (Callable)new Callable<PersonGroup>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonGroup call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PersonGroupDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PersonGroup _result2;
                    int _cursorIndexOfGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupUid");
                    int _cursorIndexOfGroupMasterCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupMasterCsn");
                    int _cursorIndexOfGroupLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupLocalCsn");
                    int _cursorIndexOfGroupLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupLastChangedBy");
                    int _cursorIndexOfGroupLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupLct");
                    int _cursorIndexOfGroupName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupName");
                    int _cursorIndexOfGroupActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"groupActive");
                    int _cursorIndexOfPersonGroupFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupFlag");
                    if (_cursor.moveToFirst()) {
                        _result2 = new PersonGroup();
                        long _tmpGroupUid = _cursor.getLong(_cursorIndexOfGroupUid);
                        _result2.setGroupUid(_tmpGroupUid);
                        long _tmpGroupMasterCsn = _cursor.getLong(_cursorIndexOfGroupMasterCsn);
                        _result2.setGroupMasterCsn(_tmpGroupMasterCsn);
                        long _tmpGroupLocalCsn = _cursor.getLong(_cursorIndexOfGroupLocalCsn);
                        _result2.setGroupLocalCsn(_tmpGroupLocalCsn);
                        int _tmpGroupLastChangedBy = _cursor.getInt(_cursorIndexOfGroupLastChangedBy);
                        _result2.setGroupLastChangedBy(_tmpGroupLastChangedBy);
                        long _tmpGroupLct = _cursor.getLong(_cursorIndexOfGroupLct);
                        _result2.setGroupLct(_tmpGroupLct);
                        String _tmpGroupName = _cursor.isNull(_cursorIndexOfGroupName) ? null : _cursor.getString(_cursorIndexOfGroupName);
                        _result2.setGroupName(_tmpGroupName);
                        int _tmp = _cursor.getInt(_cursorIndexOfGroupActive);
                        boolean _tmpGroupActive = _tmp != 0;
                        _result2.setGroupActive(_tmpGroupActive);
                        int _tmpPersonGroupFlag = _cursor.getInt(_cursorIndexOfPersonGroupFlag);
                        _result2.setPersonGroupFlag(_tmpPersonGroupFlag);
                    } else {
                        _result2 = null;
                    }
                    PersonGroup personGroup = _result2;
                    return personGroup;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findNameByGroupUid(long groupUid, Continuation<? super String> $completion) {
        String _sql = "\n        Select CASE\n               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n               ELSE PersonGroup.groupName \n               END AS name\n          FROM PersonGroup\n               LEFT JOIN Person\n                         ON Person.personGroupUid = PersonGroup.groupUid\n         WHERE PersonGroup.groupUid = ?\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        Select CASE\n               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n               ELSE PersonGroup.groupName \n               END AS name\n          FROM PersonGroup\n               LEFT JOIN Person\n                         ON Person.personGroupUid = PersonGroup.groupUid\n         WHERE PersonGroup.groupUid = ?\n         LIMIT 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, groupUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonGroupDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    String _result2;
                    if (_cursor.moveToFirst()) {
                        String _tmp = _cursor.isNull(0) ? null : _cursor.getString(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = null;
                    }
                    String string = _result2;
                    return string;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

