/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.lib.db.entities.ParentEnrolmentRequired;
import com.ustadmobile.lib.db.entities.PersonParentJoin;
import com.ustadmobile.lib.db.entities.PersonParentJoinAndMinorPerson;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00a7@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/ustadmobile/core/db/dao/PersonParentJoinDao;", "", "()V", "findByMinorPersonUid", "", "Lcom/ustadmobile/lib/db/entities/PersonParentJoin;", "minorPersonUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByMinorPersonUidForConsent", "findByMinorPersonUidWhereParentNotEnrolledInClazz", "Lcom/ustadmobile/lib/db/entities/ParentEnrolmentRequired;", "clazzUidFilter", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidWithMinorAsync", "Lcom/ustadmobile/lib/db/entities/PersonParentJoinAndMinorPerson;", "uid", "findByUidWithMinorAsyncFromWeb", "insertListAsync", "", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isMinorApproved", "", "isParentOf", "userPersonUid", "updateAsync", "personParentJoin", "(Lcom/ustadmobile/lib/db/entities/PersonParentJoin;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "upsertAsync", "entity", "lib-database_release"})
@Dao
public abstract class PersonParentJoinDao {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertListAsync(@NotNull List<PersonParentJoin> var1, @NotNull Continuation<? super Unit> var2);

    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsertAsync(@NotNull PersonParentJoin var1, @NotNull Continuation<? super Long> var2);

    @Query(value="\n        SELECT PersonParentJoin.*, Person.*\n          FROM PersonParentJoin\n     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n         WHERE PersonParentJoin.ppjUid = :uid\n    ")
    @Nullable
    public abstract Object findByUidWithMinorAsync(long var1, @NotNull Continuation<? super PersonParentJoinAndMinorPerson> var3);

    @Query(value="\n        SELECT PersonParentJoin.*, Person.*\n          FROM PersonParentJoin\n     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n         WHERE PersonParentJoin.ppjUid = :uid\n    ")
    @Nullable
    public abstract Object findByUidWithMinorAsyncFromWeb(long var1, @NotNull Continuation<? super PersonParentJoinAndMinorPerson> var3);

    @Query(value="\n        SELECT PersonParentJoin.*\n          FROM PersonParentJoin\n         WHERE ppjMinorPersonUid = :minorPersonUid \n    ")
    @Nullable
    public abstract Object findByMinorPersonUid(long var1, @NotNull Continuation<? super List<PersonParentJoin>> var3);

    @Query(value="\n        SELECT PersonParentJoin.*\n          FROM PersonParentJoin\n         WHERE ppjMinorPersonUid = :minorPersonUid \n    ")
    @Nullable
    public abstract Object findByMinorPersonUidForConsent(long var1, @NotNull Continuation<? super PersonParentJoin> var3);

    @Query(value="\n        SELECT PersonParentJoin.ppjParentPersonUid AS parentPersonUid,\n               ChildEnrolment.clazzEnrolmentClazzUid AS clazzUid\n          FROM PersonParentJoin\n               JOIN ClazzEnrolment ChildEnrolment \n                    ON ChildEnrolment.clazzEnrolmentPersonUid = :minorPersonUid\n                   AND (:clazzUidFilter = 0 OR ChildEnrolment.clazzEnrolmentClazzUid = :clazzUidFilter)\n         WHERE PersonParentJoin.ppjMinorPersonUid = :minorPersonUid\n           AND PersonParentJoin.ppjParentPersonUid != 0\n           AND NOT EXISTS(\n               SELECT clazzEnrolmentUid \n                 FROM ClazzEnrolment\n                WHERE ClazzEnrolment.clazzEnrolmentPersonUid = PersonParentJoin.ppjParentPersonUid\n                  AND ClazzEnrolment.clazzEnrolmentClazzUid = ChildEnrolment.clazzEnrolmentClazzUid\n                  AND ClazzEnrolment.clazzEnrolmentRole = 1003\n                  AND CAST(ClazzEnrolment.clazzEnrolmentActive AS INTEGER) = 1)\n    ")
    @Nullable
    public abstract Object findByMinorPersonUidWhereParentNotEnrolledInClazz(long var1, long var3, @NotNull Continuation<? super List<ParentEnrolmentRequired>> var5);

    @Query(value="\n        SELECT EXISTS(\n               SELECT ppjUid\n                 FROM PersonParentJoin\n                WHERE ppjMinorPersonUid = :minorPersonUid\n                      AND ppjParentPersonUid = :userPersonUid\n                      AND CAST(ppjInactive AS INTEGER) = 0)\n    ")
    @Nullable
    public abstract Object isParentOf(long var1, long var3, @NotNull Continuation<? super Boolean> var5);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull PersonParentJoin var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT EXISTS(\n               SELECT ppjUid\n                 FROM PersonParentJoin\n                WHERE ppjMinorPersonUid = :minorPersonUid\n                  AND CAST(ppjInactive AS INTEGER) = 0\n                  AND ppjStatus = 1)\n    ")
    @Nullable
    public abstract Object isMinorApproved(long var1, @NotNull Continuation<? super Boolean> var3);
}

