/*
 * Decompiled with CFR 0.152.
 */
package nl.adaptivity.xmlutil.core;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nl.adaptivity.xmlutil.XmlException;
import nl.adaptivity.xmlutil.core.KtXmlReader;
import nl.adaptivity.xmlutil.core.impl.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"KtXmlReader", "Lnl/adaptivity/xmlutil/core/KtXmlReader;", "inputStream", "Ljava/io/InputStream;", "encoding", "", "relaxed", "", "xmlutil"})
public final class KtXmlReaderJavaKt {
    @NotNull
    public static final KtXmlReader KtXmlReader(@NotNull InputStream inputStream, @Nullable String encoding, boolean relaxed) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        BufferedInputStream bufferedInput = inputStream instanceof BufferedInputStream && inputStream.markSupported() ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, 4096);
        bufferedInput.mark(4000);
        char[] srcBuf = new char[4000];
        int srcBufCount = 0;
        String enc = encoding;
        try {
            if (enc == null) {
                int i;
                int chk = 0;
                while (srcBufCount < 4 && (i = bufferedInput.read()) != -1) {
                    chk = chk << 8 | i;
                    srcBuf[srcBufCount++] = (char)i;
                }
                if (srcBufCount == 4) {
                    switch (chk) {
                        case 65279: {
                            enc = "UTF-32BE";
                            break;
                        }
                        case -131072: {
                            enc = "UTF-32LE";
                            break;
                        }
                        case 60: {
                            enc = "UTF-32BE";
                            srcBuf[0] = 60;
                            break;
                        }
                        case 0x3C000000: {
                            enc = "UTF-32LE";
                            srcBuf[0] = 60;
                            break;
                        }
                        case 3932223: {
                            enc = "UTF-16BE";
                            srcBuf[0] = 60;
                            srcBuf[1] = 63;
                            break;
                        }
                        case 1006649088: {
                            enc = "UTF-16LE";
                            srcBuf[0] = 60;
                            srcBuf[1] = 63;
                            break;
                        }
                        case 1010792557: {
                            int i2;
                            while ((i2 = bufferedInput.read()) != -1) {
                                int openQuotPos;
                                int eqPos;
                                srcBuf[srcBufCount++] = (char)i2;
                                if (i2 != 62) continue;
                                String xmlDeclContent = new String(srcBuf, 0, srcBufCount);
                                int encAttrOffset = -1;
                                while ((encAttrOffset = StringsKt.indexOf$default((CharSequence)xmlDeclContent, (String)"encoding", (int)(encAttrOffset + 1), (boolean)false, (int)4, null)) != 0 && !CharsKt.isXmlWhitespace(xmlDeclContent.charAt(encAttrOffset - 1))) {
                                }
                                if (encAttrOffset < 0) break;
                                if (relaxed) {
                                    for (eqPos = encAttrOffset + 8; eqPos < xmlDeclContent.length() && CharsKt.isXmlWhitespace(xmlDeclContent.charAt(eqPos)); ++eqPos) {
                                    }
                                }
                                if (eqPos >= xmlDeclContent.length() || xmlDeclContent.charAt(eqPos) != '=') {
                                    throw new IllegalStateException("Missing equality character in encoding attribute".toString());
                                }
                                if (relaxed) {
                                    for (openQuotPos = eqPos + 1; openQuotPos < xmlDeclContent.length() && CharsKt.isXmlWhitespace(xmlDeclContent.charAt(openQuotPos)); ++openQuotPos) {
                                    }
                                }
                                if (openQuotPos >= xmlDeclContent.length()) {
                                    throw new IllegalStateException("Missing quote for encoding attribute".toString());
                                }
                                char delim = xmlDeclContent.charAt(openQuotPos);
                                if (delim == '\"' || delim == '\'') {
                                    int endQuotPos;
                                    for (endQuotPos = openQuotPos + 1; endQuotPos < xmlDeclContent.length() && xmlDeclContent.charAt(endQuotPos) != delim; ++endQuotPos) {
                                    }
                                    if (endQuotPos < xmlDeclContent.length()) {
                                        String string = xmlDeclContent.substring(openQuotPos + 1, endQuotPos);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                        enc = string;
                                        break;
                                    }
                                    throw new IllegalStateException("Missing closing quote in encoding".toString());
                                }
                                throw new IllegalStateException("Missing quote (' or \") for encoding".toString());
                            }
                            if ((chk & 0xFFFF0000) == -16842752) {
                                enc = "UTF-16BE";
                                srcBuf[0] = (char)(srcBuf[2] << 8 | srcBuf[3]);
                                break;
                            }
                            if ((chk & 0xFFFF0000) == -131072) {
                                enc = "UTF-16LE";
                                srcBuf[0] = (char)(srcBuf[3] << 8 | srcBuf[2]);
                                break;
                            }
                            if ((chk & 0xFFFFFF00) != -272908544) break;
                            enc = "UTF-8";
                            srcBuf[0] = srcBuf[3];
                            break;
                        }
                        default: {
                            if ((chk & 0xFFFF0000) == -16842752) {
                                enc = "UTF-16BE";
                                srcBuf[0] = (char)(srcBuf[2] << 8 | srcBuf[3]);
                                break;
                            }
                            if ((chk & 0xFFFF0000) == -131072) {
                                enc = "UTF-16LE";
                                srcBuf[0] = (char)(srcBuf[3] << 8 | srcBuf[2]);
                                break;
                            }
                            if ((chk & 0xFFFFFF00) != -272908544) break;
                            enc = "UTF-8";
                            srcBuf[0] = srcBuf[3];
                        }
                    }
                }
            }
            if (enc == null) {
                enc = "UTF-8";
            }
            bufferedInput.reset();
            return new KtXmlReader(new InputStreamReader((InputStream)bufferedInput, enc), enc, relaxed);
        }
        catch (Exception e) {
            throw new XmlException("Invalid stream or encoding: " + e, e);
        }
    }

    public static /* synthetic */ KtXmlReader KtXmlReader$default(InputStream inputStream, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return KtXmlReaderJavaKt.KtXmlReader(inputStream, string, bl);
    }
}

