package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PersonGroupMember;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonGroupMemberDao_Impl extends PersonGroupMemberDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonGroupMember> __insertionAdapterOfPersonGroupMember;

  private final EntityDeletionOrUpdateAdapter<PersonGroupMember> __updateAdapterOfPersonGroupMember;

  private final SharedSQLiteStatement __preparedStmtOfMoveGroupAsync;

  private final SharedSQLiteStatement __preparedStmtOfUpdateGroupMemberActive;

  public PersonGroupMemberDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonGroupMember = new EntityInsertionAdapter<PersonGroupMember>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PersonGroupMember` (`groupMemberUid`,`groupMemberActive`,`groupMemberPersonUid`,`groupMemberGroupUid`,`groupMemberMasterCsn`,`groupMemberLocalCsn`,`groupMemberLastChangedBy`,`groupMemberLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonGroupMember entity) {
        statement.bindLong(1, entity.getGroupMemberUid());
        final int _tmp = entity.getGroupMemberActive() ? 1 : 0;
        statement.bindLong(2, _tmp);
        statement.bindLong(3, entity.getGroupMemberPersonUid());
        statement.bindLong(4, entity.getGroupMemberGroupUid());
        statement.bindLong(5, entity.getGroupMemberMasterCsn());
        statement.bindLong(6, entity.getGroupMemberLocalCsn());
        statement.bindLong(7, entity.getGroupMemberLastChangedBy());
        statement.bindLong(8, entity.getGroupMemberLct());
      }
    };
    this.__updateAdapterOfPersonGroupMember = new EntityDeletionOrUpdateAdapter<PersonGroupMember>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PersonGroupMember` SET `groupMemberUid` = ?,`groupMemberActive` = ?,`groupMemberPersonUid` = ?,`groupMemberGroupUid` = ?,`groupMemberMasterCsn` = ?,`groupMemberLocalCsn` = ?,`groupMemberLastChangedBy` = ?,`groupMemberLct` = ? WHERE `groupMemberUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonGroupMember entity) {
        statement.bindLong(1, entity.getGroupMemberUid());
        final int _tmp = entity.getGroupMemberActive() ? 1 : 0;
        statement.bindLong(2, _tmp);
        statement.bindLong(3, entity.getGroupMemberPersonUid());
        statement.bindLong(4, entity.getGroupMemberGroupUid());
        statement.bindLong(5, entity.getGroupMemberMasterCsn());
        statement.bindLong(6, entity.getGroupMemberLocalCsn());
        statement.bindLong(7, entity.getGroupMemberLastChangedBy());
        statement.bindLong(8, entity.getGroupMemberLct());
        statement.bindLong(9, entity.getGroupMemberUid());
      }
    };
    this.__preparedStmtOfMoveGroupAsync = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE PersonGroupMember \n"
                + "           SET groupMemberGroupUid = ?,\n"
                + "               groupMemberLct = ?\n"
                + "         WHERE groupMemberPersonUid = ? \n"
                + "           AND groupMemberGroupUid = ? \n"
                + "           AND PersonGroupMember.groupMemberActive";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateGroupMemberActive = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE PersonGroupMember \n"
                + "           SET groupMemberActive = ?,\n"
                + "               groupMemberLct = ?\n"
                + "        WHERE groupMemberPersonUid = ? \n"
                + "          AND groupMemberGroupUid = ? \n"
                + "          AND PersonGroupMember.groupMemberActive";
        return _query;
      }
    };
  }

  @Override
  public long insert(final PersonGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfPersonGroupMember.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final PersonGroupMember entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPersonGroupMember.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends PersonGroupMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPersonGroupMember.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final PersonGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonGroupMember.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object moveGroupAsync(final long personUid, final long newGroup, final long oldGroup,
      final long changeTime, final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfMoveGroupAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newGroup);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, oldGroup);
        try {
          __db.beginTransaction();
          try {
            final Integer _result = _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfMoveGroupAsync.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateGroupMemberActive(final boolean activeStatus, final long personUid,
      final long groupUid, final long updateTime, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateGroupMemberActive.acquire();
        int _argIndex = 1;
        final int _tmp = activeStatus ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, groupUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateGroupMemberActive.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllGroupWherePersonIsIn(final long personUid,
      final Continuation<? super List<PersonGroupMember>> $completion) {
    final String _sql = "SELECT * FROM PersonGroupMember WHERE groupMemberPersonUid = ? AND PersonGroupMember.groupMemberActive";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonGroupMember>>() {
      @Override
      @NonNull
      public List<PersonGroupMember> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberUid");
          final int _cursorIndexOfGroupMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberActive");
          final int _cursorIndexOfGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberPersonUid");
          final int _cursorIndexOfGroupMemberGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberGroupUid");
          final int _cursorIndexOfGroupMemberMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberMasterCsn");
          final int _cursorIndexOfGroupMemberLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLocalCsn");
          final int _cursorIndexOfGroupMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLastChangedBy");
          final int _cursorIndexOfGroupMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLct");
          final List<PersonGroupMember> _result = new ArrayList<PersonGroupMember>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonGroupMember _item;
            _item = new PersonGroupMember();
            final long _tmpGroupMemberUid;
            _tmpGroupMemberUid = _cursor.getLong(_cursorIndexOfGroupMemberUid);
            _item.setGroupMemberUid(_tmpGroupMemberUid);
            final boolean _tmpGroupMemberActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupMemberActive);
            _tmpGroupMemberActive = _tmp != 0;
            _item.setGroupMemberActive(_tmpGroupMemberActive);
            final long _tmpGroupMemberPersonUid;
            _tmpGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfGroupMemberPersonUid);
            _item.setGroupMemberPersonUid(_tmpGroupMemberPersonUid);
            final long _tmpGroupMemberGroupUid;
            _tmpGroupMemberGroupUid = _cursor.getLong(_cursorIndexOfGroupMemberGroupUid);
            _item.setGroupMemberGroupUid(_tmpGroupMemberGroupUid);
            final long _tmpGroupMemberMasterCsn;
            _tmpGroupMemberMasterCsn = _cursor.getLong(_cursorIndexOfGroupMemberMasterCsn);
            _item.setGroupMemberMasterCsn(_tmpGroupMemberMasterCsn);
            final long _tmpGroupMemberLocalCsn;
            _tmpGroupMemberLocalCsn = _cursor.getLong(_cursorIndexOfGroupMemberLocalCsn);
            _item.setGroupMemberLocalCsn(_tmpGroupMemberLocalCsn);
            final int _tmpGroupMemberLastChangedBy;
            _tmpGroupMemberLastChangedBy = _cursor.getInt(_cursorIndexOfGroupMemberLastChangedBy);
            _item.setGroupMemberLastChangedBy(_tmpGroupMemberLastChangedBy);
            final long _tmpGroupMemberLct;
            _tmpGroupMemberLct = _cursor.getLong(_cursorIndexOfGroupMemberLct);
            _item.setGroupMemberLct(_tmpGroupMemberLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object checkPersonBelongsToGroup(final long groupUid, final long personUid,
      final Continuation<? super List<PersonGroupMember>> $completion) {
    final String _sql = "SELECT * FROM PersonGroupMember WHERE groupMemberGroupUid = ? \n"
            + "             AND groupMemberPersonUid = ? AND PersonGroupMember.groupMemberActive";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, groupUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonGroupMember>>() {
      @Override
      @NonNull
      public List<PersonGroupMember> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberUid");
          final int _cursorIndexOfGroupMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberActive");
          final int _cursorIndexOfGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberPersonUid");
          final int _cursorIndexOfGroupMemberGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberGroupUid");
          final int _cursorIndexOfGroupMemberMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberMasterCsn");
          final int _cursorIndexOfGroupMemberLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLocalCsn");
          final int _cursorIndexOfGroupMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLastChangedBy");
          final int _cursorIndexOfGroupMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLct");
          final List<PersonGroupMember> _result = new ArrayList<PersonGroupMember>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonGroupMember _item;
            _item = new PersonGroupMember();
            final long _tmpGroupMemberUid;
            _tmpGroupMemberUid = _cursor.getLong(_cursorIndexOfGroupMemberUid);
            _item.setGroupMemberUid(_tmpGroupMemberUid);
            final boolean _tmpGroupMemberActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupMemberActive);
            _tmpGroupMemberActive = _tmp != 0;
            _item.setGroupMemberActive(_tmpGroupMemberActive);
            final long _tmpGroupMemberPersonUid;
            _tmpGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfGroupMemberPersonUid);
            _item.setGroupMemberPersonUid(_tmpGroupMemberPersonUid);
            final long _tmpGroupMemberGroupUid;
            _tmpGroupMemberGroupUid = _cursor.getLong(_cursorIndexOfGroupMemberGroupUid);
            _item.setGroupMemberGroupUid(_tmpGroupMemberGroupUid);
            final long _tmpGroupMemberMasterCsn;
            _tmpGroupMemberMasterCsn = _cursor.getLong(_cursorIndexOfGroupMemberMasterCsn);
            _item.setGroupMemberMasterCsn(_tmpGroupMemberMasterCsn);
            final long _tmpGroupMemberLocalCsn;
            _tmpGroupMemberLocalCsn = _cursor.getLong(_cursorIndexOfGroupMemberLocalCsn);
            _item.setGroupMemberLocalCsn(_tmpGroupMemberLocalCsn);
            final int _tmpGroupMemberLastChangedBy;
            _tmpGroupMemberLastChangedBy = _cursor.getInt(_cursorIndexOfGroupMemberLastChangedBy);
            _item.setGroupMemberLastChangedBy(_tmpGroupMemberLastChangedBy);
            final long _tmpGroupMemberLct;
            _tmpGroupMemberLct = _cursor.getLong(_cursorIndexOfGroupMemberLct);
            _item.setGroupMemberLct(_tmpGroupMemberLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByPersonUidAndGroupUid(final long personUid, final long groupUid,
      final Continuation<? super PersonGroupMember> $completion) {
    final String _sql = "\n"
            + "        SELECT PersonGroupMember.*\n"
            + "          FROM PersonGroupMember\n"
            + "         WHERE PersonGroupMember.groupMemberPersonUid = ?\n"
            + "           AND PersonGroupMember.groupMemberGroupUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, groupUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonGroupMember>() {
      @Override
      @Nullable
      public PersonGroupMember call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberUid");
          final int _cursorIndexOfGroupMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberActive");
          final int _cursorIndexOfGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberPersonUid");
          final int _cursorIndexOfGroupMemberGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberGroupUid");
          final int _cursorIndexOfGroupMemberMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberMasterCsn");
          final int _cursorIndexOfGroupMemberLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLocalCsn");
          final int _cursorIndexOfGroupMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLastChangedBy");
          final int _cursorIndexOfGroupMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLct");
          final PersonGroupMember _result;
          if (_cursor.moveToFirst()) {
            _result = new PersonGroupMember();
            final long _tmpGroupMemberUid;
            _tmpGroupMemberUid = _cursor.getLong(_cursorIndexOfGroupMemberUid);
            _result.setGroupMemberUid(_tmpGroupMemberUid);
            final boolean _tmpGroupMemberActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupMemberActive);
            _tmpGroupMemberActive = _tmp != 0;
            _result.setGroupMemberActive(_tmpGroupMemberActive);
            final long _tmpGroupMemberPersonUid;
            _tmpGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfGroupMemberPersonUid);
            _result.setGroupMemberPersonUid(_tmpGroupMemberPersonUid);
            final long _tmpGroupMemberGroupUid;
            _tmpGroupMemberGroupUid = _cursor.getLong(_cursorIndexOfGroupMemberGroupUid);
            _result.setGroupMemberGroupUid(_tmpGroupMemberGroupUid);
            final long _tmpGroupMemberMasterCsn;
            _tmpGroupMemberMasterCsn = _cursor.getLong(_cursorIndexOfGroupMemberMasterCsn);
            _result.setGroupMemberMasterCsn(_tmpGroupMemberMasterCsn);
            final long _tmpGroupMemberLocalCsn;
            _tmpGroupMemberLocalCsn = _cursor.getLong(_cursorIndexOfGroupMemberLocalCsn);
            _result.setGroupMemberLocalCsn(_tmpGroupMemberLocalCsn);
            final int _tmpGroupMemberLastChangedBy;
            _tmpGroupMemberLastChangedBy = _cursor.getInt(_cursorIndexOfGroupMemberLastChangedBy);
            _result.setGroupMemberLastChangedBy(_tmpGroupMemberLastChangedBy);
            final long _tmpGroupMemberLct;
            _tmpGroupMemberLct = _cursor.getLong(_cursorIndexOfGroupMemberLct);
            _result.setGroupMemberLct(_tmpGroupMemberLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
