package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.HolidayCalendar
import com.ustadmobile.lib.db.entities.HolidayCalendarWithNumEntries
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

@Dao
public actual abstract class HolidayCalendarDao : BaseDao<HolidayCalendar> {
  @Query(`value` =
      "SELECT HolidayCalendar.* ,\n            (SELECT COUNT(*) FROM Holiday \n               WHERE holHolidayCalendarUid = HolidayCalendar.umCalendarUid \n               AND CAST(holActive AS INTEGER) = 1) AS numEntries \n             FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND \n             umCalendarCategory = 1")
  public actual abstract fun findAllHolidaysWithEntriesCount():
      PagingSource<Int, HolidayCalendarWithNumEntries>

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract fun replaceList(list: List<HolidayCalendar>)

  @Query(`value` =
      "SELECT * FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND umCalendarCategory = 1")
  public actual abstract fun findAllHolidaysLiveData(): Flow<List<HolidayCalendar>>

  @Query(`value` =
      "SELECT * FROM HolidayCalendar WHERE umCalendarUid = :uid AND CAST(umCalendarActive AS INTEGER) = 1")
  public actual abstract fun findByUidLive(uid: Long): Flow<HolidayCalendar?>

  @Update(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun updateAsync(entity: HolidayCalendar): Int

  @Query(`value` = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = :uid")
  public actual abstract suspend fun findByUid(uid: Long): HolidayCalendar?

  @Query(`value` = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = :uid")
  public actual abstract suspend fun findByUidAsync(uid: Long): HolidayCalendar?
}
