package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.MessageAndOtherPerson;
import com.ustadmobile.lib.db.entities.Message;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MessageDao_Impl extends MessageDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Message> __insertionAdapterOfMessage;

  public MessageDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfMessage = new EntityInsertionAdapter<Message>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Message` (`messageUid`,`messageSenderPersonUid`,`messageToPersonUid`,`messageText`,`messageTimestamp`,`messageLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Message entity) {
        statement.bindLong(1, entity.getMessageUid());
        statement.bindLong(2, entity.getMessageSenderPersonUid());
        statement.bindLong(3, entity.getMessageToPersonUid());
        if (entity.getMessageText() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getMessageText());
        }
        statement.bindLong(5, entity.getMessageTimestamp());
        statement.bindLong(6, entity.getMessageLct());
      }
    };
  }

  @Override
  public Object insert(final Message message, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfMessage.insert(message);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, Message> messagesFromOtherUserAsPagingSource(
      final long accountPersonUid, final long otherPersonUid) {
    final String _sql = "\n"
            + "        SELECT Message.*\n"
            + "          FROM Message\n"
            + "         WHERE (Message.messageSenderPersonUid = ?\n"
            + "                AND Message.messageToPersonUid = ?)\n"
            + "            OR (Message.messageSenderPersonUid = ?\n"
            + "                AND Message.messageToPersonUid = ?) \n"
            + "      ORDER BY Message.messageTimestamp DESC          \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    return new LimitOffsetPagingSource<Message>(_statement, __db, "Message") {
      @Override
      @NonNull
      protected List<Message> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfMessageUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageUid");
        final int _cursorIndexOfMessageSenderPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageSenderPersonUid");
        final int _cursorIndexOfMessageToPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageToPersonUid");
        final int _cursorIndexOfMessageText = CursorUtil.getColumnIndexOrThrow(cursor, "messageText");
        final int _cursorIndexOfMessageTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "messageTimestamp");
        final int _cursorIndexOfMessageLct = CursorUtil.getColumnIndexOrThrow(cursor, "messageLct");
        final List<Message> _result = new ArrayList<Message>(cursor.getCount());
        while (cursor.moveToNext()) {
          final Message _item;
          final long _tmpMessageUid;
          _tmpMessageUid = cursor.getLong(_cursorIndexOfMessageUid);
          final long _tmpMessageSenderPersonUid;
          _tmpMessageSenderPersonUid = cursor.getLong(_cursorIndexOfMessageSenderPersonUid);
          final long _tmpMessageToPersonUid;
          _tmpMessageToPersonUid = cursor.getLong(_cursorIndexOfMessageToPersonUid);
          final String _tmpMessageText;
          if (cursor.isNull(_cursorIndexOfMessageText)) {
            _tmpMessageText = null;
          } else {
            _tmpMessageText = cursor.getString(_cursorIndexOfMessageText);
          }
          final long _tmpMessageTimestamp;
          _tmpMessageTimestamp = cursor.getLong(_cursorIndexOfMessageTimestamp);
          final long _tmpMessageLct;
          _tmpMessageLct = cursor.getLong(_cursorIndexOfMessageLct);
          _item = new Message(_tmpMessageUid,_tmpMessageSenderPersonUid,_tmpMessageToPersonUid,_tmpMessageText,_tmpMessageTimestamp,_tmpMessageLct);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public PagingSource<Integer, MessageAndOtherPerson> conversationsForUserAsPagingSource(
      final String searchQuery, final long accountPersonUid) {
    final String _sql = "\n"
            + "        SELECT Person.*, LatestMessage.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               JOIN Message LatestMessage\n"
            + "                    ON LatestMessage.messageUid = \n"
            + "                       (SELECT Message.messageUid\n"
            + "                          FROM Message\n"
            + "                         WHERE (Message.messageSenderPersonUid = ?\n"
            + "                                AND Message.messageToPersonUid = Person.personUid)\n"
            + "                            OR (Message.messageSenderPersonUid = Person.personUid\n"
            + "                                AND Message.messageToPersonUid = ?)\n"
            + "                       ORDER BY Message.messageTimestamp DESC\n"
            + "                          LIMIT 1)\n"
            + "                          \n"
            + "                LEFT JOIN PersonPicture\n"
            + "                          ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE ? = '%' \n"
            + "               OR (Person.firstNames || ' ' || Person.lastName) LIKE ?\n"
            + "      ORDER BY LatestMessage.messageTimestamp DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindString(_argIndex, searchQuery);
    _argIndex = 4;
    _statement.bindString(_argIndex, searchQuery);
    return new LimitOffsetPagingSource<MessageAndOtherPerson>(_statement, __db, "Person", "Message", "PersonPicture") {
      @Override
      @NonNull
      protected List<MessageAndOtherPerson> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
        final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
        final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
        final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
        final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
        final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(cursor, "isPersonalAccount");
        final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
        final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
        final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
        final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
        final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
        final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
        final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
        final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
        final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
        final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
        final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
        final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
        final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
        final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
        final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
        final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
        final int _cursorIndexOfMessageUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageUid");
        final int _cursorIndexOfMessageSenderPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageSenderPersonUid");
        final int _cursorIndexOfMessageToPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "messageToPersonUid");
        final int _cursorIndexOfMessageText = CursorUtil.getColumnIndexOrThrow(cursor, "messageText");
        final int _cursorIndexOfMessageTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "messageTimestamp");
        final int _cursorIndexOfMessageLct = CursorUtil.getColumnIndexOrThrow(cursor, "messageLct");
        final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUid");
        final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureLct");
        final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUri");
        final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureThumbnailUri");
        final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
        final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureActive");
        final List<MessageAndOtherPerson> _result = new ArrayList<MessageAndOtherPerson>(cursor.getCount());
        while (cursor.moveToNext()) {
          final MessageAndOtherPerson _item;
          final Person _tmpOtherPerson;
          if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfIsPersonalAccount) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
            final long _tmpPersonUid;
            _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
            }
            _tmpOtherPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _tmpOtherPerson = null;
          }
          final Message _tmpMessage;
          if (!(cursor.isNull(_cursorIndexOfMessageUid) && cursor.isNull(_cursorIndexOfMessageSenderPersonUid) && cursor.isNull(_cursorIndexOfMessageToPersonUid) && cursor.isNull(_cursorIndexOfMessageText) && cursor.isNull(_cursorIndexOfMessageTimestamp) && cursor.isNull(_cursorIndexOfMessageLct))) {
            final long _tmpMessageUid;
            _tmpMessageUid = cursor.getLong(_cursorIndexOfMessageUid);
            final long _tmpMessageSenderPersonUid;
            _tmpMessageSenderPersonUid = cursor.getLong(_cursorIndexOfMessageSenderPersonUid);
            final long _tmpMessageToPersonUid;
            _tmpMessageToPersonUid = cursor.getLong(_cursorIndexOfMessageToPersonUid);
            final String _tmpMessageText;
            if (cursor.isNull(_cursorIndexOfMessageText)) {
              _tmpMessageText = null;
            } else {
              _tmpMessageText = cursor.getString(_cursorIndexOfMessageText);
            }
            final long _tmpMessageTimestamp;
            _tmpMessageTimestamp = cursor.getLong(_cursorIndexOfMessageTimestamp);
            final long _tmpMessageLct;
            _tmpMessageLct = cursor.getLong(_cursorIndexOfMessageLct);
            _tmpMessage = new Message(_tmpMessageUid,_tmpMessageSenderPersonUid,_tmpMessageToPersonUid,_tmpMessageText,_tmpMessageTimestamp,_tmpMessageLct);
          } else {
            _tmpMessage = null;
          }
          final PersonPicture _tmpPersonPicture;
          if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            final String _tmpPersonPictureThumbnailUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
              _tmpPersonPictureThumbnailUri = null;
            } else {
              _tmpPersonPictureThumbnailUri = cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
            }
            final int _tmpFileSize;
            _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
            final boolean _tmpPersonPictureActive;
            final int _tmp_3;
            _tmp_3 = cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp_3 != 0;
            _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
          } else {
            _tmpPersonPicture = null;
          }
          _item = new MessageAndOtherPerson(_tmpMessage,_tmpOtherPerson,_tmpPersonPicture);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
