package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Schedule;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ScheduleDao_Impl extends ScheduleDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Schedule> __insertionAdapterOfSchedule;

  private final EntityInsertionAdapter<Schedule> __insertionAdapterOfSchedule_1;

  private final EntityDeletionOrUpdateAdapter<Schedule> __updateAdapterOfSchedule;

  private final SharedSQLiteStatement __preparedStmtOfUpdateScheduleActivated;

  public ScheduleDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSchedule = new EntityInsertionAdapter<Schedule>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Schedule` (`scheduleUid`,`sceduleStartTime`,`scheduleEndTime`,`scheduleDay`,`scheduleMonth`,`scheduleFrequency`,`umCalendarUid`,`scheduleClazzUid`,`scheduleMasterChangeSeqNum`,`scheduleLocalChangeSeqNum`,`scheduleLastChangedBy`,`scheduleLastChangedTime`,`scheduleActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Schedule entity) {
        statement.bindLong(1, entity.getScheduleUid());
        statement.bindLong(2, entity.getSceduleStartTime());
        statement.bindLong(3, entity.getScheduleEndTime());
        statement.bindLong(4, entity.getScheduleDay());
        statement.bindLong(5, entity.getScheduleMonth());
        statement.bindLong(6, entity.getScheduleFrequency());
        statement.bindLong(7, entity.getUmCalendarUid());
        statement.bindLong(8, entity.getScheduleClazzUid());
        statement.bindLong(9, entity.getScheduleMasterChangeSeqNum());
        statement.bindLong(10, entity.getScheduleLocalChangeSeqNum());
        statement.bindLong(11, entity.getScheduleLastChangedBy());
        statement.bindLong(12, entity.getScheduleLastChangedTime());
        final int _tmp = entity.getScheduleActive() ? 1 : 0;
        statement.bindLong(13, _tmp);
      }
    };
    this.__insertionAdapterOfSchedule_1 = new EntityInsertionAdapter<Schedule>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `Schedule` (`scheduleUid`,`sceduleStartTime`,`scheduleEndTime`,`scheduleDay`,`scheduleMonth`,`scheduleFrequency`,`umCalendarUid`,`scheduleClazzUid`,`scheduleMasterChangeSeqNum`,`scheduleLocalChangeSeqNum`,`scheduleLastChangedBy`,`scheduleLastChangedTime`,`scheduleActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Schedule entity) {
        statement.bindLong(1, entity.getScheduleUid());
        statement.bindLong(2, entity.getSceduleStartTime());
        statement.bindLong(3, entity.getScheduleEndTime());
        statement.bindLong(4, entity.getScheduleDay());
        statement.bindLong(5, entity.getScheduleMonth());
        statement.bindLong(6, entity.getScheduleFrequency());
        statement.bindLong(7, entity.getUmCalendarUid());
        statement.bindLong(8, entity.getScheduleClazzUid());
        statement.bindLong(9, entity.getScheduleMasterChangeSeqNum());
        statement.bindLong(10, entity.getScheduleLocalChangeSeqNum());
        statement.bindLong(11, entity.getScheduleLastChangedBy());
        statement.bindLong(12, entity.getScheduleLastChangedTime());
        final int _tmp = entity.getScheduleActive() ? 1 : 0;
        statement.bindLong(13, _tmp);
      }
    };
    this.__updateAdapterOfSchedule = new EntityDeletionOrUpdateAdapter<Schedule>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `Schedule` SET `scheduleUid` = ?,`sceduleStartTime` = ?,`scheduleEndTime` = ?,`scheduleDay` = ?,`scheduleMonth` = ?,`scheduleFrequency` = ?,`umCalendarUid` = ?,`scheduleClazzUid` = ?,`scheduleMasterChangeSeqNum` = ?,`scheduleLocalChangeSeqNum` = ?,`scheduleLastChangedBy` = ?,`scheduleLastChangedTime` = ?,`scheduleActive` = ? WHERE `scheduleUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Schedule entity) {
        statement.bindLong(1, entity.getScheduleUid());
        statement.bindLong(2, entity.getSceduleStartTime());
        statement.bindLong(3, entity.getScheduleEndTime());
        statement.bindLong(4, entity.getScheduleDay());
        statement.bindLong(5, entity.getScheduleMonth());
        statement.bindLong(6, entity.getScheduleFrequency());
        statement.bindLong(7, entity.getUmCalendarUid());
        statement.bindLong(8, entity.getScheduleClazzUid());
        statement.bindLong(9, entity.getScheduleMasterChangeSeqNum());
        statement.bindLong(10, entity.getScheduleLocalChangeSeqNum());
        statement.bindLong(11, entity.getScheduleLastChangedBy());
        statement.bindLong(12, entity.getScheduleLastChangedTime());
        final int _tmp = entity.getScheduleActive() ? 1 : 0;
        statement.bindLong(13, _tmp);
        statement.bindLong(14, entity.getScheduleUid());
      }
    };
    this.__preparedStmtOfUpdateScheduleActivated = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE Schedule \n"
                + "           SET scheduleActive = ?,\n"
                + "               scheduleLastChangedTime = ?\n"
                + "         WHERE scheduleUid = ?\n"
                + "            ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Schedule entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfSchedule.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Schedule entity, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfSchedule.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends Schedule> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfSchedule.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object upsertListAsync(final List<Schedule> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfSchedule_1.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final Schedule entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfSchedule.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Schedule entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfSchedule.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateScheduleActivated(final long scheduleUid, final boolean active,
      final long changeTime, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateScheduleActivated.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, scheduleUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateScheduleActivated.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Schedule findByUid(final long uid) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
      final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
      final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
      final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
      final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
      final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
      final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
      final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
      final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
      final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
      final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
      final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
      final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
      final Schedule _result;
      if (_cursor.moveToFirst()) {
        _result = new Schedule();
        final long _tmpScheduleUid;
        _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
        _result.setScheduleUid(_tmpScheduleUid);
        final long _tmpSceduleStartTime;
        _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
        _result.setSceduleStartTime(_tmpSceduleStartTime);
        final long _tmpScheduleEndTime;
        _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
        _result.setScheduleEndTime(_tmpScheduleEndTime);
        final int _tmpScheduleDay;
        _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
        _result.setScheduleDay(_tmpScheduleDay);
        final int _tmpScheduleMonth;
        _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
        _result.setScheduleMonth(_tmpScheduleMonth);
        final int _tmpScheduleFrequency;
        _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
        _result.setScheduleFrequency(_tmpScheduleFrequency);
        final long _tmpUmCalendarUid;
        _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
        _result.setUmCalendarUid(_tmpUmCalendarUid);
        final long _tmpScheduleClazzUid;
        _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
        _result.setScheduleClazzUid(_tmpScheduleClazzUid);
        final long _tmpScheduleMasterChangeSeqNum;
        _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
        _result.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
        final long _tmpScheduleLocalChangeSeqNum;
        _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
        _result.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
        final int _tmpScheduleLastChangedBy;
        _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
        _result.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
        final long _tmpScheduleLastChangedTime;
        _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
        _result.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
        final boolean _tmpScheduleActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
        _tmpScheduleActive = _tmp != 0;
        _result.setScheduleActive(_tmpScheduleActive);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long uid, final Continuation<? super Schedule> $completion) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Schedule>() {
      @Override
      @Nullable
      public Schedule call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
          final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
          final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
          final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
          final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
          final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
          final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
          final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
          final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
          final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
          final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
          final Schedule _result;
          if (_cursor.moveToFirst()) {
            _result = new Schedule();
            final long _tmpScheduleUid;
            _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
            _result.setScheduleUid(_tmpScheduleUid);
            final long _tmpSceduleStartTime;
            _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
            _result.setSceduleStartTime(_tmpSceduleStartTime);
            final long _tmpScheduleEndTime;
            _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
            _result.setScheduleEndTime(_tmpScheduleEndTime);
            final int _tmpScheduleDay;
            _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
            _result.setScheduleDay(_tmpScheduleDay);
            final int _tmpScheduleMonth;
            _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
            _result.setScheduleMonth(_tmpScheduleMonth);
            final int _tmpScheduleFrequency;
            _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
            _result.setScheduleFrequency(_tmpScheduleFrequency);
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _result.setUmCalendarUid(_tmpUmCalendarUid);
            final long _tmpScheduleClazzUid;
            _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
            _result.setScheduleClazzUid(_tmpScheduleClazzUid);
            final long _tmpScheduleMasterChangeSeqNum;
            _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
            _result.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
            final long _tmpScheduleLocalChangeSeqNum;
            _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
            _result.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
            final int _tmpScheduleLastChangedBy;
            _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
            _result.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
            final long _tmpScheduleLastChangedTime;
            _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
            _result.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
            final boolean _tmpScheduleActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
            _tmpScheduleActive = _tmp != 0;
            _result.setScheduleActive(_tmpScheduleActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, Schedule> findAllSchedulesByClazzUid(final long clazzUid) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1 ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    return new LimitOffsetPagingSource<Schedule>(_statement, __db, "Schedule") {
      @Override
      @NonNull
      protected List<Schedule> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleUid");
        final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(cursor, "sceduleStartTime");
        final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleEndTime");
        final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleDay");
        final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleMonth");
        final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleFrequency");
        final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarUid");
        final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleClazzUid");
        final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleMasterChangeSeqNum");
        final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleLocalChangeSeqNum");
        final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleLastChangedBy");
        final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleLastChangedTime");
        final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleActive");
        final List<Schedule> _result = new ArrayList<Schedule>(cursor.getCount());
        while (cursor.moveToNext()) {
          final Schedule _item;
          _item = new Schedule();
          final long _tmpScheduleUid;
          _tmpScheduleUid = cursor.getLong(_cursorIndexOfScheduleUid);
          _item.setScheduleUid(_tmpScheduleUid);
          final long _tmpSceduleStartTime;
          _tmpSceduleStartTime = cursor.getLong(_cursorIndexOfSceduleStartTime);
          _item.setSceduleStartTime(_tmpSceduleStartTime);
          final long _tmpScheduleEndTime;
          _tmpScheduleEndTime = cursor.getLong(_cursorIndexOfScheduleEndTime);
          _item.setScheduleEndTime(_tmpScheduleEndTime);
          final int _tmpScheduleDay;
          _tmpScheduleDay = cursor.getInt(_cursorIndexOfScheduleDay);
          _item.setScheduleDay(_tmpScheduleDay);
          final int _tmpScheduleMonth;
          _tmpScheduleMonth = cursor.getInt(_cursorIndexOfScheduleMonth);
          _item.setScheduleMonth(_tmpScheduleMonth);
          final int _tmpScheduleFrequency;
          _tmpScheduleFrequency = cursor.getInt(_cursorIndexOfScheduleFrequency);
          _item.setScheduleFrequency(_tmpScheduleFrequency);
          final long _tmpUmCalendarUid;
          _tmpUmCalendarUid = cursor.getLong(_cursorIndexOfUmCalendarUid);
          _item.setUmCalendarUid(_tmpUmCalendarUid);
          final long _tmpScheduleClazzUid;
          _tmpScheduleClazzUid = cursor.getLong(_cursorIndexOfScheduleClazzUid);
          _item.setScheduleClazzUid(_tmpScheduleClazzUid);
          final long _tmpScheduleMasterChangeSeqNum;
          _tmpScheduleMasterChangeSeqNum = cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
          _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
          final long _tmpScheduleLocalChangeSeqNum;
          _tmpScheduleLocalChangeSeqNum = cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
          _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
          final int _tmpScheduleLastChangedBy;
          _tmpScheduleLastChangedBy = cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
          _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
          final long _tmpScheduleLastChangedTime;
          _tmpScheduleLastChangedTime = cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
          _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
          final boolean _tmpScheduleActive;
          final int _tmp;
          _tmp = cursor.getInt(_cursorIndexOfScheduleActive);
          _tmpScheduleActive = _tmp != 0;
          _item.setScheduleActive(_tmpScheduleActive);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public List<Schedule> findAllSchedulesByClazzUidAsList(final long clazzUid) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
      final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
      final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
      final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
      final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
      final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
      final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
      final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
      final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
      final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
      final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
      final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
      final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
      final List<Schedule> _result = new ArrayList<Schedule>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Schedule _item;
        _item = new Schedule();
        final long _tmpScheduleUid;
        _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
        _item.setScheduleUid(_tmpScheduleUid);
        final long _tmpSceduleStartTime;
        _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
        _item.setSceduleStartTime(_tmpSceduleStartTime);
        final long _tmpScheduleEndTime;
        _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
        _item.setScheduleEndTime(_tmpScheduleEndTime);
        final int _tmpScheduleDay;
        _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
        _item.setScheduleDay(_tmpScheduleDay);
        final int _tmpScheduleMonth;
        _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
        _item.setScheduleMonth(_tmpScheduleMonth);
        final int _tmpScheduleFrequency;
        _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
        _item.setScheduleFrequency(_tmpScheduleFrequency);
        final long _tmpUmCalendarUid;
        _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
        _item.setUmCalendarUid(_tmpUmCalendarUid);
        final long _tmpScheduleClazzUid;
        _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
        _item.setScheduleClazzUid(_tmpScheduleClazzUid);
        final long _tmpScheduleMasterChangeSeqNum;
        _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
        _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
        final long _tmpScheduleLocalChangeSeqNum;
        _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
        _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
        final int _tmpScheduleLastChangedBy;
        _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
        _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
        final long _tmpScheduleLastChangedTime;
        _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
        _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
        final boolean _tmpScheduleActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
        _tmpScheduleActive = _tmp != 0;
        _item.setScheduleActive(_tmpScheduleActive);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<List<Schedule>> findAllSchedulesByClazzUidAsLiveList(final long clazzUid) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Schedule"}, new Callable<List<Schedule>>() {
      @Override
      @NonNull
      public List<Schedule> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
          final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
          final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
          final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
          final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
          final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
          final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
          final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
          final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
          final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
          final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
          final List<Schedule> _result = new ArrayList<Schedule>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Schedule _item;
            _item = new Schedule();
            final long _tmpScheduleUid;
            _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
            _item.setScheduleUid(_tmpScheduleUid);
            final long _tmpSceduleStartTime;
            _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
            _item.setSceduleStartTime(_tmpSceduleStartTime);
            final long _tmpScheduleEndTime;
            _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
            _item.setScheduleEndTime(_tmpScheduleEndTime);
            final int _tmpScheduleDay;
            _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
            _item.setScheduleDay(_tmpScheduleDay);
            final int _tmpScheduleMonth;
            _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
            _item.setScheduleMonth(_tmpScheduleMonth);
            final int _tmpScheduleFrequency;
            _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
            _item.setScheduleFrequency(_tmpScheduleFrequency);
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _item.setUmCalendarUid(_tmpUmCalendarUid);
            final long _tmpScheduleClazzUid;
            _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
            _item.setScheduleClazzUid(_tmpScheduleClazzUid);
            final long _tmpScheduleMasterChangeSeqNum;
            _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
            _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
            final long _tmpScheduleLocalChangeSeqNum;
            _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
            _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
            final int _tmpScheduleLastChangedBy;
            _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
            _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
            final long _tmpScheduleLastChangedTime;
            _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
            _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
            final boolean _tmpScheduleActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
            _tmpScheduleActive = _tmp != 0;
            _item.setScheduleActive(_tmpScheduleActive);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findAllSchedulesByClazzUidAsync(final long clazzUid,
      final Continuation<? super List<Schedule>> $completion) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1 ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Schedule>>() {
      @Override
      @NonNull
      public List<Schedule> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
          final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
          final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
          final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
          final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
          final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
          final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
          final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
          final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
          final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
          final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
          final List<Schedule> _result = new ArrayList<Schedule>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Schedule _item;
            _item = new Schedule();
            final long _tmpScheduleUid;
            _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
            _item.setScheduleUid(_tmpScheduleUid);
            final long _tmpSceduleStartTime;
            _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
            _item.setSceduleStartTime(_tmpSceduleStartTime);
            final long _tmpScheduleEndTime;
            _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
            _item.setScheduleEndTime(_tmpScheduleEndTime);
            final int _tmpScheduleDay;
            _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
            _item.setScheduleDay(_tmpScheduleDay);
            final int _tmpScheduleMonth;
            _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
            _item.setScheduleMonth(_tmpScheduleMonth);
            final int _tmpScheduleFrequency;
            _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
            _item.setScheduleFrequency(_tmpScheduleFrequency);
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _item.setUmCalendarUid(_tmpUmCalendarUid);
            final long _tmpScheduleClazzUid;
            _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
            _item.setScheduleClazzUid(_tmpScheduleClazzUid);
            final long _tmpScheduleMasterChangeSeqNum;
            _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
            _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
            final long _tmpScheduleLocalChangeSeqNum;
            _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
            _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
            final int _tmpScheduleLastChangedBy;
            _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
            _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
            final long _tmpScheduleLastChangedTime;
            _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
            _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
            final boolean _tmpScheduleActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
            _tmpScheduleActive = _tmp != 0;
            _item.setScheduleActive(_tmpScheduleActive);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
