package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.TransferJobItem;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class TransferJobItemDao_Impl extends TransferJobItemDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<TransferJobItem> __insertionAdapterOfTransferJobItem;

  private final SharedSQLiteStatement __preparedStmtOfUpdateTransferredProgress;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatus;

  private final SharedSQLiteStatement __preparedStmtOfInsertOutgoingReplicationForTransferJobItemIfDone;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatusIfNotCompleteForAllInJob;

  public TransferJobItemDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfTransferJobItem = new EntityInsertionAdapter<TransferJobItem>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `TransferJobItem` (`tjiUid`,`tjiTjUid`,`tjTotalSize`,`tjTransferred`,`tjAttemptCount`,`tjiSrc`,`tjiDest`,`tjiType`,`tjiStatus`,`tjiTableId`,`tjiEntityUid`,`tjiEntityEtag`,`tjiLockIdToRelease`,`tjiPartialTmpFile`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final TransferJobItem entity) {
        statement.bindLong(1, entity.getTjiUid());
        statement.bindLong(2, entity.getTjiTjUid());
        statement.bindLong(3, entity.getTjTotalSize());
        statement.bindLong(4, entity.getTjTransferred());
        statement.bindLong(5, entity.getTjAttemptCount());
        if (entity.getTjiSrc() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getTjiSrc());
        }
        if (entity.getTjiDest() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getTjiDest());
        }
        statement.bindLong(8, entity.getTjiType());
        statement.bindLong(9, entity.getTjiStatus());
        statement.bindLong(10, entity.getTjiTableId());
        statement.bindLong(11, entity.getTjiEntityUid());
        statement.bindLong(12, entity.getTjiEntityEtag());
        statement.bindLong(13, entity.getTjiLockIdToRelease());
        if (entity.getTjiPartialTmpFile() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getTjiPartialTmpFile());
        }
      }
    };
    this.__preparedStmtOfUpdateTransferredProgress = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE TransferJobItem\n"
                + "           SET tjTransferred = ?\n"
                + "         WHERE tjiUid = ?\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateStatus = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE TransferJobItem\n"
                + "           SET tjiStatus = ?\n"
                + "         WHERE tjiUid = ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfInsertOutgoingReplicationForTransferJobItemIfDone = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        INSERT INTO OutgoingReplication(destNodeId, orTableId, orPk1, orPk2)\n"
                + "        SELECT ? AS destNodeId, \n"
                + "              TransferJobItem.tjiTableId AS orTableId,\n"
                + "              TransferJobItem.tjiEntityUid AS orPk1,\n"
                + "              0 AS orPk2\n"
                + "        FROM TransferJobItem\n"
                + "       WHERE TransferJobItem.tjiUid = ?\n"
                + "         AND TransferJobItem.tjiTableId != 0\n"
                + "         AND TransferJobItem.tjiStatus = 21\n"
                + "         AND NOT EXISTS(\n"
                + "             SELECT OtherJob.tjiUid\n"
                + "               FROM TransferJobItem OtherJob\n"
                + "              WHERE OtherJob.tjiTableId = TransferJobItem.tjiTableId\n"
                + "                AND OtherJob.tjiEntityUid = TransferJobItem.tjiEntityUid\n"
                + "                AND OtherJob.tjiEntityEtag = TransferJobItem.tjiEntityEtag\n"
                + "                AND OtherJob.tjiStatus != 21)\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateStatusIfNotCompleteForAllInJob = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE TransferJobItem\n"
                + "           SET tjiStatus = ?\n"
                + "         WHERE tjiTjUid = ?\n"
                + "           AND tjiStatus != 21 \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertList(final List<TransferJobItem> items,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfTransferJobItem.insert(items);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object insert(final TransferJobItem item, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfTransferJobItem.insertAndReturnId(item);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateTransferredProgress(final int jobItemUid, final long transferred,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateTransferredProgress.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, transferred);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, jobItemUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateTransferredProgress.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateStatus(final int jobItemUid, final int status,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatus.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, jobItemUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateStatus.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object insertOutgoingReplicationForTransferJobItemIfDone(final long destNodeId,
      final int transferJobItemUid, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfInsertOutgoingReplicationForTransferJobItemIfDone.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, destNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, transferJobItemUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeInsert();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfInsertOutgoingReplicationForTransferJobItemIfDone.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateStatusIfNotCompleteForAllInJob(final int jobUid, final int status,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatusIfNotCompleteForAllInJob.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, jobUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateStatusIfNotCompleteForAllInJob.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByJobUid(final int jobUid,
      final Continuation<? super List<TransferJobItem>> $completion) {
    final String _sql = "\n"
            + "        SELECT TransferJobItem.*\n"
            + "          FROM TransferJobItem\n"
            + "         WHERE TransferJobItem.tjiTjUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<TransferJobItem>>() {
      @Override
      @NonNull
      public List<TransferJobItem> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiUid");
          final int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTjUid");
          final int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTotalSize");
          final int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTransferred");
          final int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "tjAttemptCount");
          final int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiSrc");
          final int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiDest");
          final int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiType");
          final int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiStatus");
          final int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTableId");
          final int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityUid");
          final int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityEtag");
          final int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiLockIdToRelease");
          final int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiPartialTmpFile");
          final List<TransferJobItem> _result = new ArrayList<TransferJobItem>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final TransferJobItem _item;
            final int _tmpTjiUid;
            _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
            final int _tmpTjiTjUid;
            _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
            final long _tmpTjTotalSize;
            _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
            final long _tmpTjTransferred;
            _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
            final int _tmpTjAttemptCount;
            _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
            final String _tmpTjiSrc;
            if (_cursor.isNull(_cursorIndexOfTjiSrc)) {
              _tmpTjiSrc = null;
            } else {
              _tmpTjiSrc = _cursor.getString(_cursorIndexOfTjiSrc);
            }
            final String _tmpTjiDest;
            if (_cursor.isNull(_cursorIndexOfTjiDest)) {
              _tmpTjiDest = null;
            } else {
              _tmpTjiDest = _cursor.getString(_cursorIndexOfTjiDest);
            }
            final int _tmpTjiType;
            _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
            final int _tmpTjiStatus;
            _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
            final int _tmpTjiTableId;
            _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
            final long _tmpTjiEntityUid;
            _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
            final long _tmpTjiEntityEtag;
            _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
            final long _tmpTjiLockIdToRelease;
            _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
            final String _tmpTjiPartialTmpFile;
            if (_cursor.isNull(_cursorIndexOfTjiPartialTmpFile)) {
              _tmpTjiPartialTmpFile = null;
            } else {
              _tmpTjiPartialTmpFile = _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
            }
            _item = new TransferJobItem(_tmpTjiUid,_tmpTjiTjUid,_tmpTjTotalSize,_tmpTjTransferred,_tmpTjAttemptCount,_tmpTjiSrc,_tmpTjiDest,_tmpTjiType,_tmpTjiStatus,_tmpTjiTableId,_tmpTjiEntityUid,_tmpTjiEntityEtag,_tmpTjiLockIdToRelease,_tmpTjiPartialTmpFile);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findPendingByJobUid(final int jobUid,
      final Continuation<? super List<TransferJobItem>> $completion) {
    final String _sql = "\n"
            + "        SELECT TransferJobItem.*\n"
            + "          FROM TransferJobItem\n"
            + "         WHERE TransferJobItem.tjiTjUid = ?\n"
            + "           AND TransferJobItem.tjiStatus < 21\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<TransferJobItem>>() {
      @Override
      @NonNull
      public List<TransferJobItem> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiUid");
          final int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTjUid");
          final int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTotalSize");
          final int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTransferred");
          final int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "tjAttemptCount");
          final int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiSrc");
          final int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiDest");
          final int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiType");
          final int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiStatus");
          final int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTableId");
          final int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityUid");
          final int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityEtag");
          final int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiLockIdToRelease");
          final int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiPartialTmpFile");
          final List<TransferJobItem> _result = new ArrayList<TransferJobItem>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final TransferJobItem _item;
            final int _tmpTjiUid;
            _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
            final int _tmpTjiTjUid;
            _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
            final long _tmpTjTotalSize;
            _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
            final long _tmpTjTransferred;
            _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
            final int _tmpTjAttemptCount;
            _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
            final String _tmpTjiSrc;
            if (_cursor.isNull(_cursorIndexOfTjiSrc)) {
              _tmpTjiSrc = null;
            } else {
              _tmpTjiSrc = _cursor.getString(_cursorIndexOfTjiSrc);
            }
            final String _tmpTjiDest;
            if (_cursor.isNull(_cursorIndexOfTjiDest)) {
              _tmpTjiDest = null;
            } else {
              _tmpTjiDest = _cursor.getString(_cursorIndexOfTjiDest);
            }
            final int _tmpTjiType;
            _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
            final int _tmpTjiStatus;
            _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
            final int _tmpTjiTableId;
            _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
            final long _tmpTjiEntityUid;
            _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
            final long _tmpTjiEntityEtag;
            _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
            final long _tmpTjiLockIdToRelease;
            _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
            final String _tmpTjiPartialTmpFile;
            if (_cursor.isNull(_cursorIndexOfTjiPartialTmpFile)) {
              _tmpTjiPartialTmpFile = null;
            } else {
              _tmpTjiPartialTmpFile = _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
            }
            _item = new TransferJobItem(_tmpTjiUid,_tmpTjiTjUid,_tmpTjTotalSize,_tmpTjTransferred,_tmpTjAttemptCount,_tmpTjiSrc,_tmpTjiDest,_tmpTjiType,_tmpTjiStatus,_tmpTjiTableId,_tmpTjiEntityUid,_tmpTjiEntityEtag,_tmpTjiLockIdToRelease,_tmpTjiPartialTmpFile);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findNumberJobItemsNotComplete(final int jobUid,
      final Continuation<? super Integer> $completion) {
    final String _sql = "\n"
            + "       SELECT COUNT(*)\n"
            + "         FROM TransferJobItem\n"
            + "        WHERE TransferJobItem.tjiTjUid = ?\n"
            + "          AND TransferjobItem.tjiStatus != 21\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<TransferJobItem>> findByEntityUidList(final List<Long> entityUidList,
      final int tableId) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT TransferJobItem.*");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM TransferJobItem");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE TransferJobItem.tjiTableId = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND TransferJobItem.tjiEntityUid IN (");
    final int _inputSize = entityUidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 1 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, tableId);
    _argIndex = 2;
    for (long _item : entityUidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"TransferJobItem"}, new Callable<List<TransferJobItem>>() {
      @Override
      @NonNull
      public List<TransferJobItem> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiUid");
          final int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTjUid");
          final int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTotalSize");
          final int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTransferred");
          final int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "tjAttemptCount");
          final int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiSrc");
          final int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiDest");
          final int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiType");
          final int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiStatus");
          final int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTableId");
          final int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityUid");
          final int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityEtag");
          final int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiLockIdToRelease");
          final int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiPartialTmpFile");
          final List<TransferJobItem> _result = new ArrayList<TransferJobItem>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final TransferJobItem _item_1;
            final int _tmpTjiUid;
            _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
            final int _tmpTjiTjUid;
            _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
            final long _tmpTjTotalSize;
            _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
            final long _tmpTjTransferred;
            _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
            final int _tmpTjAttemptCount;
            _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
            final String _tmpTjiSrc;
            if (_cursor.isNull(_cursorIndexOfTjiSrc)) {
              _tmpTjiSrc = null;
            } else {
              _tmpTjiSrc = _cursor.getString(_cursorIndexOfTjiSrc);
            }
            final String _tmpTjiDest;
            if (_cursor.isNull(_cursorIndexOfTjiDest)) {
              _tmpTjiDest = null;
            } else {
              _tmpTjiDest = _cursor.getString(_cursorIndexOfTjiDest);
            }
            final int _tmpTjiType;
            _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
            final int _tmpTjiStatus;
            _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
            final int _tmpTjiTableId;
            _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
            final long _tmpTjiEntityUid;
            _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
            final long _tmpTjiEntityEtag;
            _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
            final long _tmpTjiLockIdToRelease;
            _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
            final String _tmpTjiPartialTmpFile;
            if (_cursor.isNull(_cursorIndexOfTjiPartialTmpFile)) {
              _tmpTjiPartialTmpFile = null;
            } else {
              _tmpTjiPartialTmpFile = _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
            }
            _item_1 = new TransferJobItem(_tmpTjiUid,_tmpTjiTjUid,_tmpTjTotalSize,_tmpTjTransferred,_tmpTjAttemptCount,_tmpTjiSrc,_tmpTjiDest,_tmpTjiType,_tmpTjiStatus,_tmpTjiTableId,_tmpTjiEntityUid,_tmpTjiEntityEtag,_tmpTjiLockIdToRelease,_tmpTjiPartialTmpFile);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
