package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.PersonPasskey
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

@Dao
public actual abstract class PersonPasskeyDao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertAsync(personPasskey: PersonPasskey): Long

  @Query(`value` =
      "\n        SELECT PersonPasskey.ppId\n          FROM PersonPasskey\n              ")
  public actual abstract suspend fun allPasskey(): List<String>

  @Query(`value` =
      "\n        SELECT * \n          FROM PersonPasskey\n         WHERE isRevoked = 0\n         AND PersonPasskey.ppPersonUid = :uid\n              ")
  public actual abstract fun getAllActivePasskeys(uid: Long): Flow<List<PersonPasskey>>

  @Query(`value` =
      "\n        SELECT * \n          FROM PersonPasskey\n         WHERE isRevoked = 0\n          AND PersonPasskey.ppPersonUid = :uid\n              ")
  public actual abstract fun getAllActivePasskeysPaging(uid: Long): PagingSource<Int, PersonPasskey>

  @Query(`value` =
      "\n        SELECT *\n          FROM PersonPasskey\n         WHERE PersonPasskey.ppId = :id \n              ")
  public actual abstract suspend fun findPersonPasskeyFromClientDataJson(id: String): PersonPasskey?

  @Query(`value` =
      "\n        UPDATE PersonPasskey\n          set isRevoked = 1\n         WHERE PersonPasskey.personPasskeyUid = :uid \n              ")
  public actual abstract suspend fun revokePersonPasskey(uid: Long)
}
