package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.composites.ClazzInviteAndClazz
import com.ustadmobile.lib.db.composites.ClazzInviteWithTimeZone
import com.ustadmobile.lib.db.entities.ClazzInvite
import kotlin.IllegalStateException
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public class ClazzInviteDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: ClazzInviteDao,
) : ClazzInviteDao() {
  override suspend fun replace(entity: ClazzInvite): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ciUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(521)
      entity.ciUid = _newPk
    }
    entity.inviteLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.replace(entity)
    return entity.ciUid
  }

  override suspend fun insertAll(entity: List<ClazzInvite>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entity.iterator().forEach  {
      if(it.ciUid == 0L) {
        val _newPk = _pkManager.nextIdAsync(521)
        it.ciUid = _newPk
        _generatedPks += _newPk
      }
      it.inviteLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertAll(entity)
  }

  override suspend fun updateAll(entity: List<ClazzInvite>) {
    val _generatedPks = mutableListOf<Long>()
    entity.iterator().forEach  {
      it.inviteLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateAll(entity)
  }

  override suspend fun findInviteAsync(): List<ClazzInvite> = _dao.findInviteAsync()

  override suspend fun findClazzInviteEntityForInviteToken(inviteTokenUid: String):
      ClazzInviteWithTimeZone? = _dao.findClazzInviteEntityForInviteToken(inviteTokenUid)

  override fun findClazzInviteEntityForInviteTokenAsFlow(inviteTokenUid: String):
      Flow<ClazzInviteAndClazz?> = _dao.findClazzInviteEntityForInviteTokenAsFlow(inviteTokenUid)

  override suspend fun updateInviteStatus(
    status: Int,
    ciUid: Long,
    updateTime: Long,
  ) {
    _dao.updateInviteStatus(status, ciUid, updateTime)
  }

  override fun findPendingInviteByPersonUid(
    ciPersonUid: Long,
    clazzUid: Long,
    currentTime: Long,
  ): PagingSource<Int, ClazzInvite> = _dao.findPendingInviteByPersonUid(ciPersonUid, clazzUid,
      currentTime)

  override suspend fun updateClazzInviteToRevokeInvite(inviteContact: String): Int =
      _dao.updateClazzInviteToRevokeInvite(inviteContact)

  override suspend fun findClazzInviteFromContact(inviteContact: String): ClazzInvite? =
      _dao.findClazzInviteFromContact(inviteContact)

  public override fun insert(entity: ClazzInvite): Long = throw
      IllegalStateException("insert: synchronous db access is NOT possible on Javascript!")

  public override suspend fun insertAsync(entity: ClazzInvite): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ciUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(521)
      entity.ciUid = _newPk
    }
    entity.inviteLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.ciUid
  }

  public override fun insertList(entityList: List<ClazzInvite>): Unit = throw
      IllegalStateException("insertList: synchronous db access is NOT possible on Javascript!")

  public override fun update(entity: ClazzInvite): Unit = throw
      IllegalStateException("update: synchronous db access is NOT possible on Javascript!")
}
