package com.ustadmobile.core.db.dao

import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.ktor.KtorCallDaoAdapter
import com.ustadmobile.door.ktor.respondDoorJson
import com.ustadmobile.door.ktor.toDoorRequest
import io.ktor.server.application.call
import io.ktor.server.routing.Route
import io.ktor.server.routing.`get`
import kotlin.Suppress

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public fun Route.ClazzDao_KtorRoute(serverConfig: DoorHttpServerConfig,
    daoCallAdapter: KtorCallDaoAdapter<ClazzDao>) {
  `get`("findByClazzCode") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByClazzCode_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("clazzUidExistsAsync") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.clazzUidExistsAsync_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByUidAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByUidAsFlow_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByUidWithHolidayCalendarAsync") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByUidWithHolidayCalendarAsync_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findClazzesWithPermission") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findClazzesWithPermission_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("clazzAndDetailPermissionsAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.clazzAndDetailPermissionsAsFlow_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getClazzWithDisplayDetails") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getClazzWithDisplayDetails_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getTitleByUidAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getTitleByUidAsFlow_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getClazzNameAndTerminologyAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getClazzNameAndTerminologyAsFlow_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getClazzNameAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getClazzNameAsFlow_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getClazzTimeZoneByClazzUidAsync") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getClazzTimeZoneByClazzUidAsync_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getCoursesByName") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getCoursesByName_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findOneRosterUserClazzes") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findOneRosterUserClazzes_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
}
