package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ContentEntryContentCategoryJoin
import kotlin.Long
import kotlin.collections.List

public class ContentEntryContentCategoryJoinDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: ContentEntryContentCategoryJoinDao,
) : ContentEntryContentCategoryJoinDao() {
  override fun publicContentEntryContentCategoryJoins(): List<ContentEntryContentCategoryJoin> =
      _dao.publicContentEntryContentCategoryJoins()

  override fun findJoinByParentChildUuids(categoryUid: Long, contentEntry: Long):
      ContentEntryContentCategoryJoin? = _dao.findJoinByParentChildUuids(categoryUid, contentEntry)

  public override fun insert(entity: ContentEntryContentCategoryJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ceccjUid == 0L) {
      val _newPk = _pkManager.nextId(3)
      entity.ceccjUid = _newPk
    }
    entity.ceccjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.ceccjUid
  }

  public override suspend fun insertAsync(entity: ContentEntryContentCategoryJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ceccjUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(3)
      entity.ceccjUid = _newPk
    }
    entity.ceccjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.ceccjUid
  }

  public override fun insertList(entityList: List<ContentEntryContentCategoryJoin>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.ceccjUid == 0L) {
        val _newPk = _pkManager.nextId(3)
        it.ceccjUid = _newPk
        _generatedPks += _newPk
      }
      it.ceccjLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun update(entity: ContentEntryContentCategoryJoin) {
    entity.ceccjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
