/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libuicompose.util.phonenum;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TransformedText;
import androidx.compose.ui.text.input.VisualTransformation;
import com.ustadmobile.core.domain.phonenumber.IAsYouTypeFormatter;
import com.ustadmobile.libuicompose.util.phonenum.PhoneUtilsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/ustadmobile/libuicompose/util/phonenum/PhoneNumberTransformation;", "Landroidx/compose/ui/text/input/VisualTransformation;", "phoneNumberFormatter", "Lcom/ustadmobile/core/domain/phonenumber/IAsYouTypeFormatter;", "countryPrefix", "", "onGetSelectionEnd", "Lkotlin/Function1;", "", "", "(Lcom/ustadmobile/core/domain/phonenumber/IAsYouTypeFormatter;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "filter", "Landroidx/compose/ui/text/input/TransformedText;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "getFormattedNumber", "lastNonSeparator", "", "hasCursor", "", "preFilter", "textValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "reformat", "Lcom/ustadmobile/libuicompose/util/phonenum/PhoneNumberTransformation$Transformation;", "s", "cursor", "Transformation", "lib-ui-compose_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nPhoneNumberVisualTransformation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhoneNumberVisualTransformation.kt\ncom/ustadmobile/libuicompose/util/phonenum/PhoneNumberTransformation\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,141:1\n434#2:142\n507#2,5:143\n1179#2,2:148\n1188#2,3:150\n1188#2,3:153\n*S KotlinDebug\n*F\n+ 1 PhoneNumberVisualTransformation.kt\ncom/ustadmobile/libuicompose/util/phonenum/PhoneNumberTransformation\n*L\n42#1:142\n42#1:143,5\n84#1:148,2\n91#1:150,3\n110#1:153,3\n*E\n"})
public final class PhoneNumberTransformation
implements VisualTransformation {
    @NotNull
    private final IAsYouTypeFormatter phoneNumberFormatter;
    @NotNull
    private final String countryPrefix;
    @NotNull
    private final Function1<CharSequence, Integer> onGetSelectionEnd;
    public static final int $stable;

    public PhoneNumberTransformation(@NotNull IAsYouTypeFormatter phoneNumberFormatter, @NotNull String countryPrefix, @NotNull Function1<? super CharSequence, Integer> onGetSelectionEnd) {
        Intrinsics.checkNotNullParameter((Object)phoneNumberFormatter, (String)"phoneNumberFormatter");
        Intrinsics.checkNotNullParameter((Object)countryPrefix, (String)"countryPrefix");
        Intrinsics.checkNotNullParameter(onGetSelectionEnd, (String)"onGetSelectionEnd");
        this.phoneNumberFormatter = phoneNumberFormatter;
        this.countryPrefix = countryPrefix;
        this.onGetSelectionEnd = onGetSelectionEnd;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String preFilter(@NotNull String text) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String $this$filter$iv = text;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!PhoneUtilsKt.isReallyDialable(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string2 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final String preFilter(@NotNull TextFieldValue textValue) {
        Intrinsics.checkNotNullParameter((Object)textValue, (String)"textValue");
        return this.preFilter(textValue.getText());
    }

    @NotNull
    public TransformedText filter(@NotNull AnnotatedString text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Transformation transformation = this.reformat((CharSequence)text, ((Number)this.onGetSelectionEnd.invoke((Object)text)).intValue());
        String string2 = transformation.getFormatted();
        if (string2 == null) {
            string2 = "";
        }
        return new TransformedText(new AnnotatedString(string2, null, null, 6, null), new OffsetMapping(transformation){
            final /* synthetic */ Transformation $transformation;
            {
                this.$transformation = $transformation;
            }

            public int originalToTransformed(int offset) {
                int n;
                try {
                    n = ((Number)this.$transformation.getOriginalToTransformed().get(offset)).intValue();
                }
                catch (IndexOutOfBoundsException ex) {
                    n = CollectionsKt.getLastIndex(this.$transformation.getTransformedToOriginal());
                }
                int n2 = 0;
                return Math.max(n, n2);
            }

            public int transformedToOriginal(int offset) {
                return Math.max(((Number)this.$transformation.getTransformedToOriginal().get(offset)).intValue(), 0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Transformation reformat(CharSequence s, int cursor) {
        this.phoneNumberFormatter.clear();
        CharSequence $this$forEach$iv = this.countryPrefix;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            this.phoneNumberFormatter.inputDigitAndRememberPosition(it);
        }
        int curIndex = cursor - 1;
        String formatted = null;
        char lastNonSeparator = '\u0000';
        boolean hasCursor = false;
        CharSequence $this$forEachIndexed$iv = s;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void char_;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int index = n;
            boolean bl = false;
            if (PhoneUtilsKt.isNonSeparator((char)char_)) {
                if (lastNonSeparator != '\u0000') {
                    formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
                    hasCursor = false;
                }
                lastNonSeparator = char_;
            }
            if (index != curIndex) continue;
            hasCursor = true;
        }
        if (lastNonSeparator != '\u0000') {
            formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
        }
        List originalToTransformed = new ArrayList();
        List transformedToOriginal = new ArrayList();
        int specialCharsCount = 0;
        String string2 = formatted;
        if (string2 != null) {
            CharSequence $this$forEachIndexed$iv2 = string2;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (int i = 0; i < $this$forEachIndexed$iv2.length(); ++i) {
                void char_;
                char item$iv = $this$forEachIndexed$iv2.charAt(i);
                int n = index$iv2++;
                char c = item$iv;
                int index = n;
                boolean bl = false;
                if (!PhoneUtilsKt.isNonSeparator((char)char_)) {
                    ++specialCharsCount;
                } else {
                    originalToTransformed.add(index);
                }
                transformedToOriginal.add(index - specialCharsCount);
            }
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)originalToTransformed);
        originalToTransformed.add(n != null ? n + 1 : 0);
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)transformedToOriginal);
        transformedToOriginal.add(n2 != null ? n2 + 1 : 0);
        return new Transformation(formatted, originalToTransformed, transformedToOriginal);
    }

    private final String getFormattedNumber(char lastNonSeparator, boolean hasCursor) {
        return hasCursor ? StringsKt.removePrefix((String)this.phoneNumberFormatter.inputDigitAndRememberPosition(lastNonSeparator), (CharSequence)this.countryPrefix) : StringsKt.removePrefix((String)this.phoneNumberFormatter.inputDigit(lastNonSeparator), (CharSequence)this.countryPrefix);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J5\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/ustadmobile/libuicompose/util/phonenum/PhoneNumberTransformation$Transformation;", "", "formatted", "", "originalToTransformed", "", "", "transformedToOriginal", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getFormatted", "()Ljava/lang/String;", "getOriginalToTransformed", "()Ljava/util/List;", "getTransformedToOriginal", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "lib-ui-compose_release"})
    private static final class Transformation {
        @Nullable
        private final String formatted;
        @NotNull
        private final List<Integer> originalToTransformed;
        @NotNull
        private final List<Integer> transformedToOriginal;

        public Transformation(@Nullable String formatted, @NotNull List<Integer> originalToTransformed, @NotNull List<Integer> transformedToOriginal) {
            Intrinsics.checkNotNullParameter(originalToTransformed, (String)"originalToTransformed");
            Intrinsics.checkNotNullParameter(transformedToOriginal, (String)"transformedToOriginal");
            this.formatted = formatted;
            this.originalToTransformed = originalToTransformed;
            this.transformedToOriginal = transformedToOriginal;
        }

        @Nullable
        public final String getFormatted() {
            return this.formatted;
        }

        @NotNull
        public final List<Integer> getOriginalToTransformed() {
            return this.originalToTransformed;
        }

        @NotNull
        public final List<Integer> getTransformedToOriginal() {
            return this.transformedToOriginal;
        }

        @Nullable
        public final String component1() {
            return this.formatted;
        }

        @NotNull
        public final List<Integer> component2() {
            return this.originalToTransformed;
        }

        @NotNull
        public final List<Integer> component3() {
            return this.transformedToOriginal;
        }

        @NotNull
        public final Transformation copy(@Nullable String formatted, @NotNull List<Integer> originalToTransformed, @NotNull List<Integer> transformedToOriginal) {
            Intrinsics.checkNotNullParameter(originalToTransformed, (String)"originalToTransformed");
            Intrinsics.checkNotNullParameter(transformedToOriginal, (String)"transformedToOriginal");
            return new Transformation(formatted, originalToTransformed, transformedToOriginal);
        }

        public static /* synthetic */ Transformation copy$default(Transformation transformation, String string2, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = transformation.formatted;
            }
            if ((n & 2) != 0) {
                list = transformation.originalToTransformed;
            }
            if ((n & 4) != 0) {
                list2 = transformation.transformedToOriginal;
            }
            return transformation.copy(string2, list, list2);
        }

        @NotNull
        public String toString() {
            return "Transformation(formatted=" + this.formatted + ", originalToTransformed=" + this.originalToTransformed + ", transformedToOriginal=" + this.transformedToOriginal + ")";
        }

        public int hashCode() {
            int result = this.formatted == null ? 0 : this.formatted.hashCode();
            result = result * 31 + ((Object)this.originalToTransformed).hashCode();
            result = result * 31 + ((Object)this.transformedToOriginal).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Transformation)) {
                return false;
            }
            Transformation transformation = (Transformation)other;
            if (!Intrinsics.areEqual((Object)this.formatted, (Object)transformation.formatted)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.originalToTransformed, transformation.originalToTransformed)) {
                return false;
            }
            return Intrinsics.areEqual(this.transformedToOriginal, transformation.transformedToOriginal);
        }
    }
}

