/**
 * Read item for the provided store key
 *
 * @remarks The `readItem` method yields the value of the provided key, or undefined if it does not exist. You can chain assertions from this method. If you use TypeScript, you can set the type of the returned value
 *
 * @param store `IDBObjectStore` instance
 * @param key
 *
 * @returns  Promise<T>
 * @throws {Error} If it is chained off from a method that does not return an object store.
 */
export declare function readItem<T = unknown>(store: unknown, key: IDBValidKey | IDBKeyRange): Cypress.Chainable<T>;
/**
 * Delete item for the provided store key
 *
 * @remarks The `deleteItem` method deletes the value of the provided key, or undefined if it does not exist. You can chain assertions from this method. If you use TypeScript, you can set the type of the returned value
 *
 * @param store `IDBObjectStore` instance
 * @param key
 *
 * @returns Promise<IDBObjectStore>
 * @throws {Error} If it is chained off from a method that does not return an object store.
 */
export declare function deleteItem(store: IDBObjectStore, key: IDBValidKey): Cypress.Chainable<IDBObjectStore>;
/**
 * Create item for the provided store key
 *
 * @remarks The `createItem` method creates the key and value. You can chain assertions from this method. If you use TypeScript, you can set the type of the returned value
 *
 * @param store `IDBObjectStore` instance
 * @param key item key
 * @param value item value
 *
 * @returns Promise<IDBObjectStore>
 * @throws {Error} If it is chained off from a method that does not return an object store.
 */
export declare function createItem(store: IDBObjectStore, key: IDBValidKey, value: unknown): Cypress.Chainable<IDBObjectStore>;
/**
 * Update item for the provided store key
 *
 * @remarks The `updateItem` method updates the value for the key provided. You can chain assertions from this method. If you use TypeScript, you can set the type of the returned value
 *
 * @param store `IDBObjectStore` instance
 * @param key item key
 * @param value item value
 *
 * @returns Promise<IDBObjectStore>
 * @throws {Error} If it is chained off from a method that does not return an object store.
 */
export declare function updateItem(store: IDBObjectStore, key: IDBValidKey, value: unknown): Cypress.Chainable<IDBObjectStore>;
/**
 * Add item
 *
 * @remarks The `addItem` method adds the value provided to the store. You can chain assertions from this method. If you use TypeScript, you can set the type of the returned value
 * @remarks This method is only useable if the `IDBObjectStore` it is called upon is created with autoIncrement: true
 *
 * @param store `IDBObjectStore` instance
 * @param value item value
 *
 * @returns Promise<IDBObjectStore>
 * @throws {Error} If it is chained off from a method that does not return an object store.
 */
export declare function addItem(store: IDBObjectStore, value: unknown): Cypress.Chainable<IDBObjectStore>;
