/**
 * List keys in store
 *
 * @remarks The `keys` method lists the keys available in the provided store.
 *
 * @param store `IDBObjectStore` instance
 *
 * @returns Promise<IDBValidKey[]>
 * @throws {Error} If it is chained off from a method that does not return an object store.
 */
export declare function keys(store: IDBObjectStore): Cypress.Chainable<IDBValidKey[]>;
/**
 * List all entries in store
 *
 * @remarks The `entries` method lists all the values saved in the store.
 *
 * @param store `IDBObjectStore` instance
 *
 * @returns Promise<T[]>
 * @throws {Error} If it is chained off from a method that does not return an object store.
 */
export declare function entries<T = unknown>(store: IDBObjectStore): Cypress.Chainable<T[]>;
