export declare function createDatabaseConnection(databaseName: string, versionConfiguredByUser?: number): Promise<IDBDatabase>;
/**
 * Open a database connection
 *
 * @remarks The `openIndexedDb` opens a connection with the provided `databaseName` and `version`.
 * @remarks the parameters is for developers who will touch this code in the future. It signals that this version number was passed down by the user and not incremented by our library.
 *
 * @param databaseName Database name
 * @param version Database version
 *
 * @returns Promise<IDBDatabase>
 * @throws {Error} If the connections fails to open.
 */
export declare function openIndexedDb(databaseName: string, version?: number): Cypress.Chainable<IDBDatabase>;
