/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.validateusername;

import com.ustadmobile.core.domain.validateusername.ValidationResult;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lcom/ustadmobile/core/domain/validateusername/ValidateUsernameUseCase;", "", "()V", "invoke", "Lcom/ustadmobile/core/domain/validateusername/ValidationResult;", "username", "", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nValidateUsernameUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidateUsernameUseCase.kt\ncom/ustadmobile/core/domain/validateusername/ValidateUsernameUseCase\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,45:1\n1064#2,2:46\n*S KotlinDebug\n*F\n+ 1 ValidateUsernameUseCase.kt\ncom/ustadmobile/core/domain/validateusername/ValidateUsernameUseCase\n*L\n28#1:46,2\n*E\n"})
public final class ValidateUsernameUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MIN_LENGTH = 3;
    private static final int MAX_LENGTH = 30;
    @NotNull
    private static final Set<Character> ALLOWED_SPECIAL;

    @NotNull
    public final ValidationResult invoke(@NotNull String username) {
        ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        if (username.length() < 3) {
            validationResult = ValidationResult.Companion.getTooShort();
        } else if (username.length() > 30) {
            validationResult = ValidationResult.Companion.getTooLong();
        } else {
            Character c = StringsKt.firstOrNull((CharSequence)username);
            boolean bl = c != null ? Character.isDigit(c.charValue()) : false;
            if (bl) {
                validationResult = ValidationResult.Companion.getStartsWithNumber();
            } else {
                boolean bl2;
                block7: {
                    CharSequence $this$all$iv = username;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$all$iv.charAt(i);
                        boolean bl3 = false;
                        if (Companion.isValidUsernameChar(it)) continue;
                        bl2 = false;
                        break block7;
                    }
                    bl2 = true;
                }
                validationResult = !bl2 ? ValidationResult.Companion.getInvalidCharacters() : ValidationResult.Companion.getValid();
            }
        }
        return validationResult;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf('_')};
        ALLOWED_SPECIAL = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/core/domain/validateusername/ValidateUsernameUseCase$Companion;", "", "()V", "ALLOWED_SPECIAL", "", "", "getALLOWED_SPECIAL", "()Ljava/util/Set;", "MAX_LENGTH", "", "MIN_LENGTH", "isValidUsernameChar", "", "character", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Character> getALLOWED_SPECIAL() {
            return ALLOWED_SPECIAL;
        }

        public final boolean isValidUsernameChar(char character) {
            return Character.isLetter(character) ? true : (Character.isDigit(character) ? true : this.getALLOWED_SPECIAL().contains(Character.valueOf(character)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

