/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.xapi.state;

import androidx.sqlite.db.SupportSQLiteDatabase;
import com.benasher44.uuid.UuidKt;
import com.ustadmobile.core.account.LearningSpace;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.domain.interop.HttpApiException;
import com.ustadmobile.core.domain.xapi.ext.XapiSessionEntityExtKt;
import com.ustadmobile.core.domain.xapi.model.XapiActorKt;
import com.ustadmobile.core.domain.xapi.model.XapiAgent;
import com.ustadmobile.core.util.ext.LongExtCommonKt;
import com.ustadmobile.door.DoorDatabaseCallbackStatementList;
import com.ustadmobile.door.ext.DoorSqlDatabaseExtKt;
import com.ustadmobile.door.util.SystemTimeKt;
import com.ustadmobile.lib.db.entities.xapi.StateDeleteCommand;
import com.ustadmobile.lib.db.entities.xapi.XapiSessionEntity;
import com.ustadmobile.xxhashkmp.XXHasher64;
import com.ustadmobile.xxhashkmp.XXHasher64Factory;
import com.ustadmobile.xxhashkmp.XXStringHasher;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086B\u00a2\u0006\u0002\u0010\u0012J\n\u0010\u0013\u001a\u00020\u0014*\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ustadmobile/core/domain/xapi/state/DeleteXapiStateUseCase;", "", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "repo", "xxStringHasher", "Lcom/ustadmobile/xxhashkmp/XXStringHasher;", "xxHasher64Factory", "Lcom/ustadmobile/xxhashkmp/XXHasher64Factory;", "learningSpace", "Lcom/ustadmobile/core/account/LearningSpace;", "(Lcom/ustadmobile/core/db/UmAppDatabase;Lcom/ustadmobile/core/db/UmAppDatabase;Lcom/ustadmobile/xxhashkmp/XXStringHasher;Lcom/ustadmobile/xxhashkmp/XXHasher64Factory;Lcom/ustadmobile/core/account/LearningSpace;)V", "invoke", "", "request", "Lcom/ustadmobile/core/domain/xapi/state/DeleteXapiStateUseCase$DeleteXapiStateRequest;", "session", "Lcom/ustadmobile/lib/db/entities/xapi/XapiSessionEntity;", "(Lcom/ustadmobile/core/domain/xapi/state/DeleteXapiStateUseCase$DeleteXapiStateRequest;Lcom/ustadmobile/lib/db/entities/xapi/XapiSessionEntity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hash", "", "AddXapiStateAddTriggersCallback", "DeleteXapiStateRequest", "core_release"})
@SourceDebugExtension(value={"SMAP\nDeleteXapiStateUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteXapiStateUseCase.kt\ncom/ustadmobile/core/domain/xapi/state/DeleteXapiStateUseCase\n+ 2 Strings.kt\nio/ktor/utils/io/core/StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n7#2,4:156\n7#2,4:160\n1#3:164\n*S KotlinDebug\n*F\n+ 1 DeleteXapiStateUseCase.kt\ncom/ustadmobile/core/domain/xapi/state/DeleteXapiStateUseCase\n*L\n115#1:156,4\n123#1:160,4\n*E\n"})
public final class DeleteXapiStateUseCase {
    @NotNull
    private final UmAppDatabase db;
    @Nullable
    private final UmAppDatabase repo;
    @NotNull
    private final XXStringHasher xxStringHasher;
    @NotNull
    private final XXHasher64Factory xxHasher64Factory;
    @NotNull
    private final LearningSpace learningSpace;

    public DeleteXapiStateUseCase(@NotNull UmAppDatabase db, @Nullable UmAppDatabase repo, @NotNull XXStringHasher xxStringHasher, @NotNull XXHasher64Factory xxHasher64Factory, @NotNull LearningSpace learningSpace) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)xxStringHasher, (String)"xxStringHasher");
        Intrinsics.checkNotNullParameter((Object)xxHasher64Factory, (String)"xxHasher64Factory");
        Intrinsics.checkNotNullParameter((Object)learningSpace, (String)"learningSpace");
        this.db = db;
        this.repo = repo;
        this.xxStringHasher = xxStringHasher;
        this.xxHasher64Factory = xxHasher64Factory;
        this.learningSpace = learningSpace;
    }

    public final long hash(@NotNull DeleteXapiStateRequest $this$hash) {
        XXHasher64 xxHasher64;
        block5: {
            byte[] byArray;
            String string2;
            byte[] byArray2;
            Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
            xxHasher64 = this.xxHasher64Factory.newHasher(0L);
            String $this$toByteArray_u24default$iv = $this$hash.getActivityId();
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$toByteArray = false;
            if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
                byArray2 = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
            } else {
                CharsetEncoder charsetEncoder = charset$iv.newEncoder();
                Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
                byArray2 = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv, (int)0, (int)$this$toByteArray_u24default$iv.length());
            }
            xxHasher64.update(byArray2);
            String string3 = $this$hash.getRegistration();
            if (string3 != null) {
                String it = string2 = string3;
                boolean bl = false;
                UUID uuid = UuidKt.uuidFrom((String)it);
                xxHasher64.update(LongExtCommonKt.toByteArray(uuid.getMostSignificantBits()));
                xxHasher64.update(LongExtCommonKt.toByteArray(uuid.getLeastSignificantBits()));
            }
            String string4 = $this$hash.getStateId();
            if (string4 == null) break block5;
            String it = string2 = string4;
            boolean bl = false;
            String $this$toByteArray_u24default$iv2 = it;
            Charset charset$iv2 = Charsets.UTF_8;
            boolean $i$f$toByteArray2 = false;
            if (Intrinsics.areEqual((Object)charset$iv2, (Object)Charsets.UTF_8)) {
                byArray = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv2);
            } else {
                CharsetEncoder charsetEncoder = charset$iv2.newEncoder();
                Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
                byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv2, (int)0, (int)$this$toByteArray_u24default$iv2.length());
            }
            xxHasher64.update(byArray);
        }
        return xxHasher64.digest();
    }

    @Nullable
    public final Object invoke(@NotNull DeleteXapiStateRequest request2, @NotNull XapiSessionEntity session, @NotNull Continuation<? super Unit> $completion) {
        UUID uUID;
        String string2 = request2.getRegistration();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            uUID = UuidKt.uuidFrom((String)it);
        } else {
            uUID = null;
        }
        UUID registrationUuid2 = uUID;
        long requestActorUid = XapiActorKt.identifierHash(request2.getAgent(), this.xxStringHasher);
        long sessionActorUid = XapiActorKt.identifierHash(XapiSessionEntityExtKt.agent(session, this.learningSpace), this.xxStringHasher);
        if (requestActorUid != sessionActorUid) {
            throw new HttpApiException(403, "Forbidden: Agent does not match session", null, 4, null);
        }
        UmAppDatabase umAppDatabase = this.repo;
        if (umAppDatabase == null) {
            umAppDatabase = this.db;
        }
        UUID uUID2 = registrationUuid2;
        UUID uUID3 = registrationUuid2;
        Object object = umAppDatabase.stateDeleteCommandDao().insertAsync(new StateDeleteCommand(XapiActorKt.identifierHash(request2.getAgent(), this.xxStringHasher), this.hash(request2), this.xxStringHasher.hash(request2.getActivityId()), request2.getStateId(), SystemTimeKt.systemTimeInMillis(), uUID2 != null ? Boxing.boxLong((long)uUID2.getMostSignificantBits()) : null, uUID3 != null ? Boxing.boxLong((long)uUID3.getLeastSignificantBits()) : null), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0016J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/core/domain/xapi/state/DeleteXapiStateUseCase$AddXapiStateAddTriggersCallback;", "Lcom/ustadmobile/door/DoorDatabaseCallbackStatementList;", "()V", "onCreate", "", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "Lcom/ustadmobile/door/DoorSqlDatabase;", "onOpen", "core_release"})
    @SourceDebugExtension(value={"SMAP\nDeleteXapiStateUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteXapiStateUseCase.kt\ncom/ustadmobile/core/domain/xapi/state/DeleteXapiStateUseCase$AddXapiStateAddTriggersCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1855#2,2:156\n*S KotlinDebug\n*F\n+ 1 DeleteXapiStateUseCase.kt\ncom/ustadmobile/core/domain/xapi/state/DeleteXapiStateUseCase$AddXapiStateAddTriggersCallback\n*L\n47#1:156,2\n*E\n"})
    public static final class AddXapiStateAddTriggersCallback
    implements DoorDatabaseCallbackStatementList {
        @NotNull
        public List<String> onCreate(@NotNull SupportSQLiteDatabase db) {
            List list;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            List $this$onCreate_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (DoorSqlDatabaseExtKt.dbType((SupportSQLiteDatabase)db) == 1) {
                Object[] objectArray = new String[]{"INSERT", "UPDATE"};
                Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String event = (String)element$iv;
                    boolean bl2 = false;
                    String string2 = event.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    String string3 = string2.substring(0, 3);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    $this$onCreate_u24lambda_u241.add("\n                            CREATE TRIGGER IF NOT EXISTS xapi_state_delete_trig_" + string3 + "\n                            AFTER " + event + " ON StateDeleteCommand\n                            FOR EACH ROW\n                            BEGIN\n                            UPDATE StateEntity\n                               SET seDeleted = 1,\n                                   seLastMod = NEW.sdcLastMod\n                             WHERE seActorUid = NEW.sdcActorUid\n                               AND seActivityUid = NEW.sdcActivityUid\n                               AND seLastMod < NEW.sdcLastMod\n                               AND (    (      NEW.sdcRegistrationHi IS NULL \n                                           AND seRegistrationHi IS NULL\n                                           AND NEW.sdcRegistrationLo IS NULL\n                                           AND seRegistrationLo IS NULL)\n                                     OR (     seRegistrationHi = NEW.sdcRegistrationHi\n                                          AND seRegistrationLo = NEW.sdcRegistrationLo))\n                               AND (    NEW.sdcStateId IS NULL\n                                     OR seStateId = NEW.sdcStateId);\n                            END         \n                        ");
                }
            } else {
                $this$onCreate_u24lambda_u241.add("\n                        CREATE OR REPLACE FUNCTION xapi_state_delete_fn() RETURNS TRIGGER AS $$\n                        BEGIN\n                        UPDATE StateEntity\n                           SET seDeleted = TRUE,\n                               seLastMod = NEW.sdcLastMod\n                         WHERE seActorUid = NEW.sdcActorUid\n                           AND seActivityUid = NEW.sdcActivityUid\n                           AND seLastMod < NEW.sdcLastMod\n                           AND (    (      NEW.sdcRegistrationHi IS NULL \n                                       AND seRegistrationHi IS NULL\n                                       AND NEW.sdcRegistrationLo IS NULL\n                                       AND seRegistrationLo IS NULL)\n                                 OR (     seRegistrationHi = NEW.sdcRegistrationHi\n                                      AND seRegistrationLo = NEW.sdcRegistrationLo))\n                           AND (    NEW.sdcStateId IS NULL\n                                 OR seStateId = NEW.sdcStateId);\n                         RETURN NEW;\n                         END $$ LANGUAGE plpgsql\n                    ");
                $this$onCreate_u24lambda_u241.add("\n                        CREATE TRIGGER xapi_state_delete_trig\n                        AFTER INSERT OR UPDATE ON StateDeleteCommand\n                        FOR EACH ROW\n                        EXECUTE FUNCTION xapi_state_delete_fn();\n                    ");
            }
            return CollectionsKt.build((List)list);
        }

        @NotNull
        public List<String> onOpen(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            return CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/ustadmobile/core/domain/xapi/state/DeleteXapiStateUseCase$DeleteXapiStateRequest;", "", "activityId", "", "agent", "Lcom/ustadmobile/core/domain/xapi/model/XapiAgent;", "registration", "stateId", "(Ljava/lang/String;Lcom/ustadmobile/core/domain/xapi/model/XapiAgent;Ljava/lang/String;Ljava/lang/String;)V", "getActivityId", "()Ljava/lang/String;", "getAgent", "()Lcom/ustadmobile/core/domain/xapi/model/XapiAgent;", "getRegistration", "getStateId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "core_release"})
    public static final class DeleteXapiStateRequest {
        @NotNull
        private final String activityId;
        @NotNull
        private final XapiAgent agent;
        @Nullable
        private final String registration;
        @Nullable
        private final String stateId;

        public DeleteXapiStateRequest(@NotNull String activityId, @NotNull XapiAgent agent, @Nullable String registration, @Nullable String stateId) {
            Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
            Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
            this.activityId = activityId;
            this.agent = agent;
            this.registration = registration;
            this.stateId = stateId;
        }

        @NotNull
        public final String getActivityId() {
            return this.activityId;
        }

        @NotNull
        public final XapiAgent getAgent() {
            return this.agent;
        }

        @Nullable
        public final String getRegistration() {
            return this.registration;
        }

        @Nullable
        public final String getStateId() {
            return this.stateId;
        }

        @NotNull
        public final String component1() {
            return this.activityId;
        }

        @NotNull
        public final XapiAgent component2() {
            return this.agent;
        }

        @Nullable
        public final String component3() {
            return this.registration;
        }

        @Nullable
        public final String component4() {
            return this.stateId;
        }

        @NotNull
        public final DeleteXapiStateRequest copy(@NotNull String activityId, @NotNull XapiAgent agent, @Nullable String registration, @Nullable String stateId) {
            Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
            Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
            return new DeleteXapiStateRequest(activityId, agent, registration, stateId);
        }

        public static /* synthetic */ DeleteXapiStateRequest copy$default(DeleteXapiStateRequest deleteXapiStateRequest, String string2, XapiAgent xapiAgent, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = deleteXapiStateRequest.activityId;
            }
            if ((n & 2) != 0) {
                xapiAgent = deleteXapiStateRequest.agent;
            }
            if ((n & 4) != 0) {
                string3 = deleteXapiStateRequest.registration;
            }
            if ((n & 8) != 0) {
                string4 = deleteXapiStateRequest.stateId;
            }
            return deleteXapiStateRequest.copy(string2, xapiAgent, string3, string4);
        }

        @NotNull
        public String toString() {
            return "DeleteXapiStateRequest(activityId=" + this.activityId + ", agent=" + this.agent + ", registration=" + this.registration + ", stateId=" + this.stateId + ")";
        }

        public int hashCode() {
            int result = this.activityId.hashCode();
            result = result * 31 + this.agent.hashCode();
            result = result * 31 + (this.registration == null ? 0 : this.registration.hashCode());
            result = result * 31 + (this.stateId == null ? 0 : this.stateId.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeleteXapiStateRequest)) {
                return false;
            }
            DeleteXapiStateRequest deleteXapiStateRequest = (DeleteXapiStateRequest)other;
            if (!Intrinsics.areEqual((Object)this.activityId, (Object)deleteXapiStateRequest.activityId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.agent, (Object)deleteXapiStateRequest.agent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.registration, (Object)deleteXapiStateRequest.registration)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stateId, (Object)deleteXapiStateRequest.stateId);
        }
    }
}

