/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.credentials.passkey.request;

import androidx.room.RoomDatabase;
import com.ustadmobile.core.MR;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.domain.credentials.passkey.EncodeUserHandleUseCase;
import com.ustadmobile.core.domain.credentials.passkey.model.AuthenticatorSelectionCriteria;
import com.ustadmobile.core.domain.credentials.passkey.model.PublicKeyCredentialCreationOptionsJSON;
import com.ustadmobile.core.domain.credentials.passkey.model.PublicKeyCredentialParameters;
import com.ustadmobile.core.domain.credentials.passkey.model.PublicKeyCredentialRpEntity;
import com.ustadmobile.core.domain.credentials.passkey.model.PublicKeyCredentialUserEntityJSON;
import com.ustadmobile.core.domain.credentials.username.CreateCredentialUsernameUseCase;
import com.ustadmobile.core.impl.UstadMobileSystemImpl;
import com.ustadmobile.core.impl.config.SystemUrlConfig;
import com.ustadmobile.door.ext.DoorDatabaseExtKt;
import com.ustadmobile.lib.util.RandomStringKt;
import io.ktor.http.URLUtilsKt;
import io.ktor.util.Base64Kt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ustadmobile/core/domain/credentials/passkey/request/CreatePublicKeyCredentialCreationOptionsJsonUseCase;", "", "systemUrlConfig", "Lcom/ustadmobile/core/impl/config/SystemUrlConfig;", "systemImpl", "Lcom/ustadmobile/core/impl/UstadMobileSystemImpl;", "createCredentialUsernameUseCase", "Lcom/ustadmobile/core/domain/credentials/username/CreateCredentialUsernameUseCase;", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "encodeUserHandleUseCase", "Lcom/ustadmobile/core/domain/credentials/passkey/EncodeUserHandleUseCase;", "(Lcom/ustadmobile/core/impl/config/SystemUrlConfig;Lcom/ustadmobile/core/impl/UstadMobileSystemImpl;Lcom/ustadmobile/core/domain/credentials/username/CreateCredentialUsernameUseCase;Lcom/ustadmobile/core/db/UmAppDatabase;Lcom/ustadmobile/core/domain/credentials/passkey/EncodeUserHandleUseCase;)V", "invoke", "Lcom/ustadmobile/core/domain/credentials/passkey/model/PublicKeyCredentialCreationOptionsJSON;", "username", "", "core_debug"})
public final class CreatePublicKeyCredentialCreationOptionsJsonUseCase {
    @NotNull
    private final SystemUrlConfig systemUrlConfig;
    @NotNull
    private final UstadMobileSystemImpl systemImpl;
    @NotNull
    private final CreateCredentialUsernameUseCase createCredentialUsernameUseCase;
    @NotNull
    private final UmAppDatabase db;
    @NotNull
    private final EncodeUserHandleUseCase encodeUserHandleUseCase;

    public CreatePublicKeyCredentialCreationOptionsJsonUseCase(@NotNull SystemUrlConfig systemUrlConfig, @NotNull UstadMobileSystemImpl systemImpl, @NotNull CreateCredentialUsernameUseCase createCredentialUsernameUseCase, @NotNull UmAppDatabase db, @NotNull EncodeUserHandleUseCase encodeUserHandleUseCase) {
        Intrinsics.checkNotNullParameter((Object)systemUrlConfig, (String)"systemUrlConfig");
        Intrinsics.checkNotNullParameter((Object)systemImpl, (String)"systemImpl");
        Intrinsics.checkNotNullParameter((Object)createCredentialUsernameUseCase, (String)"createCredentialUsernameUseCase");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)encodeUserHandleUseCase, (String)"encodeUserHandleUseCase");
        this.systemUrlConfig = systemUrlConfig;
        this.systemImpl = systemImpl;
        this.createCredentialUsernameUseCase = createCredentialUsernameUseCase;
        this.db = db;
        this.encodeUserHandleUseCase = encodeUserHandleUseCase;
    }

    @NotNull
    public final PublicKeyCredentialCreationOptionsJSON invoke(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        String challenge = RandomStringKt.randomString$default((int)16, null, (int)2, null);
        String credentialUsername = this.createCredentialUsernameUseCase.invoke(username);
        long personPasskeyUid = DoorDatabaseExtKt.getDoorPrimaryKeyManager((RoomDatabase)((RoomDatabase)this.db)).nextId(892);
        String encodeUserHandle = this.encodeUserHandleUseCase.invoke(personPasskeyUid);
        Object object = URLUtilsKt.Url((String)this.systemUrlConfig.getSystemBaseUrl()).getHost();
        String string2 = this.systemImpl.getString(MR.strings.INSTANCE.getApp_name());
        PublicKeyCredentialRpEntity publicKeyCredentialRpEntity = new PublicKeyCredentialRpEntity(string2, (String)object, null);
        object = new PublicKeyCredentialUserEntityJSON(encodeUserHandle, credentialUsername, credentialUsername);
        string2 = Base64Kt.encodeBase64((String)challenge);
        Object object2 = new PublicKeyCredentialParameters[]{new PublicKeyCredentialParameters("public-key", -7), new PublicKeyCredentialParameters("public-key", -257)};
        List list = CollectionsKt.listOf((Object[])object2);
        object2 = new AuthenticatorSelectionCriteria("platform", "required", false, null, 12, null);
        return new PublicKeyCredentialCreationOptionsJSON(publicKeyCredentialRpEntity, (PublicKeyCredentialUserEntityJSON)object, string2, list, 1800000L, null, (AuthenticatorSelectionCriteria)object2, null, null, null, null, 1952, null);
    }
}

