/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.logging;

import io.github.aakira.napier.Antilog;
import io.github.aakira.napier.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0019J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0016J.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0007`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\u0007*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/ustadmobile/core/logging/LogbackAntiLog;", "Lio/github/aakira/napier/Antilog;", "()V", "anonymousClass", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "defaultTag", "", "logger", "Lorg/slf4j/Logger;", "tagMap", "Ljava/util/HashMap;", "Lio/github/aakira/napier/LogLevel;", "Lkotlin/collections/HashMap;", "stackTraceString", "", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "buildLog", "priority", "tag", "message", "buildLog$core", "createStackElementTag", "className", "createStackElementTag$core", "isEnable", "", "performLog", "", "throwable", "performTag", "Companion", "core"})
public final class LogbackAntiLog
extends Antilog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String defaultTag;
    private final Pattern anonymousClass = Pattern.compile("(\\$\\d+)+$");
    @NotNull
    private final HashMap<LogLevel, String> tagMap;
    @NotNull
    private final Logger logger;
    private static final int CALL_STACK_INDEX = 8;

    public LogbackAntiLog() {
        this.defaultTag = "app";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)LogLevel.VERBOSE, (Object)"[VERBOSE]"), TuplesKt.to((Object)LogLevel.DEBUG, (Object)"[DEBUG]"), TuplesKt.to((Object)LogLevel.INFO, (Object)"[INFO]"), TuplesKt.to((Object)LogLevel.WARNING, (Object)"[WARN]"), TuplesKt.to((Object)LogLevel.ERROR, (Object)"[ERROR]"), TuplesKt.to((Object)LogLevel.ASSERT, (Object)"[ASSERT]")};
        this.tagMap = MapsKt.hashMapOf((Pair[])pairArray);
        Logger logger = LoggerFactory.getLogger((String)LogbackAntiLog.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public boolean isEnable(@NotNull LogLevel priority, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        return !Intrinsics.areEqual((Object)tag, (Object)"DoorLog") || priority != LogLevel.VERBOSE;
    }

    protected void performLog(@NotNull LogLevel priority, @Nullable String tag, @Nullable Throwable throwable, @Nullable String message) {
        Object object;
        String debugTag;
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        String string = tag;
        if (string == null) {
            string = debugTag = this.performTag(this.defaultTag);
        }
        if (message != null) {
            object = throwable != null ? message + "\n" + this.getStackTraceString(throwable) : message;
        } else {
            object = throwable;
            if (object == null || (object = this.getStackTraceString((Throwable)object)) == null) {
                return;
            }
        }
        Object fullMessage = object;
        switch (WhenMappings.$EnumSwitchMapping$0[priority.ordinal()]) {
            case 1: {
                this.logger.trace(this.buildLog$core(priority, debugTag, (String)fullMessage));
                break;
            }
            case 2: {
                this.logger.debug(this.buildLog$core(priority, debugTag, (String)fullMessage));
                break;
            }
            case 3: {
                this.logger.info(this.buildLog$core(priority, debugTag, (String)fullMessage));
                break;
            }
            case 4: {
                this.logger.warn(this.buildLog$core(priority, debugTag, (String)fullMessage));
                break;
            }
            case 5: {
                this.logger.error(this.buildLog$core(priority, debugTag, (String)fullMessage));
                break;
            }
            case 6: {
                this.logger.error(this.buildLog$core(priority, debugTag, (String)fullMessage));
            }
        }
    }

    @NotNull
    public final String buildLog$core(@NotNull LogLevel priority, @Nullable String tag, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        String string = this.tagMap.get(priority);
        String string2 = tag;
        if (string2 == null) {
            string2 = this.performTag(this.defaultTag);
        }
        return string + " " + string2 + " - " + message;
    }

    private final String performTag(String defaultTag) {
        Object object;
        StackTraceElement[] thread = Thread.currentThread().getStackTrace();
        if (thread.length >= 8) {
            StackTraceElement $this$performTag_u24lambda_u240 = thread[8];
            boolean bl = false;
            String string = $this$performTag_u24lambda_u240.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            object = this.createStackElementTag$core(string) + "$" + $this$performTag_u24lambda_u240.getMethodName();
        } else {
            object = defaultTag;
        }
        return object;
    }

    @NotNull
    public final String createStackElementTag$core(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String tag = className;
        Matcher m = this.anonymousClass.matcher(tag);
        if (m.find()) {
            String string = m.replaceAll("");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceAll(...)");
            tag = string;
        }
        String string = tag.substring(StringsKt.lastIndexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final String getStackTraceString(Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/core/logging/LogbackAntiLog$Companion;", "", "()V", "CALL_STACK_INDEX", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.VERBOSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ASSERT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

