/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache;

import androidx.room.RoomDatabase;
import com.ustadmobile.door.ext.DoorDatabaseExtKt;
import com.ustadmobile.libcache.db.UstadCacheDb;
import com.ustadmobile.libcache.db.entities.CacheEntry;
import com.ustadmobile.libcache.logging.UstadCacheLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ustadmobile/libcache/UstadCacheTrimmer;", "", "db", "Lcom/ustadmobile/libcache/db/UstadCacheDb;", "fileSystem", "Lkotlinx/io/files/FileSystem;", "logger", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "sizeLimit", "Lkotlin/Function0;", "", "(Lcom/ustadmobile/libcache/db/UstadCacheDb;Lkotlinx/io/files/FileSystem;Lcom/ustadmobile/libcache/logging/UstadCacheLogger;Lkotlin/jvm/functions/Function0;)V", "_evictedEntriesFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "", "evictedEntriesFlow", "Lkotlinx/coroutines/flow/Flow;", "getEvictedEntriesFlow", "()Lkotlinx/coroutines/flow/Flow;", "logPrefix", "trim", "", "lib-cache_release"})
@SourceDebugExtension(value={"SMAP\nUstadCacheTrimmer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UstadCacheTrimmer.kt\ncom/ustadmobile/libcache/UstadCacheTrimmer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1855#2:74\n1856#2:76\n1#3:75\n*S KotlinDebug\n*F\n+ 1 UstadCacheTrimmer.kt\ncom/ustadmobile/libcache/UstadCacheTrimmer\n*L\n67#1:74\n67#1:76\n*E\n"})
public final class UstadCacheTrimmer {
    @NotNull
    private final UstadCacheDb db;
    @NotNull
    private final FileSystem fileSystem;
    @Nullable
    private final UstadCacheLogger logger;
    @NotNull
    private final Function0<Long> sizeLimit;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final MutableSharedFlow<List<String>> _evictedEntriesFlow;
    @NotNull
    private final Flow<List<String>> evictedEntriesFlow;

    public UstadCacheTrimmer(@NotNull UstadCacheDb db, @NotNull FileSystem fileSystem, @Nullable UstadCacheLogger logger, @NotNull Function0<Long> sizeLimit) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(sizeLimit, (String)"sizeLimit");
        this.db = db;
        this.fileSystem = fileSystem;
        this.logger = logger;
        this.sizeLimit = sizeLimit;
        this.logPrefix = "CacheTrimmer: ";
        this._evictedEntriesFlow = SharedFlowKt.MutableSharedFlow((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST);
        this.evictedEntriesFlow = (Flow)FlowKt.asSharedFlow(this._evictedEntriesFlow);
    }

    public /* synthetic */ UstadCacheTrimmer(UstadCacheDb ustadCacheDb, FileSystem fileSystem, UstadCacheLogger ustadCacheLogger, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ustadCacheLogger = null;
        }
        this(ustadCacheDb, fileSystem, ustadCacheLogger, (Function0<Long>)function0);
    }

    @NotNull
    public final Flow<List<String>> getEvictedEntriesFlow() {
        return this.evictedEntriesFlow;
    }

    public final void trim() {
        long currentLimit = ((Number)this.sizeLimit.invoke()).longValue();
        if (currentLimit <= 0L) {
            throw new IllegalArgumentException("Size limit must be greater than 0");
        }
        UstadCacheLogger ustadCacheLogger = this.logger;
        if (ustadCacheLogger != null) {
            UstadCacheLogger.DefaultImpls.d$default(ustadCacheLogger, "UstadCache", this.logPrefix + " Trim cache run: max (evictable) size = " + currentLimit + " bytes", null, 4, null);
        }
        List pathsToDelete = new ArrayList();
        DoorDatabaseExtKt.withDoorTransaction$default((RoomDatabase)this.db, null, (Function1)((Function1)new Function1<UstadCacheDb, Unit>(this, currentLimit, (List<String>)pathsToDelete){
            final /* synthetic */ UstadCacheTrimmer this$0;
            final /* synthetic */ long $currentLimit;
            final /* synthetic */ List<String> $pathsToDelete;
            {
                this.this$0 = $receiver;
                this.$currentLimit = $currentLimit;
                this.$pathsToDelete = $pathsToDelete;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UstadCacheDb it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                long currentSize = 0L;
                while (true) {
                    Iterable $this$mapTo$iv$iv;
                    Object object;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv;
                    long l;
                    long it2 = l = UstadCacheTrimmer.access$getDb$p(this.this$0).getCacheEntryDao().totalEvictableSize();
                    boolean bl = false;
                    currentSize = it2;
                    if (l <= this.$currentLimit) break;
                    long deleteTarget = currentSize - this.$currentLimit;
                    List<CacheEntry> evictableEntries = UstadCacheTrimmer.access$getDb$p(this.this$0).getCacheEntryDao().findEvictableEntries(100);
                    List entriesToEvict = new ArrayList<E>();
                    long entriesToEvictSize = 0L;
                    for (CacheEntry entry : evictableEntries) {
                        ((Collection)entriesToEvict).add(entry);
                        if ((entriesToEvictSize += entry.getStorageSize()) < deleteTarget) continue;
                    }
                    Object object2 = evictableEntries;
                    Object object3 = UstadCacheTrimmer.access$get_evictedEntriesFlow$p(this.this$0);
                    boolean $i$f$map2 = false;
                    void var11_15 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv2) {
                        void it3;
                        CacheEntry cacheEntry = (CacheEntry)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        object.add(it3.getKey());
                    }
                    object3.tryEmit((Object)((List)destination$iv$iv));
                    UstadCacheTrimmer.access$getDb$p(this.this$0).getCacheEntryDao().delete(entriesToEvict);
                    UstadCacheLogger ustadCacheLogger = UstadCacheTrimmer.access$getLogger$p(this.this$0);
                    if (ustadCacheLogger != null) {
                        Collection<String> collection;
                        void $this$map$iv2;
                        Iterable $i$f$map2 = entriesToEvict;
                        String string = UstadCacheTrimmer.access$getLogPrefix$p(this.this$0);
                        object = "UstadCache";
                        object3 = ustadCacheLogger;
                        boolean $i$f$map3 = false;
                        destination$iv$iv = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it4;
                            CacheEntry bl2 = (CacheEntry)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl3 = false;
                            collection.add(it4.getUrl());
                        }
                        collection = (List)destination$iv$iv2;
                        UstadCacheLogger.DefaultImpls.v$default((UstadCacheLogger)object3, (String)object, string + " evicting " + (List)collection, null, 4, null);
                    }
                    object2 = this.$pathsToDelete;
                    Iterable $this$map$iv3 = entriesToEvict;
                    boolean $i$f$map4 = false;
                    $this$mapTo$iv$iv = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        CacheEntry it4 = (CacheEntry)item$iv$iv;
                        object3 = destination$iv$iv3;
                        boolean bl4 = false;
                        object3.add(it4.getStorageUri());
                    }
                    Iterable iterable = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)object2, (Iterable)iterable);
                }
            }
        }), (int)1, null);
        UstadCacheLogger ustadCacheLogger2 = this.logger;
        if (ustadCacheLogger2 != null) {
            UstadCacheLogger.DefaultImpls.v$default(ustadCacheLogger2, "UstadCache", this.logPrefix + " deleting " + CollectionsKt.joinToString$default((Iterable)pathsToDelete, null, null, null, (int)0, null, null, (int)63, null), null, 4, null);
        }
        Iterable $this$forEach$iv = pathsToDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSystem fileSystem;
            String pathToDelete = (String)element$iv;
            boolean bl = false;
            Path path = PathsJvmKt.Path((String)pathToDelete);
            FileSystem it = fileSystem = this.fileSystem;
            boolean bl2 = false;
            Object object = it.exists(path) ? fileSystem : null;
            if (object == null) continue;
            FileSystem.delete$default((FileSystem)object, (Path)path, (boolean)false, (int)2, null);
        }
    }

    public static final /* synthetic */ UstadCacheDb access$getDb$p(UstadCacheTrimmer $this) {
        return $this.db;
    }

    public static final /* synthetic */ MutableSharedFlow access$get_evictedEntriesFlow$p(UstadCacheTrimmer $this) {
        return $this._evictedEntriesFlow;
    }

    public static final /* synthetic */ UstadCacheLogger access$getLogger$p(UstadCacheTrimmer $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getLogPrefix$p(UstadCacheTrimmer $this) {
        return $this.logPrefix;
    }
}

