package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.ext.requirePagingSourceLoadParams
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.log.DoorLogLevel
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.paging.loadPageDataForHttp
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.ClazzLog
import kotlin.Int
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzLogDao.findByClazzUidAsFactory_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_excludeStatus : Int = request.queryParam("excludeStatus")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_findByClazzUidAsFactory_pagingSource = findByClazzUidAsFactory(
    clazzUid = _arg_clazzUid,
    excludeStatus = _arg_excludeStatus,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_findByClazzUidAsFactory = _result_findByClazzUidAsFactory_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_findByClazzUidAsFactory_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached = _result_findByClazzUidAsFactory_pagingSource.endOfPaginationReached

  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByClazzUidAsFactory.map {
        _row ->
        DoorReplicationEntity(tableId = 14,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzLog.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzLogDao.findByClazzUidAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_excludeStatus : Int = request.queryParam("excludeStatus")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _result_findByClazzUidAsync = findByClazzUidAsync(
    clazzUid = _arg_clazzUid,
    excludeStatus = _arg_excludeStatus,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByClazzUidAsync.map {
        _row ->
        DoorReplicationEntity(tableId = 14,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzLog.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzLogDao.findAllForClazzByClazzLogUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzLogUid : Long = request.queryParam("clazzLogUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_excludeStatus : Int = request.queryParam("excludeStatus")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _result_findAllForClazzByClazzLogUid = findAllForClazzByClazzLogUid(
    clazzLogUid = _arg_clazzLogUid,
    excludeStatus = _arg_excludeStatus,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllForClazzByClazzLogUid.map {
        _row ->
        DoorReplicationEntity(tableId = 14,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzLog.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
