package com.ustadmobile.core.db.dao

import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.ktor.KtorCallDaoAdapter
import com.ustadmobile.door.ktor.respondDoorJson
import com.ustadmobile.door.ktor.toDoorRequest
import io.ktor.server.application.call
import io.ktor.server.routing.Route
import io.ktor.server.routing.`get`
import kotlin.Suppress

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public fun Route.CourseGroupMemberDao_KtorRoute(serverConfig: DoorHttpServerConfig,
    daoCallAdapter: KtorCallDaoAdapter<CourseGroupMemberDao>) {
  `get`("findByCourseGroupSetAndClazz") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByCourseGroupSetAndClazz_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByCourseGroupSetAndClazzAsFlow") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByCourseGroupSetAndClazzAsFlow_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByCourseGroupSetAndGroupNumAsync") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByCourseGroupSetAndGroupNumAsync_DoorHttp(serverConfig,
          call.toDoorRequest(_daoAndDb.db))
    )
  }
}
