package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.ClazzEnrolment
import com.ustadmobile.lib.db.entities.CoursePermission
import com.ustadmobile.lib.db.entities.SystemPermission
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun SystemPermissionDao.findByPersonUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByPersonUidAsFlow = findByPersonUidAsFlow(
    accountPersonUid = _arg_accountPersonUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByPersonUidAsFlow?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun SystemPermissionDao.personHasSystemPermission_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_permission : Long = request.queryParam("permission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findAllByPersonUid = findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun SystemPermissionDao.personHasSystemPermissionAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_permission : Long = request.queryParam("permission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findAllByPersonUid = findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun SystemPermissionDao.personHasSystemPermissionPairAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_firstPermission : Long = request.queryParam("firstPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_secondPermission : Long = request.queryParam("secondPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findAllByPersonUid = findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun SystemPermissionDao.personHasSystemPermissionPair_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_firstPermission : Long = request.queryParam("firstPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_secondPermission : Long = request.queryParam("secondPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findAllByPersonUid = findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun SystemPermissionDao.personHasEditAndViewPermissionForPersonAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_otherPersonUid : Long = request.queryParam("otherPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findApplicableCoursePermissionEntitiesForAccountPerson =
      request.db.doorWrapper.getDaoByClass(CoursePermissionDao::class).findApplicableCoursePermissionEntitiesForAccountPerson(
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findClazzEnrolmentEntitiesForPersonViewPermissionCheck =
      request.db.doorWrapper.getDaoByClass(ClazzEnrolmentDao::class).findClazzEnrolmentEntitiesForPersonViewPermissionCheck(
    accountPersonUid = _arg_accountPersonUid,
    otherPersonUid = _arg_otherPersonUid,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findApplicableCoursePermissionEntitiesForAccountPerson.map {
        _row ->
        DoorReplicationEntity(tableId = 10_012,
          orUid = 0,
          entity = json.encodeToJsonElement(CoursePermission.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findClazzEnrolmentEntitiesForPersonViewPermissionCheck.map {
        _row ->
        DoorReplicationEntity(tableId = 65,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
