package com.ustadmobile.core.db.dao.xapi

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.xapi.ActorEntity
import com.ustadmobile.lib.db.entities.xapi.XapiSessionEntity
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun XapiSessionEntityDao.findMostRecentSessionByActorAndActivity_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_actorUid : Long = request.queryParam("actorUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_xseRootActivityUid : Long = request.queryParam("xseRootActivityUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_contentEntryVersionUid : Long = request.queryParam("contentEntryVersionUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findMostRecentSessionByActorAndActivity = findMostRecentSessionByActorAndActivity(
    accountPersonUid = _arg_accountPersonUid,
    actorUid = _arg_actorUid,
    xseRootActivityUid = _arg_xseRootActivityUid,
    contentEntryVersionUid = _arg_contentEntryVersionUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findByUidAndPersonUidAsync =
      request.db.doorWrapper.getDaoByClass(ActorDao::class).findByUidAndPersonUidAsync(
    actorUid = _arg_actorUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findMostRecentSessionByActorAndActivity?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 400_122,
          orUid = 0,
          entity = json.encodeToJsonElement(XapiSessionEntity.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findByUidAndPersonUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 68,
          orUid = 0,
          entity = json.encodeToJsonElement(ActorEntity.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
