package com.ustadmobile.core.db.dao

import com.ustadmobile.core.db.dao.xapi.StatementDao
import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.ext.requirePagingSourceLoadParams
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.log.DoorLogLevel
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.paging.loadPageDataForHttp
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.ClazzAssignment
import com.ustadmobile.lib.db.entities.ContentEntry
import com.ustadmobile.lib.db.entities.ContentEntryPicture2
import com.ustadmobile.lib.db.entities.CourseBlock
import com.ustadmobile.lib.db.entities.CourseBlockPicture
import com.ustadmobile.lib.db.entities.Language
import com.ustadmobile.lib.db.entities.xapi.StatementEntity
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun CourseBlockDao.findByUidAsyncAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_uid : Long = request.queryParam("uid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAsyncAsFlow = findByUidAsyncAsFlow(
    uid = _arg_uid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAsyncAsFlow?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 124,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlock.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseBlockDao.findByUidWithPictureAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_uid : Long = request.queryParam("uid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidWithPictureAsFlow = findByUidWithPictureAsFlow(
    uid = _arg_uid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidWithPictureAsFlow?.block?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 124,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlock.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findByUidWithPictureAsFlow?.picture?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6_677,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlockPicture.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseBlockDao.findAllCourseBlockByClazzUidAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeInactive : Boolean = request.queryParam("includeInactive")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _result_findAllCourseBlockByClazzUidAsync = findAllCourseBlockByClazzUidAsync(
    clazzUid = _arg_clazzUid,
    includeInactive = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllCourseBlockByClazzUidAsync.mapNotNull {
        _row ->
        _row.courseBlock?.let {
          DoorReplicationEntity(tableId = 124,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseBlock.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsync.mapNotNull {
        _row ->
        _row.courseBlockPicture?.let {
          DoorReplicationEntity(tableId = 6_677,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseBlockPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsync.mapNotNull {
        _row ->
        _row.contentEntry?.let {
          DoorReplicationEntity(tableId = 42,
            orUid = 0,
            entity = json.encodeToJsonElement(ContentEntry.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsync.mapNotNull {
        _row ->
        _row.contentEntryLang?.let {
          DoorReplicationEntity(tableId = 13,
            orUid = 0,
            entity = json.encodeToJsonElement(Language.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsync.mapNotNull {
        _row ->
        _row.assignment?.let {
          DoorReplicationEntity(tableId = 520,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzAssignment.serializer(), it).jsonObject,
          )
        }

      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseBlockDao.findAllCourseBlockByClazzUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeInactive : Boolean = request.queryParam("includeInactive")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _arg_includeHidden : Boolean = request.queryParam("includeHidden")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _arg_hideUntilFilterTime : Long = request.queryParam("hideUntilFilterTime")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findAllCourseBlockByClazzUidAsFlow = findAllCourseBlockByClazzUidAsFlow(
    clazzUid = _arg_clazzUid,
    includeInactive = true,
    includeHidden = true,
    hideUntilFilterTime = 7258204800000L,
    accountPersonUid = _arg_accountPersonUid,
  ).first()
  val _result_findStatusStatementsForStudentByClazzUid =
      request.db.doorWrapper.getDaoByClass(StatementDao::class).findStatusStatementsForStudentByClazzUid(
    clazzUid = _arg_clazzUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllCourseBlockByClazzUidAsFlow.mapNotNull {
        _row ->
        _row.courseBlock?.let {
          DoorReplicationEntity(tableId = 124,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseBlock.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsFlow.mapNotNull {
        _row ->
        _row.courseBlockPicture?.let {
          DoorReplicationEntity(tableId = 6_677,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseBlockPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsFlow.mapNotNull {
        _row ->
        _row.contentEntry?.let {
          DoorReplicationEntity(tableId = 42,
            orUid = 0,
            entity = json.encodeToJsonElement(ContentEntry.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsFlow.mapNotNull {
        _row ->
        _row.contentEntryPicture2?.let {
          DoorReplicationEntity(tableId = 6_678,
            orUid = 0,
            entity = json.encodeToJsonElement(ContentEntryPicture2.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findStatusStatementsForStudentByClazzUid.map {
        _row ->
        DoorReplicationEntity(tableId = 60,
          orUid = 0,
          entity = json.encodeToJsonElement(StatementEntity.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseBlockDao.findAllCourseBlockByClazzUidAsPagingSource_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_collapseList : List<Long> = request.queryParam("collapseList")?.let {
    json.decodeFromString(ListSerializer(Long.serializer()), it)
  } ?: mutableListOf()
  val _arg_includeInactive : Boolean = request.queryParam("includeInactive")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _arg_includeHidden : Boolean = request.queryParam("includeHidden")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _arg_hideUntilFilterTime : Long = request.queryParam("hideUntilFilterTime")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_findAllCourseBlockByClazzUidAsPagingSource_pagingSource =
      findAllCourseBlockByClazzUidAsPagingSource(
    clazzUid = _arg_clazzUid,
    collapseList = _arg_collapseList,
    includeInactive = true,
    includeHidden = true,
    hideUntilFilterTime = 7258204800000L,
    accountPersonUid = _arg_accountPersonUid,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_findAllCourseBlockByClazzUidAsPagingSource =
      _result_findAllCourseBlockByClazzUidAsPagingSource_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_findAllCourseBlockByClazzUidAsPagingSource_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_findAllCourseBlockByClazzUidAsPagingSource_pagingSource.endOfPaginationReached

  val _result_findStatusStatementsForStudentByClazzUid =
      request.db.doorWrapper.getDaoByClass(StatementDao::class).findStatusStatementsForStudentByClazzUid(
    clazzUid = _arg_clazzUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllCourseBlockByClazzUidAsPagingSource.mapNotNull {
        _row ->
        _row.courseBlock?.let {
          DoorReplicationEntity(tableId = 124,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseBlock.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsPagingSource.mapNotNull {
        _row ->
        _row.courseBlockPicture?.let {
          DoorReplicationEntity(tableId = 6_677,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseBlockPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsPagingSource.mapNotNull {
        _row ->
        _row.contentEntry?.let {
          DoorReplicationEntity(tableId = 42,
            orUid = 0,
            entity = json.encodeToJsonElement(ContentEntry.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllCourseBlockByClazzUidAsPagingSource.mapNotNull {
        _row ->
        _row.contentEntryPicture2?.let {
          DoorReplicationEntity(tableId = 6_678,
            orUid = 0,
            entity = json.encodeToJsonElement(ContentEntryPicture2.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findStatusStatementsForStudentByClazzUid.map {
        _row ->
        DoorReplicationEntity(tableId = 60,
          orUid = 0,
          entity = json.encodeToJsonElement(StatementEntity.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun CourseBlockDao.findByUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_courseBlockUid : Long = request.queryParam("courseBlockUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAsFlow = findByUidAsFlow(
    courseBlockUid = _arg_courseBlockUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAsFlow?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 124,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlock.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseBlockDao.findCourseBlockAndClazzUidByDiscussionPostUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_postUid : Long = request.queryParam("postUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findCourseBlockByDiscussionPostUid = findCourseBlockByDiscussionPostUid(
    postUid = _arg_postUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findCourseBlockByDiscussionPostUid?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 124,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlock.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseBlockDao.findCourseBlockByAssignmentUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findCourseBlockByAssignmentUid = findCourseBlockByAssignmentUid(
    assignmentUid = _arg_assignmentUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findCourseBlockByAssignmentUid?.courseBlock?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 124,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlock.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findCourseBlockByAssignmentUid?.assignment?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 520,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzAssignment.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun CourseBlockDao.findBySourcedId_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_sourcedId : String = request.queryParam("sourcedId")?.let {
    json.decodeFromString(String.serializer(), it)
  } ?: ""
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findBySourcedId = findBySourcedId(
    sourcedId = _arg_sourcedId,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findBySourcedId?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 124,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlock.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun CourseBlockDao.findByClazzUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByClazzUidAsFlow = findByClazzUidAsFlow(
    clazzUid = _arg_clazzUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByClazzUidAsFlow.mapNotNull {
        _row ->
        _row.block?.let {
          DoorReplicationEntity(tableId = 124,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseBlock.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByClazzUidAsFlow.mapNotNull {
        _row ->
        _row.courseBlockPicture?.let {
          DoorReplicationEntity(tableId = 6_677,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseBlockPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByClazzUidAsFlow.mapNotNull {
        _row ->
        _row.contentEntry?.let {
          DoorReplicationEntity(tableId = 42,
            orUid = 0,
            entity = json.encodeToJsonElement(ContentEntry.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByClazzUidAsFlow.mapNotNull {
        _row ->
        _row.contentEntryPicture2?.let {
          DoorReplicationEntity(tableId = 6_678,
            orUid = 0,
            entity = json.encodeToJsonElement(ContentEntryPicture2.serializer(), it).jsonObject,
          )
        }

      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
