package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.HolidayCalendar
import com.ustadmobile.lib.db.entities.HolidayCalendarWithNumEntries
import kotlin.Int
import kotlin.Long
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public class HolidayCalendarDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: HolidayCalendarDao,
) : HolidayCalendarDao() {
  override fun findAllHolidaysWithEntriesCount(): PagingSource<Int, HolidayCalendarWithNumEntries> =
      _dao.findAllHolidaysWithEntriesCount()

  override fun replaceList(list: List<HolidayCalendar>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    list.iterator().forEach  {
      if(it.umCalendarUid == 0L) {
        val _newPk = _pkManager.nextId(28)
        it.umCalendarUid = _newPk
        _generatedPks += _newPk
      }
      it.umCalendarLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.replaceList(list)
  }

  override fun findAllHolidaysLiveData(): Flow<List<HolidayCalendar>> =
      _dao.findAllHolidaysLiveData()

  override fun findByUidLive(uid: Long): Flow<HolidayCalendar?> = _dao.findByUidLive(uid)

  override suspend fun updateAsync(entity: HolidayCalendar): Int {
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    return _dao.updateAsync(entity)
  }

  override suspend fun findByUid(uid: Long): HolidayCalendar? = _dao.findByUid(uid)

  override suspend fun findByUidAsync(uid: Long): HolidayCalendar? = _dao.findByUidAsync(uid)

  public override fun insert(entity: HolidayCalendar): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.umCalendarUid == 0L) {
      val _newPk = _pkManager.nextId(28)
      entity.umCalendarUid = _newPk
    }
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.umCalendarUid
  }

  public override suspend fun insertAsync(entity: HolidayCalendar): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.umCalendarUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(28)
      entity.umCalendarUid = _newPk
    }
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.umCalendarUid
  }

  public override fun insertList(entityList: List<HolidayCalendar>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.umCalendarUid == 0L) {
        val _newPk = _pkManager.nextId(28)
        it.umCalendarUid = _newPk
        _generatedPks += _newPk
      }
      it.umCalendarLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun update(entity: HolidayCalendar) {
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
