/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.io;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ProcessUtils {
    private ProcessUtils() {
        throw new AssertionError((Object)"No instances for you!");
    }

    public static int waitForWithTimeout(Process p, long timeout, TimeUnit unit) throws TimeoutException {
        ProcessThread t = new ProcessThread(p);
        t.start();
        try {
            unit.timedJoin(t, timeout);
        }
        catch (InterruptedException e) {
            t.interrupt();
            Thread.currentThread().interrupt();
        }
        if (!t.hasFinished()) {
            throw new TimeoutException("Process did not finish within timeout");
        }
        return t.exitValue();
    }

    private static class ProcessThread
    extends Thread {
        final Process p;
        boolean finished = false;
        int exitValue = -1;

        private ProcessThread(Process p) {
            this.p = p;
        }

        @Override
        public void run() {
            try {
                this.exitValue = this.p.waitFor();
                this.finished = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public boolean hasFinished() {
            return this.finished;
        }

        public int exitValue() {
            return this.exitValue;
        }
    }
}

