/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentPool;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import kotlinx.io.internal._Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0002\u001a$\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\f\u001a\u00020\b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0004\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u000f\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0006*\u00020\u000fH\u0000\u001a \u0010\u0014\u001a\u00020\u0004*\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0006H\u0000\u001a&\u0010\u0016\u001a\u00020\b*\u00020\u00172\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u001a\u0014\u0010\u0018\u001a\u00020\b*\u00020\u00172\u0006\u0010\r\u001a\u00020\u0006H\u0000\u00a8\u0006\u0019"}, d2={"commonReadUtf8", "", "Lkotlinx/io/Buffer;", "byteCount", "", "commonReadUtf8CodePoint", "", "commonWriteUtf8", "", "string", "beginIndex", "endIndex", "commonWriteUtf8CodePoint", "codePoint", "readLine", "Lkotlinx/io/Source;", "readLineStrict", "limit", "readString", "readUtf8CodePoint", "utf8Size", "startIndex", "writeString", "Lkotlinx/io/Sink;", "writeUtf8CodePoint", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nUtf8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utf8.kt\nkotlinx/io/Utf8Kt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 Sinks.kt\nkotlinx/io/SinksKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,562:1\n38#2:563\n97#2:571\n97#2:572\n97#2:573\n97#2:574\n97#2:575\n97#2:576\n97#2:577\n97#2:578\n97#2:579\n97#2:580\n38#2:581\n366#3,3:564\n366#3,3:567\n1#4:570\n*S KotlinDebug\n*F\n+ 1 Utf8.kt\nkotlinx/io/Utf8Kt\n*L\n86#1:563\n335#1:571\n337#1:572\n342#1:573\n344#1:574\n349#1:575\n351#1:576\n356#1:577\n358#1:578\n379#1:579\n382#1:580\n409#1:581\n133#1:564,3\n150#1:567,3\n*E\n"})
public final class Utf8Kt {
    public static final long utf8Size(@NotNull String $this$utf8Size, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$utf8Size, (String)"<this>");
        int size$iv = $this$utf8Size.length();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        long result = 0L;
        int i = startIndex;
        while (i < endIndex) {
            char low;
            char c = $this$utf8Size.charAt(i);
            if (c < '\u0080') {
                long l = result;
                result = l + 1L;
                ++i;
                continue;
            }
            if (c < '\u0800') {
                result += (long)2;
                ++i;
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                result += (long)3;
                ++i;
                continue;
            }
            char c2 = low = i + 1 < endIndex ? $this$utf8Size.charAt(i + 1) : (char)'\u0000';
            if (c > '\udbff' || low < '\udc00' || low > '\udfff') {
                long l = result;
                result = l + 1L;
                ++i;
                continue;
            }
            result += (long)4;
            i += 2;
        }
        return result;
    }

    public static /* synthetic */ long utf8Size$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return Utf8Kt.utf8Size(string, n, n2);
    }

    public static final void writeUtf8CodePoint(@NotNull Sink $this$writeUtf8CodePoint, int codePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUtf8CodePoint, (String)"<this>");
        Sink $this$writeToInternalBuffer$iv = $this$writeUtf8CodePoint;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer it = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        Utf8Kt.commonWriteUtf8CodePoint(it, codePoint);
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static final void writeString(@NotNull Sink $this$writeString, @NotNull String string, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Sink $this$writeToInternalBuffer$iv = $this$writeString;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer it = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        Utf8Kt.commonWriteUtf8(it, string, startIndex, endIndex);
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static /* synthetic */ void writeString$default(Sink sink, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        Utf8Kt.writeString(sink, string, n, n2);
    }

    @NotNull
    public static final String readString(@NotNull Source $this$readString) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        long req = 8192L;
        while ($this$readString.request(req)) {
            req *= (long)2;
        }
        return Utf8Kt.commonReadUtf8($this$readString.getBuffer(), $this$readString.getBuffer().getSize());
    }

    @NotNull
    public static final String readString(@NotNull Buffer $this$readString) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        return Utf8Kt.commonReadUtf8($this$readString, $this$readString.getSize());
    }

    @NotNull
    public static final String readString(@NotNull Source $this$readString, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        $this$readString.require(byteCount);
        return Utf8Kt.commonReadUtf8($this$readString.getBuffer(), byteCount);
    }

    public static final int readUtf8CodePoint(@NotNull Source $this$readUtf8CodePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$readUtf8CodePoint, (String)"<this>");
        $this$readUtf8CodePoint.require(1L);
        byte b0 = $this$readUtf8CodePoint.getBuffer().get(0L);
        if ((b0 & 0xE0) == 192) {
            $this$readUtf8CodePoint.require(2L);
        } else if ((b0 & 0xF0) == 224) {
            $this$readUtf8CodePoint.require(3L);
        } else if ((b0 & 0xF8) == 240) {
            $this$readUtf8CodePoint.require(4L);
        }
        return Utf8Kt.commonReadUtf8CodePoint($this$readUtf8CodePoint.getBuffer());
    }

    public static final int readUtf8CodePoint(@NotNull Buffer $this$readUtf8CodePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$readUtf8CodePoint, (String)"<this>");
        return Utf8Kt.commonReadUtf8CodePoint($this$readUtf8CodePoint);
    }

    @Nullable
    public static final String readLine(@NotNull Source $this$readLine) {
        Intrinsics.checkNotNullParameter((Object)$this$readLine, (String)"<this>");
        if (!$this$readLine.request(1L)) {
            return null;
        }
        Source peekSource = $this$readLine.peek();
        long offset = 0L;
        long newlineSize = 0L;
        block4: while (peekSource.request(1L)) {
            byte b = peekSource.readByte();
            switch (b) {
                case 10: {
                    newlineSize = 1L;
                    break block4;
                }
                case 13: {
                    if (SourcesKt.startsWith(peekSource, (byte)10)) {
                        newlineSize = 2L;
                        break block4;
                    }
                }
                default: {
                    long l = offset;
                    offset = l + 1L;
                    continue block4;
                }
            }
        }
        String line = Utf8Kt.readString($this$readLine, offset);
        $this$readLine.skip(newlineSize);
        return line;
    }

    @NotNull
    public static final String readLineStrict(@NotNull Source $this$readLineStrict, long limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readLineStrict, (String)"<this>");
        if (!(limit >= 0L)) {
            boolean $i$a$-require-Utf8Kt$readLineStrict$22 = false;
            String $i$a$-require-Utf8Kt$readLineStrict$22 = "limit (" + limit + ") < 0";
            throw new IllegalArgumentException($i$a$-require-Utf8Kt$readLineStrict$22.toString());
        }
        $this$readLineStrict.require(1L);
        Source peekSource = $this$readLineStrict.peek();
        long offset = 0L;
        long newlineSize = 0L;
        block4: while (offset < limit && peekSource.request(1L)) {
            byte b = peekSource.readByte();
            switch (b) {
                case 10: {
                    newlineSize = 1L;
                    break block4;
                }
                case 13: {
                    if (SourcesKt.startsWith(peekSource, (byte)10)) {
                        newlineSize = 2L;
                        break block4;
                    }
                }
                default: {
                    long l = offset;
                    offset = l + 1L;
                    continue block4;
                }
            }
        }
        if (offset == limit) {
            if (!peekSource.request(1L)) {
                throw new EOFException();
            }
            byte nlCandidate = peekSource.readByte();
            if (nlCandidate == 10) {
                newlineSize = 1L;
            } else if (nlCandidate == 13 && SourcesKt.startsWith(peekSource, (byte)10)) {
                newlineSize = 2L;
            }
        }
        if (newlineSize == 0L) {
            throw new EOFException();
        }
        String line = Utf8Kt.readString($this$readLineStrict, offset);
        $this$readLineStrict.skip(newlineSize);
        return line;
    }

    public static /* synthetic */ String readLineStrict$default(Source source, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = Long.MAX_VALUE;
        }
        return Utf8Kt.readLineStrict(source, l);
    }

    private static final int commonReadUtf8CodePoint(Buffer $this$commonReadUtf8CodePoint) {
        byte $this$and$iv;
        $this$commonReadUtf8CodePoint.require(1L);
        byte b0 = $this$commonReadUtf8CodePoint.get(0L);
        int codePoint = 0;
        int byteCount = 0;
        int min = 0;
        byte by = b0;
        int other$iv = 128;
        byte $i$f$and = 0;
        if (($this$and$iv & other$iv) == 0) {
            $this$and$iv = b0;
            other$iv = 127;
            $i$f$and = 0;
            codePoint = $this$and$iv & other$iv;
            byteCount = 1;
            min = 0;
        } else {
            $this$and$iv = b0;
            other$iv = 224;
            $i$f$and = 0;
            if (($this$and$iv & other$iv) == 192) {
                $this$and$iv = b0;
                other$iv = 31;
                $i$f$and = 0;
                codePoint = $this$and$iv & other$iv;
                byteCount = 2;
                min = 128;
            } else {
                $this$and$iv = b0;
                other$iv = 240;
                $i$f$and = 0;
                if (($this$and$iv & other$iv) == 224) {
                    $this$and$iv = b0;
                    other$iv = 15;
                    $i$f$and = 0;
                    codePoint = $this$and$iv & other$iv;
                    byteCount = 3;
                    min = 2048;
                } else {
                    $this$and$iv = b0;
                    other$iv = 248;
                    $i$f$and = 0;
                    if (($this$and$iv & other$iv) == 240) {
                        $this$and$iv = b0;
                        other$iv = 7;
                        $i$f$and = 0;
                        codePoint = $this$and$iv & other$iv;
                        byteCount = 4;
                        min = 65536;
                    } else {
                        $this$commonReadUtf8CodePoint.skip(1L);
                        return 65533;
                    }
                }
            }
        }
        if ($this$commonReadUtf8CodePoint.getSize() < (long)byteCount) {
            throw new EOFException("size < " + byteCount + ": " + $this$commonReadUtf8CodePoint.getSize() + " (to read code point prefixed 0x" + _UtilKt.toHexString(b0) + ')');
        }
        for (int i = 1; i < byteCount; ++i) {
            byte $this$and$iv2;
            byte b;
            $i$f$and = b = $this$commonReadUtf8CodePoint.get(i);
            int other$iv2 = 192;
            boolean $i$f$and2 = false;
            if (($this$and$iv2 & other$iv2) == 128) {
                codePoint <<= 6;
                $this$and$iv2 = b;
                other$iv2 = 63;
                $i$f$and2 = false;
                codePoint |= $this$and$iv2 & other$iv2;
                continue;
            }
            $this$commonReadUtf8CodePoint.skip(i);
            return 65533;
        }
        $this$commonReadUtf8CodePoint.skip(byteCount);
        return codePoint > 0x10FFFF ? 65533 : ((55296 <= codePoint ? codePoint < 57344 : false) ? 65533 : (codePoint < min ? 65533 : codePoint));
    }

    private static final void commonWriteUtf8(Buffer $this$commonWriteUtf8, String string, int beginIndex, int endIndex) {
        int size$iv = string.length();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)beginIndex, (long)endIndex);
        int i = beginIndex;
        while (i < endIndex) {
            char low;
            char c;
            block9: {
                block8: {
                    c = string.charAt(i);
                    if (c < '\u0080') {
                        Segment tail = $this$commonWriteUtf8.writableSegment$kotlinx_io_core(1);
                        byte[] data = tail.data;
                        int segmentOffset = tail.limit - i;
                        int runLimit = Math.min(endIndex, 8192 - segmentOffset);
                        data[segmentOffset + i++] = (byte)c;
                        while (i < runLimit && (c = string.charAt(i)) < '\u0080') {
                            data[segmentOffset + i++] = (byte)c;
                        }
                        int runSize = i + segmentOffset - tail.limit;
                        tail.limit += runSize;
                        $this$commonWriteUtf8.setSize$kotlinx_io_core($this$commonWriteUtf8.getSize() + (long)runSize);
                        continue;
                    }
                    if (c < '\u0800') {
                        Segment tail = $this$commonWriteUtf8.writableSegment$kotlinx_io_core(2);
                        tail.data[tail.limit] = (byte)(c >> 6 | 0xC0);
                        tail.data[tail.limit + 1] = (byte)(c & 0x3F | 0x80);
                        tail.limit += 2;
                        $this$commonWriteUtf8.setSize$kotlinx_io_core($this$commonWriteUtf8.getSize() + 2L);
                        ++i;
                        continue;
                    }
                    if (c < '\ud800' || c > '\udfff') {
                        Segment tail = $this$commonWriteUtf8.writableSegment$kotlinx_io_core(3);
                        tail.data[tail.limit] = (byte)(c >> 12 | 0xE0);
                        tail.data[tail.limit + 1] = (byte)(c >> 6 & 0x3F | 0x80);
                        tail.data[tail.limit + 2] = (byte)(c & 0x3F | 0x80);
                        tail.limit += 3;
                        $this$commonWriteUtf8.setSize$kotlinx_io_core($this$commonWriteUtf8.getSize() + 3L);
                        ++i;
                        continue;
                    }
                    char c2 = low = i + 1 < endIndex ? string.charAt(i + 1) : (char)'\u0000';
                    if (c > '\udbff') break block8;
                    if ('\udc00' <= low ? low < '\ue000' : false) break block9;
                }
                $this$commonWriteUtf8.writeByte((byte)63);
                ++i;
                continue;
            }
            int codePoint = 65536 + ((c & 0x3FF) << 10 | low & 0x3FF);
            Segment tail = $this$commonWriteUtf8.writableSegment$kotlinx_io_core(4);
            tail.data[tail.limit] = (byte)(codePoint >> 18 | 0xF0);
            tail.data[tail.limit + 1] = (byte)(codePoint >> 12 & 0x3F | 0x80);
            tail.data[tail.limit + 2] = (byte)(codePoint >> 6 & 0x3F | 0x80);
            tail.data[tail.limit + 3] = (byte)(codePoint & 0x3F | 0x80);
            tail.limit += 4;
            $this$commonWriteUtf8.setSize$kotlinx_io_core($this$commonWriteUtf8.getSize() + 4L);
            i += 2;
        }
    }

    private static final void commonWriteUtf8CodePoint(Buffer $this$commonWriteUtf8CodePoint, int codePoint) {
        if (codePoint < 128) {
            $this$commonWriteUtf8CodePoint.writeByte((byte)codePoint);
        } else if (codePoint < 2048) {
            Segment tail = $this$commonWriteUtf8CodePoint.writableSegment$kotlinx_io_core(2);
            tail.data[tail.limit] = (byte)(codePoint >> 6 | 0xC0);
            tail.data[tail.limit + 1] = (byte)(codePoint & 0x3F | 0x80);
            tail.limit += 2;
            $this$commonWriteUtf8CodePoint.setSize$kotlinx_io_core($this$commonWriteUtf8CodePoint.getSize() + 2L);
        } else {
            boolean bl = 55296 <= codePoint ? codePoint < 57344 : false;
            if (bl) {
                $this$commonWriteUtf8CodePoint.writeByte((byte)63);
            } else if (codePoint < 65536) {
                Segment tail = $this$commonWriteUtf8CodePoint.writableSegment$kotlinx_io_core(3);
                tail.data[tail.limit] = (byte)(codePoint >> 12 | 0xE0);
                tail.data[tail.limit + 1] = (byte)(codePoint >> 6 & 0x3F | 0x80);
                tail.data[tail.limit + 2] = (byte)(codePoint & 0x3F | 0x80);
                tail.limit += 3;
                $this$commonWriteUtf8CodePoint.setSize$kotlinx_io_core($this$commonWriteUtf8CodePoint.getSize() + 3L);
            } else if (codePoint <= 0x10FFFF) {
                Segment tail = $this$commonWriteUtf8CodePoint.writableSegment$kotlinx_io_core(4);
                tail.data[tail.limit] = (byte)(codePoint >> 18 | 0xF0);
                tail.data[tail.limit + 1] = (byte)(codePoint >> 12 & 0x3F | 0x80);
                tail.data[tail.limit + 2] = (byte)(codePoint >> 6 & 0x3F | 0x80);
                tail.data[tail.limit + 3] = (byte)(codePoint & 0x3F | 0x80);
                tail.limit += 4;
                $this$commonWriteUtf8CodePoint.setSize$kotlinx_io_core($this$commonWriteUtf8CodePoint.getSize() + 4L);
            } else {
                throw new IllegalArgumentException("Unexpected code point: 0x" + _UtilKt.toHexString(codePoint));
            }
        }
    }

    private static final String commonReadUtf8(Buffer $this$commonReadUtf8, long byteCount) {
        if (!(byteCount >= 0L && byteCount <= Integer.MAX_VALUE)) {
            boolean $i$a$-require-Utf8Kt$commonReadUtf8$22 = false;
            String $i$a$-require-Utf8Kt$commonReadUtf8$22 = "byteCount (" + byteCount + ") is not within the range [0..2147483647)";
            throw new IllegalArgumentException($i$a$-require-Utf8Kt$commonReadUtf8$22.toString());
        }
        $this$commonReadUtf8.require(byteCount);
        if (byteCount == 0L) {
            return "";
        }
        Segment segment = $this$commonReadUtf8.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        if ((long)s.pos + byteCount > (long)s.limit) {
            return _Utf8Kt.commonToUtf8String$default(SourcesKt.readByteArray($this$commonReadUtf8, (int)byteCount), 0, 0, 3, null);
        }
        String result = _Utf8Kt.commonToUtf8String(s.data, s.pos, s.pos + (int)byteCount);
        s.pos += (int)byteCount;
        $this$commonReadUtf8.setSize$kotlinx_io_core($this$commonReadUtf8.getSize() - byteCount);
        if (s.pos == s.limit) {
            $this$commonReadUtf8.head = s.pop();
            SegmentPool.recycle(s);
        }
        return result;
    }
}

