/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.files;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Mover;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.io.files.SystemFileSystemImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007*\n\u0010\n\"\u00020\u000b2\u00020\u000b\u00a8\u0006\f"}, d2={"SystemFileSystem", "Lkotlinx/io/files/FileSystem;", "SystemTemporaryDirectory", "Lkotlinx/io/files/Path;", "mover", "Lkotlinx/io/files/Mover;", "getMover", "()Lkotlinx/io/files/Mover;", "mover$delegate", "Lkotlin/Lazy;", "FileNotFoundException", "Ljava/io/FileNotFoundException;", "kotlinx-io-core"})
public final class FileSystemJvmKt {
    @NotNull
    private static final Lazy mover$delegate = LazyKt.lazy((Function0)mover.2.INSTANCE);
    @JvmField
    @NotNull
    public static final FileSystem SystemFileSystem = new SystemFileSystemImpl(){

        public boolean exists(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return path.getFile$kotlinx_io_core().exists();
        }

        public void delete(@NotNull Path path, boolean mustExist) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!this.exists(path)) {
                if (mustExist) {
                    throw new FileNotFoundException("File does not exist: " + path.getFile$kotlinx_io_core());
                }
                return;
            }
            if (!path.getFile$kotlinx_io_core().delete()) {
                throw new IOException("Deletion failed");
            }
        }

        public void createDirectories(@NotNull Path path, boolean mustCreate) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!path.getFile$kotlinx_io_core().mkdirs()) {
                if (mustCreate) {
                    throw new IOException("Path already exist: " + path);
                }
                if (path.getFile$kotlinx_io_core().isFile()) {
                    throw new IOException("Path already exists and it's a file: " + path);
                }
            }
        }

        public void atomicMove(@NotNull Path source, @NotNull Path destination) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            FileSystemJvmKt.access$getMover().move(source, destination);
        }

        @Nullable
        public FileMetadata metadataOrNull(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!path.getFile$kotlinx_io_core().exists()) {
                return null;
            }
            return new FileMetadata(path.getFile$kotlinx_io_core().isFile(), path.getFile$kotlinx_io_core().isDirectory(), path.getFile$kotlinx_io_core().isFile() ? path.getFile$kotlinx_io_core().length() : -1L);
        }

        @NotNull
        public RawSource source(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return JvmCoreKt.asSource(new FileInputStream(path.getFile$kotlinx_io_core()));
        }

        @NotNull
        public RawSink sink(@NotNull Path path, boolean append) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return JvmCoreKt.asSink(new FileOutputStream(path.getFile$kotlinx_io_core(), append));
        }
    };
    @JvmField
    @NotNull
    public static final Path SystemTemporaryDirectory;

    private static final Mover getMover() {
        Lazy lazy = mover$delegate;
        return (Mover)lazy.getValue();
    }

    public static final /* synthetic */ Mover access$getMover() {
        return FileSystemJvmKt.getMover();
    }

    static {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        SystemTemporaryDirectory = PathsJvmKt.Path(string);
    }
}

