/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.modelmapper.internal.util.ArrayIterator;
import org.modelmapper.internal.util.Assert;

public final class Iterables {
    private Iterables() {
    }

    public static boolean isIterable(Class<?> type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    public static int getLength(Object iterable) {
        Assert.state(Iterables.isIterable(iterable.getClass()));
        return iterable.getClass().isArray() ? Array.getLength(iterable) : ((Collection)iterable).size();
    }

    public static Iterator<Object> iterator(Object iterable) {
        Assert.state(Iterables.isIterable(iterable.getClass()));
        return iterable.getClass().isArray() ? new ArrayIterator(iterable) : ((Iterable)iterable).iterator();
    }

    public static Object getElement(Object iterable, int index) {
        if (iterable.getClass().isArray()) {
            return Iterables.getElementFromArrary(iterable, index);
        }
        if (iterable instanceof Collection) {
            return Iterables.getElementFromCollection((Collection)iterable, index);
        }
        return null;
    }

    public static Object getElementFromArrary(Object array, int index) {
        try {
            return Array.get(array, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static Object getElementFromCollection(Collection<Object> collection, int index) {
        if (collection.size() < index + 1) {
            return null;
        }
        if (collection instanceof List) {
            return ((List)collection).get(index);
        }
        Iterator<Object> iterator = collection.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public static Iterable<Object> subIterable(Object iterable, int fromIndex) {
        if (iterable == null || Iterables.getLength(iterable) < fromIndex) {
            return Collections.emptyList();
        }
        final Iterator<Object> iterator = Iterables.iterator(iterable);
        for (int i = 0; i < fromIndex; ++i) {
            iterator.next();
        }
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return iterator;
            }
        };
    }
}

