/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.rest.domain.systemconfig.sysconfiginit;

import com.ustadmobile.centralappconfigdb.db.SystemConfigAuth;
import com.ustadmobile.centralappconfigdb.db.SystemConfigAuthQueries;
import com.ustadmobile.centralappconfigdb.sqlite.CentralAppConfigDb;
import com.ustadmobile.core.domain.pbkdf2.Pbkdf2EncryptUseCase;
import com.ustadmobile.core.util.ext.ByteArrayExtActualKt;
import com.ustadmobile.lib.util.RandomStringKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/lib/rest/domain/systemconfig/sysconfiginit/GenerateSystemConfigAuthUseCase;", "", "encryptor", "Lcom/ustadmobile/core/domain/pbkdf2/Pbkdf2EncryptUseCase;", "dataDirPath", "Ljava/io/File;", "(Lcom/ustadmobile/core/domain/pbkdf2/Pbkdf2EncryptUseCase;Ljava/io/File;)V", "invoke", "", "centralAppConfigDb", "Lcom/ustadmobile/centralappconfigdb/sqlite/CentralAppConfigDb;", "app-ktor-server"})
public final class GenerateSystemConfigAuthUseCase {
    @NotNull
    private final Pbkdf2EncryptUseCase encryptor;
    @NotNull
    private final File dataDirPath;

    public GenerateSystemConfigAuthUseCase(@NotNull Pbkdf2EncryptUseCase encryptor, @NotNull File dataDirPath) {
        Intrinsics.checkNotNullParameter((Object)encryptor, (String)"encryptor");
        Intrinsics.checkNotNullParameter((Object)dataDirPath, (String)"dataDirPath");
        this.encryptor = encryptor;
        this.dataDirPath = dataDirPath;
    }

    public final void invoke(@NotNull CentralAppConfigDb centralAppConfigDb) {
        Intrinsics.checkNotNullParameter((Object)centralAppConfigDb, (String)"centralAppConfigDb");
        String salt = RandomStringKt.randomString$default((int)16, null, (int)2, null);
        String password = RandomStringKt.randomString$default((int)16, null, (int)2, null);
        String encryptedPassBase64 = ByteArrayExtActualKt.encodeBase64((byte[])Pbkdf2EncryptUseCase.invoke$default((Pbkdf2EncryptUseCase)this.encryptor, (String)password, (String)salt, (int)0, (int)0, (int)12, null));
        SystemConfigAuthQueries systemConfigAuthQueries = centralAppConfigDb.getSystemConfigAuthQueries();
        Intrinsics.checkNotNull((Object)encryptedPassBase64);
        systemConfigAuthQueries.insert(new SystemConfigAuth(1L, 1L, "admin", encryptedPassBase64, salt));
        FilesKt.writeText$default((File)new File(this.dataDirPath, "admin.txt"), (String)password, null, (int)2, null);
    }
}

