package com.ustadmobile.centralappconfigdb.db

import app.cash.sqldelight.Query
import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlCursor
import app.cash.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Long
import kotlin.String

public class LearningSpaceQueries(
  driver: SqlDriver,
) : TransacterImpl(driver) {
  public fun <T : Any> selectAll(mapper: (
    lsUid: Long,
    lsUrl: String,
    lsName: String,
    lsDescription: String,
    lsLastModified: Long,
    lsDbUrl: String,
    lsDbUsername: String?,
    lsDbPassword: String?,
  ) -> T): Query<T> = Query(1_223_459_657, arrayOf("LearningSpaceEntity"), driver,
      "LearningSpace.sq", "selectAll", """
  |SELECT LearningSpaceEntity.lsUid, LearningSpaceEntity.lsUrl, LearningSpaceEntity.lsName, LearningSpaceEntity.lsDescription, LearningSpaceEntity.lsLastModified, LearningSpaceEntity.lsDbUrl, LearningSpaceEntity.lsDbUsername, LearningSpaceEntity.lsDbPassword
  |FROM LearningSpaceEntity
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)!!,
      cursor.getString(5)!!,
      cursor.getString(6),
      cursor.getString(7)
    )
  }

  public fun selectAll(): Query<LearningSpaceEntity> = selectAll { lsUid, lsUrl, lsName,
      lsDescription, lsLastModified, lsDbUrl, lsDbUsername, lsDbPassword ->
    LearningSpaceEntity(
      lsUid,
      lsUrl,
      lsName,
      lsDescription,
      lsLastModified,
      lsDbUrl,
      lsDbUsername,
      lsDbPassword
    )
  }

  public fun <T : Any> findByUid(uid: Long, mapper: (
    lsUid: Long,
    lsUrl: String,
    lsName: String,
    lsDescription: String,
    lsLastModified: Long,
    lsDbUrl: String,
    lsDbUsername: String?,
    lsDbPassword: String?,
  ) -> T): Query<T> = FindByUidQuery(uid) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)!!,
      cursor.getString(5)!!,
      cursor.getString(6),
      cursor.getString(7)
    )
  }

  public fun findByUid(uid: Long): Query<LearningSpaceEntity> = findByUid(uid) { lsUid, lsUrl,
      lsName, lsDescription, lsLastModified, lsDbUrl, lsDbUsername, lsDbPassword ->
    LearningSpaceEntity(
      lsUid,
      lsUrl,
      lsName,
      lsDescription,
      lsLastModified,
      lsDbUrl,
      lsDbUsername,
      lsDbPassword
    )
  }

  public fun insertFullObject(LearningSpaceEntity: LearningSpaceEntity) {
    driver.execute(-1_046_816_381, """
        |INSERT OR REPLACE INTO LearningSpaceEntity(lsUid, lsUrl, lsName, lsDescription, lsLastModified, lsDbUrl, lsDbUsername, lsDbPassword)
        |VALUES (?, ?, ?, ?, ?, ?, ?, ?)
        """.trimMargin(), 8) {
          bindLong(0, LearningSpaceEntity.lsUid)
          bindString(1, LearningSpaceEntity.lsUrl)
          bindString(2, LearningSpaceEntity.lsName)
          bindString(3, LearningSpaceEntity.lsDescription)
          bindLong(4, LearningSpaceEntity.lsLastModified)
          bindString(5, LearningSpaceEntity.lsDbUrl)
          bindString(6, LearningSpaceEntity.lsDbUsername)
          bindString(7, LearningSpaceEntity.lsDbPassword)
        }
    notifyQueries(-1_046_816_381) { emit ->
      emit("LearningSpaceEntity")
    }
  }

  public fun update(
    name: String?,
    description: String?,
    uid: Long,
  ) {
    driver.execute(1_244_796_677, """
        |UPDATE LearningSpaceEntity
        |   SET lsName = (CASE
        |                WHEN ? IS NOT NULL THEN ?
        |                ELSE lsName
        |                END),
        |       lsDescription = (CASE
        |                        WHEN ? IS NOT NULL THEN ?
        |                        ELSE lsDescription
        |                        END)
        | WHERE lsUid = ?
        """.trimMargin(), 5) {
          bindString(0, name)
          bindString(1, name)
          bindString(2, description)
          bindString(3, description)
          bindLong(4, uid)
        }
    notifyQueries(1_244_796_677) { emit ->
      emit("LearningSpaceEntity")
    }
  }

  private inner class FindByUidQuery<out T : Any>(
    public val uid: Long,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("LearningSpaceEntity", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("LearningSpaceEntity", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(-952_059_260, """
    |SELECT LearningSpaceEntity.lsUid, LearningSpaceEntity.lsUrl, LearningSpaceEntity.lsName, LearningSpaceEntity.lsDescription, LearningSpaceEntity.lsLastModified, LearningSpaceEntity.lsDbUrl, LearningSpaceEntity.lsDbUsername, LearningSpaceEntity.lsDbPassword
    |  FROM LearningSpaceEntity
    | WHERE lsUid = ?
    """.trimMargin(), mapper, 1) {
      bindLong(0, uid)
    }

    override fun toString(): String = "LearningSpace.sq:findByUid"
  }
}
