/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.sharedse.impl.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/ustadmobile/port/sharedse/impl/http/RangeInputStream;", "Ljava/io/FilterInputStream;", "in", "Ljava/io/InputStream;", "start", "", "end", "(Ljava/io/InputStream;JJ)V", "markSupported", "", "pos", "resetInvalidate", "resetPos", "available", "", "mark", "", "readlimit", "read", "buffer", "", "byteOffset", "byteCount", "reset", "skip", "sharedse"})
public final class RangeInputStream
extends FilterInputStream {
    private final long end;
    private long pos;
    private final boolean markSupported;
    private long resetPos;
    private long resetInvalidate;

    public RangeInputStream(@NotNull InputStream in, long start, long end) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        super(in);
        this.end = end;
        this.markSupported = in.markSupported();
        this.resetPos = -1L;
        this.resetInvalidate = -1L;
        this.pos = 0L;
        for (long startBytesSkipped = 0L; startBytesSkipped < start; startBytesSkipped += this.skip(start - startBytesSkipped)) {
        }
    }

    @Override
    public int read() throws IOException {
        if (this.pos <= this.end) {
            long l = this.pos;
            this.pos = l + 1L;
            return this.in.read();
        }
        return -1;
    }

    @Override
    public int read(@NotNull byte[] buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(@NotNull byte[] buffer, int byteOffset, int byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int byteCount2 = byteCount;
        byteCount2 = (int)Math.min(this.end + 1L - this.pos, (long)byteCount2);
        if (byteCount2 > 0) {
            int bytesRead = this.in.read(buffer, byteOffset, byteCount2);
            this.pos += (long)bytesRead;
            return bytesRead;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        return super.available();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.resetPos != -1L && this.pos < this.resetInvalidate) {
            this.in.reset();
            this.pos = this.resetPos;
        }
    }

    @Override
    public long skip(long byteCount) throws IOException {
        int skipped = (int)this.in.skip(byteCount);
        this.pos += (long)skipped;
        return skipped;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.markSupported) {
            this.resetPos = this.pos;
            this.resetInvalidate = this.pos + (long)readlimit;
        }
        super.mark(readlimit);
    }
}

