/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.PagingState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\"\u001a\u001c\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0019\u0018\u00010#J\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0019J\u0016\u0010%\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0007J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010\nR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Landroidx/paging/AccessorState;", "Key", "", "Value", "()V", "blockStates", "", "Landroidx/paging/AccessorState$BlockState;", "[Landroidx/paging/AccessorState$BlockState;", "errors", "Landroidx/paging/LoadState$Error;", "[Landroidx/paging/LoadState$Error;", "pendingRequests", "Lkotlin/collections/ArrayDeque;", "Landroidx/paging/AccessorState$PendingRequest;", "refreshAllowed", "", "getRefreshAllowed", "()Z", "setRefreshAllowed", "(Z)V", "add", "loadType", "Landroidx/paging/LoadType;", "pagingState", "Landroidx/paging/PagingState;", "clearErrors", "", "clearPendingRequest", "clearPendingRequests", "computeLoadStates", "Landroidx/paging/LoadStates;", "computeLoadTypeState", "Landroidx/paging/LoadState;", "getPendingBoundary", "Lkotlin/Pair;", "getPendingRefresh", "setBlockState", "state", "setError", "errorState", "BlockState", "PendingRequest", "paging-common"})
@SourceDebugExtension(value={"SMAP\nRemoteMediatorAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteMediatorAccessor.kt\nandroidx/paging/AccessorState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,460:1\n1747#2,3:461\n288#2,2:464\n288#2,2:466\n288#2,2:468\n*S KotlinDebug\n*F\n+ 1 RemoteMediatorAccessor.kt\nandroidx/paging/AccessorState\n*L\n133#1:461,3\n173#1:464,2\n220#1:466,2\n224#1:468,2\n*E\n"})
final class AccessorState<Key, Value> {
    @NotNull
    private final BlockState[] blockStates;
    @NotNull
    private final LoadState.Error[] errors;
    @NotNull
    private final ArrayDeque<PendingRequest<Key, Value>> pendingRequests;
    private boolean refreshAllowed;

    public AccessorState() {
        int n;
        int n2 = 0;
        int n3 = LoadType.values().length;
        Object[] objectArray = new BlockState[n3];
        AccessorState accessorState = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = BlockState.UNBLOCKED;
        }
        accessorState.blockStates = objectArray;
        n2 = 0;
        n3 = LoadType.values().length;
        objectArray = new LoadState.Error[n3];
        accessorState = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = null;
        }
        accessorState.errors = objectArray;
        this.pendingRequests = new ArrayDeque();
    }

    public final boolean getRefreshAllowed() {
        return this.refreshAllowed;
    }

    public final void setRefreshAllowed(boolean bl) {
        this.refreshAllowed = bl;
    }

    @NotNull
    public final LoadStates computeLoadStates() {
        LoadState loadState = this.computeLoadTypeState(LoadType.REFRESH);
        LoadState loadState2 = this.computeLoadTypeState(LoadType.APPEND);
        LoadState loadState3 = this.computeLoadTypeState(LoadType.PREPEND);
        return new LoadStates(loadState, loadState3, loadState2);
    }

    private final LoadState computeLoadTypeState(LoadType loadType) {
        LoadState loadState;
        boolean hasPending;
        BlockState blockState;
        block10: {
            boolean bl;
            blockState = this.blockStates[loadType.ordinal()];
            Iterable $this$any$iv = this.pendingRequests;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PendingRequest it = (PendingRequest)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLoadType() == loadType)) continue;
                    bl = true;
                    break block10;
                }
                bl = hasPending = false;
            }
        }
        if (hasPending && blockState != BlockState.REQUIRES_REFRESH) {
            return LoadState.Loading.INSTANCE;
        }
        LoadState.Error error = this.errors[loadType.ordinal()];
        if (error != null) {
            LoadState.Error it = error;
            boolean bl = false;
            return it;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[blockState.ordinal()]) {
            case 1: {
                loadState = WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()] == 1 ? LoadState.NotLoading.Companion.getIncomplete$paging_common() : LoadState.NotLoading.Companion.getComplete$paging_common();
                break;
            }
            case 2: {
                loadState = LoadState.NotLoading.Companion.getIncomplete$paging_common();
                break;
            }
            case 3: {
                loadState = LoadState.NotLoading.Companion.getIncomplete$paging_common();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return loadState;
    }

    public final boolean add(@NotNull LoadType loadType, @NotNull PagingState<Key, Value> pagingState) {
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)loadType, "loadType");
            Intrinsics.checkNotNullParameter(pagingState, "pagingState");
            Iterable $this$firstOrNull$iv = this.pendingRequests;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PendingRequest it = (PendingRequest)element$iv;
                boolean bl = false;
                if (!(it.getLoadType() == loadType)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        PendingRequest existing = v0;
        if (existing != null) {
            existing.setPagingState(pagingState);
            return false;
        }
        BlockState blockState = this.blockStates[loadType.ordinal()];
        if (blockState == BlockState.REQUIRES_REFRESH && loadType != LoadType.REFRESH) {
            this.pendingRequests.add(new PendingRequest<Key, Value>(loadType, pagingState));
            return false;
        }
        if (blockState != BlockState.UNBLOCKED && loadType != LoadType.REFRESH) {
            return false;
        }
        if (loadType == LoadType.REFRESH) {
            this.setError(LoadType.REFRESH, null);
        }
        return this.errors[loadType.ordinal()] == null ? this.pendingRequests.add(new PendingRequest<Key, Value>(loadType, pagingState)) : false;
    }

    public final void setBlockState(@NotNull LoadType loadType, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)loadType, "loadType");
        Intrinsics.checkNotNullParameter((Object)state, "state");
        this.blockStates[loadType.ordinal()] = state;
    }

    @Nullable
    public final PagingState<Key, Value> getPendingRefresh() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.pendingRequests;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PendingRequest it = (PendingRequest)element$iv;
                boolean bl = false;
                if (!(it.getLoadType() == LoadType.REFRESH)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PendingRequest pendingRequest = v0;
        return pendingRequest != null ? pendingRequest.getPagingState() : null;
    }

    @Nullable
    public final Pair<LoadType, PagingState<Key, Value>> getPendingBoundary() {
        Pair pair;
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this.pendingRequests;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PendingRequest it = (PendingRequest)element$iv;
                boolean bl = false;
                if (!(it.getLoadType() != LoadType.REFRESH && this.blockStates[it.getLoadType().ordinal()] == BlockState.UNBLOCKED)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PendingRequest pendingRequest = v0;
        if (pendingRequest != null) {
            PendingRequest it = pendingRequest;
            boolean bl = false;
            pair = TuplesKt.to(it.getLoadType(), it.getPagingState());
        } else {
            pair = null;
        }
        return pair;
    }

    public final void clearPendingRequests() {
        this.pendingRequests.clear();
    }

    public final void clearPendingRequest(@NotNull LoadType loadType) {
        Intrinsics.checkNotNullParameter((Object)loadType, "loadType");
        CollectionsKt.removeAll((List)this.pendingRequests, (Function1)new Function1<PendingRequest<Key, Value>, Boolean>(loadType){
            final /* synthetic */ LoadType $loadType;
            {
                this.$loadType = $loadType;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PendingRequest<Key, Value> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getLoadType() == this.$loadType;
            }
        });
    }

    public final void clearErrors() {
        int n = this.errors.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.errors[i2] = null;
        }
    }

    public final void setError(@NotNull LoadType loadType, @Nullable LoadState.Error errorState) {
        Intrinsics.checkNotNullParameter((Object)loadType, "loadType");
        this.errors[loadType.ordinal()] = errorState;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/paging/AccessorState$BlockState;", "", "(Ljava/lang/String;I)V", "UNBLOCKED", "COMPLETED", "REQUIRES_REFRESH", "paging-common"})
    public static final class BlockState
    extends Enum<BlockState> {
        public static final /* enum */ BlockState UNBLOCKED = new BlockState();
        public static final /* enum */ BlockState COMPLETED = new BlockState();
        public static final /* enum */ BlockState REQUIRES_REFRESH = new BlockState();
        private static final /* synthetic */ BlockState[] $VALUES;

        public static BlockState[] values() {
            return (BlockState[])$VALUES.clone();
        }

        public static BlockState valueOf(String value) {
            return Enum.valueOf(BlockState.class, value);
        }

        static {
            $VALUES = blockStateArray = new BlockState[]{BlockState.UNBLOCKED, BlockState.COMPLETED, BlockState.REQUIRES_REFRESH};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00022\u00020\u0002B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/paging/AccessorState$PendingRequest;", "Key", "", "Value", "loadType", "Landroidx/paging/LoadType;", "pagingState", "Landroidx/paging/PagingState;", "(Landroidx/paging/LoadType;Landroidx/paging/PagingState;)V", "getLoadType", "()Landroidx/paging/LoadType;", "getPagingState", "()Landroidx/paging/PagingState;", "setPagingState", "(Landroidx/paging/PagingState;)V", "paging-common"})
    public static final class PendingRequest<Key, Value> {
        @NotNull
        private final LoadType loadType;
        @NotNull
        private PagingState<Key, Value> pagingState;

        public PendingRequest(@NotNull LoadType loadType, @NotNull PagingState<Key, Value> pagingState) {
            Intrinsics.checkNotNullParameter((Object)loadType, "loadType");
            Intrinsics.checkNotNullParameter(pagingState, "pagingState");
            this.loadType = loadType;
            this.pagingState = pagingState;
        }

        @NotNull
        public final LoadType getLoadType() {
            return this.loadType;
        }

        @NotNull
        public final PagingState<Key, Value> getPagingState() {
            return this.pagingState;
        }

        public final void setPagingState(@NotNull PagingState<Key, Value> pagingState) {
            Intrinsics.checkNotNullParameter(pagingState, "<set-?>");
            this.pagingState = pagingState;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.REFRESH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BlockState.values().length];
            try {
                nArray[BlockState.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockState.REQUIRES_REFRESH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockState.UNBLOCKED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

