/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.PathBuilder;
import com.typesafe.config.impl.PathParser;
import java.util.Iterator;
import java.util.List;

final class Path {
    private final String first;
    private final Path remainder;

    Path(String first2, Path remainder) {
        this.first = first2;
        this.remainder = remainder;
    }

    Path(String ... elements) {
        if (elements.length == 0) {
            throw new ConfigException.BugOrBroken("empty path");
        }
        this.first = elements[0];
        if (elements.length > 1) {
            PathBuilder pb = new PathBuilder();
            for (int i2 = 1; i2 < elements.length; ++i2) {
                pb.appendKey(elements[i2]);
            }
            this.remainder = pb.result();
        } else {
            this.remainder = null;
        }
    }

    Path(List<Path> pathsToConcat) {
        this(pathsToConcat.iterator());
    }

    Path(Iterator<Path> i2) {
        if (!i2.hasNext()) {
            throw new ConfigException.BugOrBroken("empty path");
        }
        Path firstPath = i2.next();
        this.first = firstPath.first;
        PathBuilder pb = new PathBuilder();
        if (firstPath.remainder != null) {
            pb.appendPath(firstPath.remainder);
        }
        while (i2.hasNext()) {
            pb.appendPath(i2.next());
        }
        this.remainder = pb.result();
    }

    String first() {
        return this.first;
    }

    Path remainder() {
        return this.remainder;
    }

    Path parent() {
        if (this.remainder == null) {
            return null;
        }
        PathBuilder pb = new PathBuilder();
        Path p2 = this;
        while (p2.remainder != null) {
            pb.appendKey(p2.first);
            p2 = p2.remainder;
        }
        return pb.result();
    }

    String last() {
        Path p2 = this;
        while (p2.remainder != null) {
            p2 = p2.remainder;
        }
        return p2.first;
    }

    Path prepend(Path toPrepend) {
        PathBuilder pb = new PathBuilder();
        pb.appendPath(toPrepend);
        pb.appendPath(this);
        return pb.result();
    }

    int length() {
        int count2 = 1;
        Path p2 = this.remainder;
        while (p2 != null) {
            ++count2;
            p2 = p2.remainder;
        }
        return count2;
    }

    Path subPath(int removeFromFront) {
        Path p2 = this;
        for (int count2 = removeFromFront; p2 != null && count2 > 0; --count2) {
            p2 = p2.remainder;
        }
        return p2;
    }

    Path subPath(int firstIndex, int lastIndex) {
        if (lastIndex < firstIndex) {
            throw new ConfigException.BugOrBroken("bad call to subPath");
        }
        Path from2 = this.subPath(firstIndex);
        PathBuilder pb = new PathBuilder();
        for (int count2 = lastIndex - firstIndex; count2 > 0; --count2) {
            pb.appendKey(from2.first());
            if ((from2 = from2.remainder()) != null) continue;
            throw new ConfigException.BugOrBroken("subPath lastIndex out of range " + lastIndex);
        }
        return pb.result();
    }

    boolean startsWith(Path other) {
        Path myRemainder = this;
        Path otherRemainder = other;
        if (otherRemainder.length() <= myRemainder.length()) {
            while (otherRemainder != null) {
                if (!otherRemainder.first().equals(myRemainder.first())) {
                    return false;
                }
                myRemainder = myRemainder.remainder();
                otherRemainder = otherRemainder.remainder();
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof Path) {
            Path that = (Path)other;
            return this.first.equals(that.first) && ConfigImplUtil.equalsHandlingNull(this.remainder, that.remainder);
        }
        return false;
    }

    public int hashCode() {
        return 41 * (41 + this.first.hashCode()) + (this.remainder == null ? 0 : this.remainder.hashCode());
    }

    static boolean hasFunkyChars(String s2) {
        int length = s2.length();
        if (length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            char c = s2.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
            return true;
        }
        return false;
    }

    private void appendToStringBuilder(StringBuilder sb) {
        if (Path.hasFunkyChars(this.first) || this.first.isEmpty()) {
            sb.append(ConfigImplUtil.renderJsonString(this.first));
        } else {
            sb.append(this.first);
        }
        if (this.remainder != null) {
            sb.append(".");
            this.remainder.appendToStringBuilder(sb);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Path(");
        this.appendToStringBuilder(sb);
        sb.append(")");
        return sb.toString();
    }

    String render() {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb);
        return sb.toString();
    }

    static Path newKey(String key2) {
        return new Path(key2, null);
    }

    static Path newPath(String path) {
        return PathParser.parsePath(path);
    }
}

