/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.util.PropertyElf;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

public class HikariJNDIFactory
implements ObjectFactory {
    @Override
    public synchronized Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment2) throws Exception {
        if (obj instanceof Reference && "javax.sql.DataSource".equals(((Reference)obj).getClassName())) {
            Reference ref = (Reference)obj;
            Set<String> hikariPropSet = PropertyElf.getPropertyNames(HikariConfig.class);
            Properties properties2 = new Properties();
            Enumeration<RefAddr> enumeration = ref.getAll();
            while (enumeration.hasMoreElements()) {
                RefAddr element2 = enumeration.nextElement();
                String type2 = element2.getType();
                if (!type2.startsWith("dataSource.") && !hikariPropSet.contains(type2)) continue;
                properties2.setProperty(type2, element2.getContent().toString());
            }
            return this.createDataSource(properties2, nameCtx);
        }
        return null;
    }

    private DataSource createDataSource(Properties properties2, Context context) throws NamingException {
        String jndiName = properties2.getProperty("dataSourceJNDI");
        if (jndiName != null) {
            return this.lookupJndiDataSource(properties2, context, jndiName);
        }
        return new HikariDataSource(new HikariConfig(properties2));
    }

    private DataSource lookupJndiDataSource(Properties properties2, Context context, String jndiName) throws NamingException {
        if (context == null) {
            throw new RuntimeException("JNDI context does not found for dataSourceJNDI : " + jndiName);
        }
        DataSource jndiDS = (DataSource)context.lookup(jndiName);
        if (jndiDS == null) {
            InitialContext ic = new InitialContext();
            jndiDS = (DataSource)ic.lookup(jndiName);
            ic.close();
        }
        if (jndiDS != null) {
            HikariConfig config2 = new HikariConfig(properties2);
            config2.setDataSource(jndiDS);
            return new HikariDataSource(config2);
        }
        return null;
    }
}

